case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot=".."
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

: Avoid duplicate option
if $test "X$dynamic_opt" != "X$backtrace_opt" ; then
   XX="$backtrace_opt"
else
   XX=
fi

liblist="mime mbox base misc addr"
echo "Extracting utils/readmsg/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# @(#)$Id: Makefile.SH,v 2.10 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the Elm (ME+) system utilities
#
# Modified by Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
# 	       	      (was hurtta+elm@posti.FMI.FI)
#          or Kari Hurtta <elm@elmme-mailer.org>
######################################################################
# Based on utils/Makefile.SH. That code was following copyright:
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
######################################################################
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
CP		=	$cp
DEST		=	\$(ELM_ROOT)//$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $dynamic_opt $XX $xenlf
LIB		=	\$(ELM_ROOT)//$lib
LIB2		= 	$dlopen_lib $libs
LIB1		=	$cryptlib $dbm
LINT		=	$lint
LN		=	$ln
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
REG		=	../bin/elmregister

!GROK!THIS!

if $test "X$rpath_ok" = XOK ; then

# Use -rpath for directories need by shared_libs 
# It is is possbile to also use -rpath-link on Linux and SunOS
# but it may require extra Configure test....

	 rlink=
	 for domake in $shared_list ; do
		dir=
		varname="\$${domake}_lib_dir"
		eval "dir=$varname"
		if $test "X$dir" != X ; then
			rlink="$rlink $rpath_opt$dir"
		fi
	 done

	 cat >>Makefile <<!GROK!THIS!
RPATH           =       $rpath_opt$shlib $rlink
!GROK!THIS!

else
	 cat >>Makefile <<!GROK!THIS!
RPATH           =       
!GROK!THIS!

fi

if $test "$make_sets_make" != "$define" ; then  

	cat >>Makefile <<!GROK!THIS!
MAKE		=	$make
!GROK!THIS!

fi

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
SHLIST          = $(BIN)/readmsg-shared
!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =
!NO!SUBS!

fi


cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
BIN		=	../../bin
LIBS		=	../../libs
SHLIB		=	../../shlib
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh
REG             =       ../../bin/elmregister
OBJS            =       readmsg.o fstate.o wrapper.o folder.o

# Standard targets
all:		Makefile $(BIN)/readmsg $(SHLIST)

install_s:	Makefile $(DEST) $(DEST)/readmsg

uninstall_s:	
		$(REG) rm $(DEST)/readmsg

Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

clean: 
	rm -f $(OBJS) $(BIN)/readmsg $(SHLIST)

lint:		

tags:

.PRECIOUS:		def_readmsg.h $(IHDR)/elm_defs.h $(IHDR)/defs_major.h 


#	Dependencies of header files upon other header files they include
$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h $(IHDR)/misclib.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@


def_readmsg.h:		$(IHDR)/elm_defs.h $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/melib.h $(INCLDIR)/mime.h $(IHDR)/misclib.h \
 $(INCLDIR)/addrlib.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@


# Dependencies and rules
#	Dependencies and rules for compiling C programs

readmsg.o: def_readmsg.h $(INCLDIR)/s_readmsg.h $(INCLDIR)/readmsg.h
fstate.o:  def_readmsg.h
wrapper.o: def_readmsg.h
folder.o:  def_readmsg.h


$(BIN)/readmsg:		$(OBJS) $(LIBS)/libelmme-mime.a \
$(LIBS)/libelmme-base.a $(LIBS)/libelmme-misc.a $(LIBS)/libelmme-mbox.a \
 $(LIBS)/libelmme-addr.a
			$(CC) $(LFLAGS) -o $@ $(OBJS) \
 $(LIBS)/libelmme-mime.a $(LIBS)/libelmme-misc.a $(LIBS)/libelmme-mbox.a \
 $(LIBS)/libelmme-addr.a $(LIBS)/libelmme-base.a $(LIB1) $(LIB2)

!NO!SUBS!

for i in $liblist
do
   cat >>Makefile <<SUBS
\$(LIBS)/libelmme-$i.a:
	cd ../..; \$(MAKE) \$(MJ) \$(MFLAGS) libs/libelmme-$i.a

SUBS

done

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

$(BIN)/readmsg-shared:		$(OBJS) $(SHLIB)/libelmme-base.so \
 $(SHLIB)/libelmme-mbox.so $(SHLIB)/libelmme-mime.so $(SHLIB)/libelmme-misc.so \
 $(SHLIB)/libelmme-addr.so
		$(CC) $(LFLAGS) -o $@ $(RPATH) $(OBJS) \
 $(SHLIB)/libelmme-mime.so  $(SHLIB)/libelmme-misc.so \
 $(SHLIB)/libelmme-mbox.so $(SHLIB)/libelmme-addr.so \
 $(SHLIB)/libelmme-base.so  $(LIB1) $(LIB2)

$(DEST)/readmsg:	$(BIN)/readmsg-shared
			$(REG) copy -m 755 $? $@

!NO!SUBS!

for i in $liblist
do
   cat >>Makefile <<SUBS
\$(SHLIB)/libelmme-$i.so:
	cd ../..; \$(MAKE) \$(MJ) \$(MFLAGS) shlib/libelmme-$i.so

SUBS

done

else

cat >>Makefile <<'!NO!SUBS!'

$(DEST)/readmsg:	$(BIN)/readmsg
			$(REG) copy -m 755 $? $@

!NO!SUBS!

fi

