static char rcsid[] = "@(#)$Id: elmmailservices.c,v 2.7 2018/12/21 11:21:43 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_utils.h"
#include "misclib.h"
#include "reghelper.h"
#include "s_me.h"
#include "s_elm.h"

extern char *optarg;		
extern int   optind;		

DEBUG_VAR(Debug,__FILE__,"util");

const char * program_name = "elmmailservices";
int    register_fd  = -1;
char * register_module = NULL;

static char version_buff[NLEN];

static const char OPTION_LETTERS[] = "Gd:w:cC:r:";

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    int err = 0;
    int c;
    int global = 0;    

    char *targetfile = NULL;
    FILE * commentfile = NULL;
    int config_merge = 0;
    struct mail_services_conf *  MAP UNUSED_VAROK  = NULL;    
    charset_t                cs  UNUSED_VAROK  = NULL;
    struct editor_propline * pl  UNUSED_VAROK  = NULL;
    int read_flags = 0;
    
#if DEBUG
    init_debugfile("ELMMAILSERVICES");
#endif

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'd' : 	
#if DEBUG
	    set_debugging(optarg);	  
#endif
	    /* Error is printed later */
	    break;
	}
    }
    optind = 1;     /* Reset scanning */

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;


    locale_init();
    
    REGHELPER_INIT(argv[0]);
    
    user_init();
    
    init_defaults(read_flags);

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'c':
	    config_merge++;
	    break;

	case 'C':
	    if (0 != access(optarg,READ_ACCESS)) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
	    }

	    commentfile = fopen(optarg,"r");
	    if (!commentfile) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
		
	    }
	    break;

	case 'd' : 
#if DEBUG
	    set_debugging(optarg);	 
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;

	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'w' : 
	    targetfile = optarg;
	    if (0 != access(targetfile,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      targetfile, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }
	    break;
	case '?':
	    err = 1;
	    goto fail;
	}
    }
    
    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);

#ifdef DEBUG
    { 
	int d UNUSED_VAROK = panic_dprint("\n\
======================================================\n\
Debug output of the ELMMAILSERVICES program (version %s).\n",
			     version_buff);

#if 0	
	if (d >= 50) {
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
	    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
	}
#endif
    }
#endif

    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);

#ifdef REMOTE_MBX
    
    if (optind < argc) {
	int errcount = 0;

	MAP = parse_service_entries(argv[optind],&errcount,NULL,NULL);

	if (!MAP || errcount) {
	    err = 1;
	    goto fail;
	}	
    }

   if (config_merge) {

	if (!MAP) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeMap,
			      "Config merge (-c) requires map as argument"));
	    err++;
	    goto fail;
	}

	if (targetfile) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeNoW,
			      "Config merge (-c) Can not used with -w"));
	    err++;
	    goto fail;
	}

	if (global) {

	    change_mail_services_conf(& system_mail_services_conf, MAP);
	    free_mail_services_conf(& MAP);

	    MAP = system_mail_services_conf;
	    targetfile = system_mail_services;
	    cs  = system_mail_services_cs;
	    pl  = system_mail_services_pl;

	} else {

	    change_mail_services_conf(& user_mail_services_conf, MAP);
	    free_mail_services_conf(& MAP);

	    MAP = user_mail_services_conf;
	    targetfile = user_mail_services;
	    cs  = user_mail_services_cs;
	    pl  = user_mail_services_pl;
	    
	}

   	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, strerror(errcode));
		err++;
		goto fail;
	    }
	}
    }

   if (!MAP) {
	if (global)
	    MAP = system_mail_services_conf;
	else
	    MAP = user_mail_services_conf;
   }

   if (targetfile) {
	char * tmp = elm_message(FRM("%s.N"),targetfile);
	int errcode = can_open(tmp,"w");
	FILE *f;
	
	if (errcode) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	f = fopen(tmp,"w");
	if (!f) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}

	if (! dump_service_entries(f,MAP,commentfile,
				   "ELMMAILSERVICES",version_buff,
				   cs,pl)) {
	    err++;
	    fclose(f);
	    free(tmp);
	    goto fail;	
	}

	if (EOF == fclose(f)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}

	if (0 != rename(tmp,targetfile)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			      "Failed to rename temporary file to %.50s: %.30s"),
		      targetfile, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	log_config(targetfile);
	free(tmp);

   } else {

       if (! dump_service_entries(stdout,MAP,commentfile,
				  "ELMMAILSERVICES",version_buff,
				  system_charset,pl)) {
	   err++;
	   goto fail;
       }
   }

#else
   lib_error(FRM("%s unsupported --  REMOTE_MBX not defined\n"),argv[0]);
#endif

 fail:
   if (commentfile)
       fclose(commentfile);

#ifdef REMOTE_MBX

   if (MAP &&
       MAP != system_mail_services_conf &&
       MAP != user_mail_services_conf)
       free_mail_services_conf(& MAP);
#endif


    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);
    
    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

