static char rcsid[] = "@(#)$Id: elmlibregister.c,v 2.8 2020/05/21 02:58:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Some code based on Elm 2.4 src/save_opts.c (but that code may be moved to 
 *  lib/write_rc.c)
 * That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_utils.h"
#include "schedule_time.h"
#include "addrlib.h"
#include "mailerlib.h"
#include "mboxlib.h"
#include "s_me.h"
#include "s_elm.h"
#include "s_elmrc.h"

#include "rc_imp.h"
#include "save_opts.h"

#include "reghelper.h"

DEBUG_VAR(Debug,__FILE__,"util");

extern char *optarg;		
extern int   optind;		

int    register_fd     = -1; 
const char * program_name    = "elmlibregister"; 
char * register_module = NULL;

static char version_buff[NLEN];

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    int err = 0;
    int global = 0;
    int c;
    int write_default = 0;
    char * targetfile = NULL;
    FILE * commentfile = NULL;
    char * elmrc_changes = NULL;
    struct elmrc_recorder * recorder = NULL;
    FILE * elmrc_changes_F = NULL;

    int read_flags = 0;
    
#if DEBUG
    init_debugfile("ELMLIBREGISTER");
#endif
    locale_init();

    REGHELPER_INIT(argv[0]);

    while ((c = getopt(argc, argv, "GId:w:C:r:c:")) != EOF) {
	
	switch(c) {
	case 'G':
	    global++;
	    break;

	case 'I':
	    write_default++;
	    break;
	    
	case 'd':
#if DEBUG
	    set_debugging(optarg);	 
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;
	    
	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'w' : 
	    targetfile = optarg;
	    if (0 != access(targetfile,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      targetfile, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }
	    break;


	case 'c':
	    elmrc_changes = optarg;
	    if (0 != access(elmrc_changes,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      elmrc_changes, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }


	    elmrc_changes_F = open_or_create(elmrc_changes);
	    if (!elmrc_changes_F) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      elmrc_changes, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }

	    break;

	case 'C':
	    if (0 != access(optarg,READ_ACCESS)) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
	    }

	    commentfile = fopen(optarg,"r");
	    if (!commentfile) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
		
	    }
	    break;

	case '?':
	    err = 1;
	    goto fail;
	}

    }

    user_init();

    if (elmrc_changes_F) {
	recorder = enable_recorder(global ? SYSTEM_RC : LOCAL_RC);
	
	seed_history(elmrc_changes_F,elmrc_changes,recorder);
    }

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;
    
    init_mailerlib(read_flags);
    init_mboxlib(read_flags);
    init_defaults(read_flags);

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);


#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMLIBREGISTER program (version %s).\n",
			     version_buff);

	if (d >= 50) {
#if 0	
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
	    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
#endif
	}
    }
#endif

    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);
    
    if (optind < argc) {
	test_and_set_shared(& argv[optind] , targetfile || write_default);
    } else {
	/* NO libraries .. only check current .... */
	test_and_set_shared( NULL , targetfile || write_default);
    }



    if (targetfile && write_default) {
	lib_error(CATGETS(elm_msg_cat, ElmrcSet, ElmrcNoBothwI,
			  "Can't specify both -w and -I options!"));
	err++;
	goto fail;

    }
    if (write_default)
	targetfile = global ? system_rc_file : user_rc_file;


    if (targetfile) {

	int r = write_rc(targetfile,commentfile,global,
			 "ELMLIBREGISTER",NULL,version_buff);
       
	if (!r) {
	    err++;
	    goto fail;
	}

	log_config(targetfile);
    }

    if (elmrc_changes_F) {
	rewind(elmrc_changes_F);

#ifdef FTRUNCATE
	/* Not really necessary */
	if (-1 == ftruncate(fileno(elmrc_changes_F),0)) {
	    DPRINT(Debug,27,(&Debug,"ftruncate of %s failed\n",elmrc_changes));
	}
#endif

	print_history_changed(elmrc_changes_F,recorder);

    }

 fail:
    if (elmrc_changes_F) 
	fclose(elmrc_changes_F);

    if (commentfile)
	fclose(commentfile);

    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);

    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
