static char rcsid[] = "@(#)$Id: elmiso2022sets.c,v 2.3 2018/12/21 11:21:43 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_utils.h"
#include "s_me.h"
#include "s_elm.h"
#include "cs_imp.h"
#include "misclib.h"

#include "reghelper.h"

DEBUG_VAR(Debug,__FILE__,"util");

extern char *optarg;		
extern int   optind;		

const char * program_name = "elmiso2022sets";
int    register_fd  = -1;
char * register_module = NULL;

#include "charmapcopy.h"

static char version_buff[NLEN];

const char OPTION_LETTERS[] = "Gd:w:S:cr:C:";

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    int err = 0;
    int c;
    int global = 0;
    struct iso2022_map_conf   * MAP = NULL;
    char *targetfile = NULL;
    FILE * commentfile = NULL;
    int config_merge = 0;
    int read_flags = 0;

#if DEBUG
    init_debugfile("ELMISO2022SETS");
#endif

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'd':
#if DEBUG
	    set_debugging(optarg);
#endif
	    /* Error is printed later */
	    break;
	}
    }
    optind = 1;     /* Reset scanning */

    locale_init();

    REGHELPER_INIT(argv[0]);

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;

    user_init();
    init_defaults(read_flags);

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {

	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'c':
	    config_merge++;
	    break;

	case 'C':
	    if (0 != access(optarg,READ_ACCESS)) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
	    }

	    commentfile = fopen(optarg,"r");
	    if (!commentfile) {
		int errcode = errno;
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotReadable,
				  "File %.50s is not readable: %s"),
			  optarg, strerror(errcode));
		err++;
		goto fail;
		
	    }
	    break;

	case 'S':
	    copydirs = safe_array_realloc(copydirs,(copydir_count+1), sizeof (*copydirs));
	    copydirs[copydir_count++] = optarg;
	    break;
	case 'd':
#if DEBUG
	    set_debugging(optarg);	 
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;
	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'w' : 
	    targetfile = optarg;
	    if (0 != access(targetfile,WRITE_ACCESS)) {
		int errcode = errno;
		
		if (errcode != ENOENT) {
		    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				      "File %.50s is not writeable: %s"),
			      targetfile, strerror(errcode));
		    err++;
		    goto fail;
		}
	    }
	    break;

	case '?':
	    err = 1;
	    goto fail;
	}
    }

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMISO2022SETS program (version %s).\n",
			     version_buff);

	if (d >= 50) {
#if 0	
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
	    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
#endif
	}
    }
#endif
    
    if (copydir_count)
	set_charmap_copy_callback(charmap_copy);

    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);
    
    if (optind < argc) {
	int errcount = 0;

	MAP = parse_iso2022_map(argv[optind],&errcount,
				ml_none /* do not merge yet */);

	if (!MAP || errcount) {
	    err = 1;
	    goto fail;
	}
    }

    if (config_merge) {

	if (!MAP) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeMap,
			      "Config merge (-c) requires map as argument"));
	    err++;
	    goto fail;
	}
	
	if (targetfile) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeConfigMergeNoW,
			      "Config merge (-c) Can not used with -w"));
	    err++;
	    goto fail;
	}

	if (global) {

	    change_iso2022_map(&system_iso2022_map_conf,MAP,
			       ml_global /* merge with real global map */);
	    free_iso2022_map_conf(&MAP);
	    
	    MAP          = system_iso2022_map_conf;
	    targetfile   = system_iso2022_sets;

	} else {

	    change_iso2022_map(&user_iso2022_map_conf,MAP,
			       ml_user /* merge with real global map */);
	    free_iso2022_map_conf(&MAP);

	    MAP          = user_iso2022_map_conf;
	    targetfile   = user_iso2022_sets;

	}

	if (0 != access(targetfile,WRITE_ACCESS)) {
	    int errcode = errno;
	    
	    if (errcode != ENOENT) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
				  "File %.50s is not writeable: %s"),
			  targetfile, strerror(errcode));
		err++;
		goto fail;
	    }
	}
    }

    if (!MAP) {
	if (global)
	    MAP = system_iso2022_map_conf;
	else
	    MAP = user_iso2022_map_conf;
    }

    if (targetfile) {
	char * tmp = elm_message(FRM("%s.N"),targetfile);
	int errcode = can_open(tmp,"w");
	FILE *f;

	if (errcode) {
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	  
	    err++;
	    free(tmp);
	    goto fail;
	}
	f = fopen(tmp,"w");
	if (!f) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}

	dump_iso2022_map(f,MAP,
			 commentfile,"ELMISO2022SETS",version_buff);

	if (EOF == fclose(f)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			      "File %.50s is not writeable: %s"),
		      tmp, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	if (0 != rename(tmp,targetfile)) {
	    int errcode = errno;
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotRenamed,
			      "Failed to rename temporary file to %.50s: %.30s"),
		      targetfile, strerror(errcode));
	    
	    err++;
	    free(tmp);
	    goto fail;
	}
	log_config(targetfile);
	free(tmp);

    } else 
	dump_iso2022_map(stdout,MAP,
			 commentfile,"ELMISO2022SETS",version_buff);

 fail:
    if (commentfile)
	fclose(commentfile);

    if (MAP && 
	MAP != system_iso2022_map_conf && 
	MAP != user_iso2022_map_conf)
	free_iso2022_map_conf(&MAP);

    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);
    
    return err;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
