static char rcsid[] = "@(#)$Id: elmbindata.c,v 2.9 2018/12/21 11:21:43 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.9 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI) 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_utils.h"
#include "s_me.h"
#include "s_elm.h"
#include "cs_imp.h"

#include "bindata.h"

#include "reghelper.h"

DEBUG_VAR(Debug,__FILE__,"util");

int    register_fd     = -1; 
const char * program_name    = "elmbindata"; 
char * register_module = NULL;

#include "charmapcopy.h"

extern char *optarg;		
extern int   optind;		

static char version_buff[NLEN];

static const char OPTION_LETTERS[] = "Gw:d:b:BIT:S:r:";

int main P_((int argc, char *argv[]));
int main(argc, argv)
     int argc;
     char *argv[];
{
    struct bindata_mapped_data * bindata = NULL;
    char * target_file = NULL;
    char * text_target_dir = NULL;
    
    char **filelist = NULL;
    int err = 0;
    
    int c;
    int global = 0;
    int read_flags = 0;
	
#if DEBUG
    init_debugfile("ELMBINDATA");
#endif

    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'd' : 	
#if DEBUG
	    set_debugging(optarg);	  
#endif
	    /* Error is printed later */
	    break;
	}
    }
    optind = 1;     /* Reset scanning */


    locale_init();
    
    REGHELPER_INIT(argv[0]);

    read_flags = global ? READ_FLAG_GLOBAL_ONLY : 0;
    
    user_init();
       
    init_defaults(read_flags);
        
    while ((c = ELM_GETOPT(argc, argv, OPTION_LETTERS)) != EOF) {
	switch(c) {
	case 'G':
	    global++;
	    break;
	case 'w':
	    target_file = optarg;
	    break;
	case 'I':
	    target_file = bindata_path;

	    if (0 == strcmp(bindata_path,"none")) {
		/* This is more like debug option */
		fprintf(stderr,"%s: bindata = %s\n",
			program_name,unidata_path);
		target_file = NULL;
	    }

	    break;
	case 'S':
	    if (0 == access(optarg,ACCESS_EXISTS)) {
		copydirs = safe_array_realloc(copydirs,(copydir_count+1), sizeof (*copydirs));
		copydirs[copydir_count++] = optarg;
	    } else {
		int errcode = errno;
		
		lib_error(CATGETS(elm_msg_cat, MeSet,
				  MeDirNotExists,
				  "Directory %s does not exists: %s"),
			  optarg,strerror(errcode));		
		err = 1;
	    }
	    break;
	case 'd': 	
#if DEBUG
	    set_debugging(optarg);	  
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
#endif
	    break;

	case 'r':
	    set_user_rc_location(optarg); 
	    break;

	case 'B':
	    bindata = default_bindata();
	    if (!bindata) {
		err = 1;
		goto fail;
	    }
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			      "%s loaded"),
		      raw_bindata_path);
	    break;
	case 'b':
	    if (!get_bindata(&bindata,optarg)) {
		err = 1;
		goto fail;
	    }
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeFileLoaded,
			      "%s loaded"),
		      optarg);
	    break;
	case 'T':
	    text_target_dir = optarg;
	    if (0 == mkdir(text_target_dir,0700)) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeCreateDir,
				  "Directory %s created"),
			  text_target_dir);

		if (register_fd != -1)
		    log_it("M",text_target_dir,"-","-",0700,NULL);

	    } else if (EEXIST != errno) {
		lib_error(CATGETS(elm_msg_cat, MeSet, MeCantCreateDir,
				  "Can't create directory %s"),
			  text_target_dir);
		err = 1;
		goto fail;
	    }

	    break;
	case '?':
	    exit(1);
	}
    }
    

    elm_sfprintf(version_buff, sizeof version_buff,
		 FRM("%s PL%s"), VERSION, PATCHLEVEL);
    
  
#ifdef DEBUG
    { 
	int d = panic_dprint("\n\
======================================================\n\
Debug output of the ELMBINDATA program (version %s).\n",
			     version_buff);

	if (d >= 50) {
#if 0	
	    panic_dprint("WARNING: Edit manually out sensitive information from that file!\n");
    
	    lower_prompt("WARNING: Debug file may include passwords -- edit it!");
	    sleep(5+sleepmsg);	    
#endif
	}
    }
#endif

    if (copydir_count)
	set_charmap_copy_callback(charmap_copy);

    if (!global)
	read_rc_file(read_flags);
    else
	post_init_check(read_flags);

    if (!bindata)
	bindata = generate_bindata();

    if (target_file && bindata) {
	if (!write_bindata(bindata,target_file))
	    exit(1);

	if (global && 0 == strcmp(bindata_path,target_file)) {
	    if (0 != chmod(target_file,0644)) {
		int errcode = errno;

		fprintf(stderr,"%s: chmod %s: %s\n",
			program_name, target_file, strerror(errcode));
		err = 1;
	    }
	}

	log_config(target_file);
    }

    if (text_target_dir && bindata) {
	int i;
	if (!write_bindata_text(bindata,text_target_dir, &filelist))
	    exit(1);
	
	if (!filelist)
	    exit(1);

	for (i = 0; filelist[i]; i++) {
	    log_config(filelist[i]);
	    free(filelist[i]);
	}
	free(filelist);
    }

 fail:
    
    if (err)
	lib_error(CATGETS(elm_msg_cat, MeSet, MeProgFailed,
			  "%s failed; exit code=%d"),
		  argv[0],err);
    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
