static char rcsid[] = "@(#)$Id: charmapcopy.c,v 2.5 2017/05/03 19:34:23 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "s_elm.h"
#include "s_me.h"
#include "reghelper.h"
#include "charmapcopy.h"
#include "cs_imp.h"

DEBUG_VAR(Debug,__FILE__,"util");

char ** copydirs = NULL;
int     copydir_count = 0;

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif

#if ANSI_C
#define E_(x) extern x;
#else
#define E_(x)
#endif

E_(charmap_copy_callback charmap_copy)
FILE *charmap_copy(name,pathname)
     const char *name; 
     const char *pathname;
{
    int i;
    FILE *F = NULL;
    FILE *res = NULL;
    int fd,c;

    for (i = 0; i < copydir_count; i++) {
	char * n = elm_message(FRM("%s/%s"),copydirs[i],name);
	
	F = fopen(n,"r");

	if (F) {
	    lib_transient(CATGETS(elm_msg_cat, MeSet,MeCopyingMapfile,
				  "Copying mapfile %s: %s => %s"),
			  name,n,pathname);
	    log_config((char *)pathname);
	}
	free(n);
	if (F)
	    break;
    }

    if (!F) {
	lib_transient(CATGETS(elm_msg_cat, MeSet,
			      MeNoCopyingMapfile,
			      "*** Copying mapfile %s => %s -- file %s not found?"),
		      name,pathname,name);
	return NULL;
    }

    fd = open(pathname, O_RDWR | O_CREAT | O_EXCL, 0444);
    if (fd < 0) {
	int errcode;
	
    error1:
	errcode = errno;

	lib_error(CATGETS(elm_msg_cat, MeSet, MeFileNotWriteable,
			  "File %.50s is not writeable: %s"),
		  pathname, strerror(errcode));

	fclose(F);
	if (fd >= 0)
	    close(fd);
	return NULL;
    }

    res = fdopen(fd,"w+");
    if (!res)
	goto error1;

    while (EOF != (c = getc(F))) {
	if (putc(c,res) == EOF) {
	    int err = errno;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorTryingToWrite,
			      "Error %s encountered trying to write to %s."),
		      strerror(err),pathname);
	    fclose(F);
	    fclose(res);
	    return NULL;
	}
    }
	   
    if (ferror(res)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorReading,
			  "Error reading from %.50s"),
		  name);
	fclose(F);
	fclose(res);
	return NULL;
    }

    fclose(F);

    rewind(res);
    return res;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
