static char rcsid[] = "@(#)$Id: view_folder.c,v 2.22 2021/01/10 15:47:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.22 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mail");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(subpage_simple_redraw sb_view_folder_title)
static int sb_view_folder_title(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    struct menu_common *mptr = mp_lookup_mcommon(list,elm_mp_menu);

    int message_count  = mcommon_get_count(mptr);
    int selected       = mcommon_get_selected(mptr);
    struct string * f1 = mcommon_title(mptr);

    struct string * buffer0 = NULL;
    struct string * buffer = NULL;
    struct string * buffer2 = NULL;

    int l0,l1,l2,l;
    int LINES, COLUMNS;
    
    DPRINT(Debug,9, (&Debug, "sb_view_folder_title\n"));

    menu_ClearScreen(ptr);
    menu_get_sizes(ptr, &LINES, &COLUMNS);   


    buffer0 = format_string(CATGETS(elm_msg_cat, ElmSet, 
				    ElmViewFolderTitle,
				    "Viewing folder"));
   
    if (selected)
	buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
				       ElmShownXWithSelect,
				       "%S with %d shown out of %d"),
			       f1,selected, 
			       message_count);
    else 
       	buffer = format_string(CATGETS(elm_msg_cat, ElmSet, 
				       ElmShownXNoSelectItem,
				       "%S with %d %S"),
			       f1, message_count,
			       (message_count == 1) ? 
			       mcommon_give_item(mptr,m_item) :
			       mcommon_give_item(mptr,m_items));

    

    free_string(&f1);
    

    l0 = string_len(buffer0);
    l1 = string_len(buffer);
    
    buffer2 = format_string(FRM("[ELM %s]"),
			    version_buff);
    l2 = string_len(buffer2);
    l = l1 + l2 + 1; /* Assumed */

    menu_StartXX(ptr,pg_BOLD);    
    if (l + l0 + 2 < COLUMNS) {
	int la = l + l0 +2;

	menu_PutLineX(ptr,1,(COLUMNS - la)/2,
		      FRM("%S: %S %S"),
		      buffer0,buffer,buffer2);

    } else {
	if (l0 < COLUMNS)
	    menu_PutLineX(ptr,0,(COLUMNS - l0)/2,FRM("%S"),buffer0);

	if (l > COLUMNS) {
	    if (l2 < COLUMNS)
		menu_PutLineX(ptr,2,(COLUMNS - l2)/2,FRM("%S"),buffer2);
	    if (l1 > COLUMNS) 
		menu_PutLineX(ptr,1,1,FRM("%S"),buffer);
	    else
		menu_PutLineX(ptr,1,(COLUMNS - l1)/2,FRM("%S"),buffer);
	} else {
	    menu_PutLineX(ptr,1,(COLUMNS - l)/2,FRM("%S %S"),buffer,buffer2);
	}
    }
    menu_EndXX(ptr,pg_BOLD);    

    free_string(&buffer2);
    free_string(&buffer);
    free_string(&buffer0);
    
    return 1;   /* subpage area updated completely */
}


S_(subpage_simple_redraw sb_view_folder_menu)
static int sb_view_folder_menu P_((struct menu_context  *ptr,
			      struct menu_param *list));
static int sb_view_folder_menu(ptr,list)
     struct menu_context  *ptr;
     struct menu_param *list;
{
    menu_ClearScreen(ptr);

    menu_print_format_center(ptr,0,
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmViewFolderMenuLine1,
				     "Attach m)essage or b)ody of message to mail, Or view a)ttachments."));
    menu_print_format_center(ptr,1,
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmViewFolderMenuLine2,
				     "To read message, press space.   j = move down, k = move up"));

    menu_print_format_center(ptr,2,
			     CATGETS(elm_msg_cat, ElmSet, 
				     ElmViewFolderMenuLine3, 
				     "To return to mail press <return> or q)uit."));

    return 1;
}


static int showmsg_view_folder_cmd P_((     struct MailboxView *mailbox,
				       int cmd, 
				       struct pager_page *pager_page));
static int showmsg_view_folder_cmd(mailbox,cmd,pager_page)
     struct MailboxView *mailbox;
     int cmd; 
     struct pager_page *pager_page;
{
    struct menu_common MENU;
    
    set_mcommon_from_mbxview(&MENU,mailbox);
    
    switch (cmd) {
    case 'm':

	/* Otherwise 'm' is m)ail message, which means
	   that m)ail is called recursively. Disallow it.
	*/

	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmViewFolderAttachMessageNo,
			  "Attaching message is not possible when viewing it"));
	
	return 0;

    case 'b':

	/* Otherwise 'b' is b)ounce message, which means
	   that sendig mail is called recursivly. Disallow it.
	*/

	lib_error(CATGETS(elm_msg_cat, ElmSet, 
			  ElmViewFolderAttachBodyNo,
			  "Attaching message body is not possible when viewing it"));
	
	return 0;
    }


    return cmd;
}


static void set_mailbox_screen P_((struct menu_context  *page, 
				   struct screen_parts *LOC,
				   struct menu_param   *LIST));
static void set_mailbox_screen(page,LOC, LIST)
     struct menu_context  *page;
     struct screen_parts  *LOC;
     struct menu_param    *LIST;
{    
    int   LINES, COLUMNS;	

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* 1)  Title part of screen */

    if (! LOC->title_page)
	LOC->title_page = new_menu_subpage(page,0,4,sb_view_folder_title,LIST);
    else
	menu_subpage_relocate(LOC->title_page,page,0,4);

    /* 2) menu part */

    if (LOC->menu_page && LINES < 14)
	erase_menu_context (&(LOC->menu_page));
    else if (LOC->menu_page)
	menu_subpage_relocate(LOC->menu_page,page,LINES-8,4);
    else if (mini_menu && LINES > 14)
	LOC->menu_page = new_menu_subpage(page,LINES-8,4,
					  sb_view_folder_menu,LIST);
   
    mailbox_screen_common(page,LOC, LIST);	
}



static void check_mailbox_screen P_((struct screen_parts *LOC,
				     struct menu_param *list));
static void check_mailbox_screen(LOC,list)
     struct screen_parts *LOC;
     struct menu_param *list;
{
    if (menu_resized(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page resized\n"));

    }
    if (menu_need_redraw(LOC->title_page)) {
	DPRINT(Debug,1, (&Debug, "title page redraw???\n"));
	sb_view_folder_title(LOC->title_page,list);
    }

    if (LOC->menu_page) {
	/* 2) menu page */
	if (menu_resized(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page resized\n"));
	    
	}
	if (menu_need_redraw(LOC->menu_page)) {
	    DPRINT(Debug,1, (&Debug, "menu page redraw???\n"));
	    sb_view_folder_menu(LOC->menu_page,list);
	}
    }

    /* 3) prompt part */
    if (menu_resized(LOC->prompt_page)) {
	DPRINT(Debug,1, (&Debug, "prompt page resized\n"));
    }
    if (menu_need_redraw(LOC->prompt_page)) {
	menu_ClearScreen(LOC->prompt_page);

	show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
    }

    /* 4) headers part */
    if (menu_resized(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page resized\n"));
    }
    if (menu_need_redraw(LOC->header_page)) {
	DPRINT(Debug,1, (&Debug, "header page redraw\n"));
	menu_ClearScreen(LOC->header_page);
    }
}



/* may return EOF */
int  send_view_folder(current_mailbox,attachments,parent_page,aview,
		       mailer_info)
     struct MailboxView *current_mailbox;
     struct Attachments *attachments;
     struct menu_context *parent_page; 
     struct AliasView *aview;
     struct mailer_info  *mailer_info;
{
    int leave = 0;
    int retch = '\0';

    struct menu_context  *page = new_menu_context();
    struct screen_parts LOC = { NULL, NULL, NULL };

    struct menu_common MENU;
    struct menu_param  PARAM[elm_mp_COUNT+1] = { 
	{ mp_menu_common, { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_integer,     { 0 } },
	{ mp_END,         { 0 } }
    };

    struct elm_commands *pager_cmds = give_snd_view_pager_commands();
    struct elm_commands *menu_cmds = give_snd_view_folder_commands();

    int   LINES, COLUMNS;	

    set_mcommon_from_mbxview(&MENU,current_mailbox);
    mp_list_set_mcommon(PARAM,elm_mp_menu,&MENU);
    set_mailbox_screen(page,&LOC,PARAM);

    /* resort_mailbox no longer call get_page() */
    get_page(&MENU, LOC.header_page);  
    copy_current(&MENU,LOC.header_page);


    leave = 0;

    menu_get_sizes(page,&LINES, &COLUMNS);

    showscreen(page);


    while (!leave) {
	int ch;

	menu_set_default(page);

	if (menu_resized(page)) {

	    set_mailbox_screen(page,&LOC,PARAM);
	    
	    menu_get_sizes(page,&LINES, &COLUMNS);

	    menu_trigger_redraw(page);
	} 
	
	new_mail_check(current_mailbox, page, &LOC, NULL);      

	if (update_view(current_mailbox)) {
	    resort_mailbox(current_mailbox,1);
	    
	    /* resort_mailbox no longer call get_page() */	    
	    get_page(&MENU, LOC.header_page);  
	    menu_trigger_redraw(LOC.header_page);
	}
	
	if (menu_need_redraw(page)) 
	    showscreen(page);
	check_mailbox_screen(&LOC, PARAM);

	
	{   
	    int lin,col;
	    
	    menu_PutLineX(LOC.prompt_page,0,0,
			  FRM("%S"),mcommon_give_item(&MENU, m_Prompt));
	    menu_GetXYLocation(LOC.prompt_page,&lin,&col);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    show_last_error();
	    menu_MoveCursor(LOC.prompt_page,lin,col);

	    ch = GetPrompt(LOC.prompt_page,elm_timeout);
	    
	    menu_CleartoEOS(LOC.prompt_page);
	    
	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	      
	    set_error("");	/* clear error buffer */
	    
	    menu_MoveCursor(LOC.prompt_page,lin,col);
	}

	ch = motion(ch,&MENU,&LOC, 
		    page,menu_cmds);
	
	switch (ch) {
	case 0:  /* OK */
	    break;
	    
	case F3_KEY_MARK:
	    mini_menu = ! mini_menu;

	    if (LOC.menu_page && !mini_menu)
		erase_menu_context (&(LOC.menu_page));

	    DPRINT(Debug,10,(&Debug,"mini_menu = %d \n",mini_menu));

	    set_mailbox_screen(page,&LOC,PARAM);
		
	    menu_trigger_redraw(page);   /* ? Is needed? */
	    
	    break;
	   
	quit_mark:
	case ctrl('Q') :

	case 'Q':
	case 'X':

	case 'q':
	case 'i':

	case ctrl('J'):
	case ctrl('M'):
	    
	    leave = 1;

	    break;
	    
	case ' ':  /*   Copied from mailbox_command */ {
	    int current = get_current(current_mailbox);
	    
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
					 ElmDisplayMessage,
					 "Display message"));  
	    FlushBuffer();
	    
	    if (current < 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmNoMailToRead,
				  "No mail to read!"));
	    else {
		int x = show_message_normal(current_mailbox,
					    showmsg_view_folder_cmd,
					    aview,page,LOC.header_page,
					    SHOWMSG_NOMAIL,
					    pager_cmds);


		switch (x) {
		case EOF:		    
		    goto eof_mark;
			
		case 'X':      /* Quick Exit */		    
		    goto quit_mark;
		}
		
		current = get_current(current_mailbox);
	    }
	    
	}
	    break;

	eof_mark:
	case EOF:
	    
	    retch = EOF;

	    goto OUT;
	   
	case 'm': {
	    int current = get_current(current_mailbox);
	    struct header_rec *hdr;
	    FILE *F;

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
				    ElmViewFolderAttachMessage,
				    "Attach message"));  
	    FlushBuffer();
	    
	    if (current < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmViewFolderNoMailToAttach,
				  "No mail to attach!"));
	    } else if (give_message_data(current_mailbox,current-1,
				     &hdr,&F,NULL,
				     mime_parse_routine)) {
	    
		if (attach_rfc822(attachments,hdr,F,NULL,
				  get_mailer_level(mailer_info))) {

		    error_wait();  /* Wait possible error */

		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmViewFolderMessageAttached,
					  "Message attached to mail."));
		}
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"give_message_data [%d] fails",current-1));
	    }


	}
	    break;

	case 'b': {
	    int current = get_current(current_mailbox);
	    struct header_rec *hdr;
	    FILE *F;

	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet,
				    ElmViewFolderAttachMsgBody,
				    "Attach message body"));  
	    FlushBuffer();
	    
	    if (current < 1) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmViewFolderNoMailToAttach,
				  "No mail to attach!"));
	    } else if (give_message_data(current_mailbox,current-1,
				     &hdr,&F,NULL,
				     mime_parse_routine)) {
	    
		if (attach_body(attachments,hdr,F,
				get_mailer_level(mailer_info))) {

		    error_wait();  /* Wait possible error */

		    lib_transient(CATGETS(elm_msg_cat, ElmSet, 
					  ElmViewFolderMsgBodyAttached,
					  "Message body attached to mail."));

		}
	    } else {
		DPRINT(Debug,3,(&Debug, 
				"give_message_data [%d] fails",current-1));
	    }

	}
	    break;

	case 'a': {

	    /* NOTE: There is perhaps several different remote_server -values
	             which may make sense on here
	    */

	    int current = get_current(current_mailbox);

	    const struct remote_server * remote_server =
		give_message_remote_server(current_mailbox,current-1);
		       
	    
	    menu_Write_to_screen(LOC.prompt_page,
				 CATGETS(elm_msg_cat, ElmSet, ElmVfyMenuAtttach,
					 "Attachments"));
	    
	    attach_menu(NULL,NULL,attachments,display_charset,mailer_info,
			NULL, aview, current_mailbox,NULL, remote_server);

	    menu_trigger_redraw(page);
	}

	    break;


	default:
	    lib_error(CATGETS(elm_msg_cat, ElmSet,
			      ElmUnknownCommand2,			
			      "Unknown command."));

	}
	
	if (menu_need_redraw(page))
	    showscreen(page);
	
	check_range(&MENU, &LOC);

	check_mailbox_screen(&LOC, PARAM);	

    }  /* while */

 OUT:
    free_commands(&pager_cmds);   /* Decrement refcount */
    free_commands(&menu_cmds);   /* Decrement refcount */

    free_mailbox_screen(&LOC);

    erase_menu_context(&page);
    menu_trigger_redraw(parent_page);

    return retch;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
