static char rcsid[] = "@(#)$Id: http.c,v 2.6 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_url.h"

DEBUG_VAR(Debug,__FILE__,"url");

#define URL_http_magic		0xEC07

/* Dummy -- no functional http handler */

struct url_http {

    unsigned short        magic;     /* URL_http_magic */

    struct string       * params;
    struct string       * query;

};

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


S_(uh_init_url uh_init_DUMMY_http)
static void uh_init_DUMMY_http  P_((struct url *url));
static void uh_init_DUMMY_http(url)
     struct url *url;
{
    url->u.http = safe_malloc (sizeof (*  url->u.http));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)url->u.http,sizeof (* url->u.http));

    url->u.http->magic = URL_http_magic;

    url->u.http->params = NULL;    
    url->u.http->query  = NULL;    
}

S_(uh_free_url uh_free_DUMMY_http)
static void uh_free_DUMMY_http  P_((struct url *url));
static void uh_free_DUMMY_http(url)
     struct url *url;
{
    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_free_DUMMY_http",
	      "bad  magic number",0);

    if (url->u.http->params)
	free_string(& (url->u.http->params));
    if (url->u.http->query)
	free_string(& (url->u.http->query));


    url->u.http->magic = 0;  /* Invalidate */
    free(url->u.http);
    url->u.http = NULL;
}

S_(uh_parse_url_not_path  uh_parse_DUMMY_http_not_path)
static int uh_parse_DUMMY_http_not_path  P_((struct url *url, 
					     struct string *scheme_pesifix,
					     struct header_errors **header_error));

static int uh_parse_DUMMY_http_not_path(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{

   /* Should not be called */

    return 0;
}

S_(uh_dup_url_not_path uh_dup_DUMMY_http_not_path)
static int uh_dup_DUMMY_http_not_path  P_((struct url *url,
				       struct url *source));
static int uh_dup_DUMMY_http_not_path(url,source)
     struct url *url;
     struct url *source;
{
  /* Should not be called */

    return 0;
}

S_(uh_parse_url_params uh_parse_DUMMY_http_params)
static int uh_parse_DUMMY_http_params  P_((struct url *url, 
					   struct string *scheme_pesifix,
					   struct header_errors **header_error));
static int uh_parse_DUMMY_http_params(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_DUMMY_http_params",
	      "bad  magic number",0);

    url->u.http->params = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_params uh_dup_DUMMY_http_params)
static int uh_dup_DUMMY_http_params  P_((struct url *url,
				       struct url *source));
static int uh_dup_DUMMY_http_params(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_DUMMY_http_params",
	      "bad  magic number (url)",0);

    if (URL_http_magic != source->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_DUMMY_http_params",
	      "bad  magic number (source)",0);

    if (source->u.http->params)
	url->u.http->params = dup_string(source->u.http->params);

    return 1;
}

S_(uh_parse_url_query uh_parse_DUMMY_http_query)
static int uh_parse_DUMMY_http_query  P_((struct url *url, 
					  struct string *scheme_pesifix,
					  struct header_errors **
					  header_error));
static int uh_parse_DUMMY_http_query(url,scheme_pesifix,header_error)
     struct url *url;
     struct string *scheme_pesifix;
     struct header_errors **header_error;
{
    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_parse_DUMMY_http_query",
	      "bad  magic number",0);

    url->u.http->query = dup_string(scheme_pesifix);

    return 1;
}

S_(uh_dup_url_query uh_dup_DUMMY_http_query)
static int uh_dup_DUMMY_http_query  P_((struct url *url,
				       struct url *source));
static int uh_dup_DUMMY_http_query(url,source)
     struct url *url;
     struct url *source;
{
    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_DUMMY_http_query",
	      "bad  magic number (url)",0);

    if (URL_http_magic != source->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_dup_DUMMY_http_query",
	      "bad  magic number (source)",0);

    if (source->u.http->query)
	url->u.http->query = dup_string(source->u.http->query);

    return 1;
}

S_(uh_set_mailing_headers_from_url uh_set_mailing_headers_from_DUMMY_http)
static int uh_set_mailing_headers_from_DUMMY_http P_((struct mailing_headers *hdrs,
						  const struct url *url,
						  struct mailer_info 
						  *mailer_info));
static int uh_set_mailing_headers_from_DUMMY_http(hdrs,url,mailer_info)
     struct mailing_headers *hdrs;
     const struct url *url;
     struct mailer_info  *mailer_info;
{
    return 0;
}


S_(uh_get_body_string_from_url uh_get_body_string_from_DUMMY_http)
static const struct string * uh_get_body_string_from_DUMMY_http P_((const struct 
								url *url,
								int *errors));
static const struct string * uh_get_body_string_from_DUMMY_http(url,errors)
     const struct url *url;
     int *errors;
{
    return NULL;
}


S_(uh_not_path_to_raw_url uh_not_path_to_raw_DUMMY_http)
static struct string * uh_not_path_to_raw_DUMMY_http P_((const struct url *url));
static struct string * uh_not_path_to_raw_DUMMY_http(url) 
     const struct url *url;
{

    return NULL;
}

S_(uh_params_to_raw_url uh_params_to_raw_DUMMY_http)
static int uh_params_to_raw_DUMMY_http P_((const struct url *url, 
				       struct string **result));
static int uh_params_to_raw_DUMMY_http(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_params_to_raw_DUMMY_http",
	      "bad magic number",0);

    if (url->u.http->params)
	*result = dup_string(url->u.http->params);

    return 1;
}

S_(uh_query_to_raw_url uh_query_to_raw_DUMMY_http)
static int uh_query_to_raw_DUMMY_http P_((const struct url *url, 
				      struct string **result));
static int uh_query_to_raw_DUMMY_http(url,result)
     const struct url *url; 
     struct string **result;
{
    *result = NULL;

    if (URL_http_magic != url->u.http->magic)
	panic("URL PANIC",__FILE__,__LINE__,"uh_query_to_DUMMY_http",
	      "bad magic number",0);

    if (url->u.http->query)
	*result = dup_string(url->u.http->query);

    return 1;
}

S_(uh_get_folder_from_url uh_get_folder_from_DUMMY_http)
static struct folder_info * uh_get_folder_from_DUMMY_http
     P_((const struct url *url,
	 verify_remote_url_f    * verify_remote,
	 int   * ret_letter /* returns '\0' or EOF */));
static struct folder_info * uh_get_folder_from_DUMMY_http(url,verify_remote,ret_letter)
     const struct url *url;
     verify_remote_url_f    * verify_remote;
     int   * ret_letter /* returns '\0' or EOF */;
{
    return NULL;
}


struct url_handler DUMMY_http_HANDLER = {
    URL_handler_magic,
    URLFLAG_common|URLFLAG_port|URLFLAG_path|URLFLAG_query,
    url_unknown,
    uh_init_DUMMY_http,
    uh_free_DUMMY_http,
    uh_parse_DUMMY_http_not_path,
    uh_dup_DUMMY_http_not_path,
    uh_parse_DUMMY_http_params,
    uh_dup_DUMMY_http_params,
    uh_parse_DUMMY_http_query,
    uh_dup_DUMMY_http_query,
    uh_set_mailing_headers_from_DUMMY_http,
    uh_get_body_string_from_DUMMY_http,
    uh_not_path_to_raw_DUMMY_http,
    uh_params_to_raw_DUMMY_http,
    uh_query_to_raw_DUMMY_http,
    uh_get_folder_from_DUMMY_http,
    get_url_type_default
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

