/* $Id: def_url.h,v 2.12 2020/05/21 02:58:30 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.12 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "schedule_time.h"
#include "me.h"
#include "mailerlib.h"

/* url.c ------------------------------------------------------------------- */

#define URL_magic	     0xEC00

struct url {
    unsigned short        magic;     /* URL_magic */
    int                   scheme;    /* -1   invalid */
    struct url_handler  * current_handler;

    struct host_part {
	struct url_element  * user;
	struct url_element  * password;
	struct url_element  * host;
	uint16                port;    /* 0 == not set */

    }                   * host;

    struct url_path     * path;

    union {
	void               * dummy;
	struct no_url      * NO_URL;
	struct url_mailto  * mailto;
	struct url_http    * http;
	struct url_imap    * imap;
    } u;

    /* This considers that fragment do not have structure */
    struct url_element  * fragment;

};

extern struct scheme {
    const char          * scheme;
    struct url_handler  * handler;
} * index_to_schema P_((int idx));


#define URL_handler_magic    0xEC01

#define URLFLAG_common      0x01
#define URLFLAG_username    0x02
#define URLFLAG_port        0x04
#define URLFLAG_path        0x08
#define URLFLAG_params      0x10
#define URLFLAG_query       0x20
#define URLFLAG_password    0x40

typedef void uh_init_url  P_((struct url *url));
typedef void uh_free_url  P_((struct url *url));

typedef int uh_parse_url_not_path  P_((struct url *url, 
				       struct string *scheme_pesifix,
				       struct header_errors **header_error));
typedef int uh_dup_url_not_path  P_((struct url *url,
				     struct url *source));

typedef int uh_parse_url_params  P_((struct url *url, 
				     struct string *scheme_pesifix,
				     struct header_errors **header_error));
typedef int uh_dup_url_params  P_((struct url *url,
				   struct url *source));

typedef int uh_parse_url_query  P_((struct url *url, 
				    struct string *scheme_pesifix,
				    struct header_errors **header_error));
typedef int uh_dup_url_query  P_((struct url *url,
				  struct url *source));

typedef int uh_set_mailing_headers_from_url P_((struct mailing_headers *hdrs,
						const struct url *url,
						struct mailer_info  
						*mailer_info));

typedef const struct string * uh_get_body_string_from_url P_((const struct url 
							      *url,
							      int *errors));

typedef struct string * uh_not_path_to_raw_url P_((const struct url *url));
typedef int uh_params_to_raw_url P_((const struct url *url, 
				     struct string **result));
typedef int uh_query_to_raw_url P_((const struct url *url, 
				    struct string **result));

typedef struct folder_info * uh_get_folder_from_url P_((
           const struct url *url,
	   verify_remote_url_f    * verify_remote,
	   int   * ret_letter /* returns '\0' or EOF */));

typedef enum url_type uh_get_url_type P_((const struct url *url));

extern struct url_handler {
    unsigned short        magic;     /* URL_handler_magic */

    int                   flag;
    enum url_type         url_type;

    uh_init_url         * uh_init_it;
    uh_free_url         * uh_free_it;

    uh_parse_url_not_path * uh_parse_it_not_path;
    uh_dup_url_not_path   * uh_dup_it_not_path;
    uh_parse_url_params   * uh_parse_it_params;
    uh_dup_url_params     * uh_dup_it_params;
    uh_parse_url_query    * uh_parse_it_query;
    uh_dup_url_query      * uh_dup_it_query;
    uh_set_mailing_headers_from_url * uh_set_mailing_headers_from_it;
    uh_get_body_string_from_url     * uh_get_body_string_from_it;
    uh_not_path_to_raw_url          * uh_not_path_to_raw_it;
    uh_params_to_raw_url  * uh_params_to_raw_it;
    uh_query_to_raw_url   * uh_query_to_raw_it;

    uh_get_folder_from_url * uh_get_folder_from_it;
    uh_get_url_type        * uh_get_it_type;

} NO_URL_HANDLER, URL_mailto_handler, DUMMY_http_HANDLER,
    URL_imap_handler, URL_imaps_handler;

extern int name_to_scheme_idx P_((const char * name));

extern enum url_type get_url_type_default P_((const struct url *url));

#ifdef REMOTE_MBX
extern struct folder_browser * get_browser_from_host_url P_((
        const struct url *url,
	const struct browser_url_method *method,
	verify_remote_url_f    * verify_remote,
	int   * ret_letter /* returns '\0' or EOF */
							     ));

extern int browser_select_url_path P_((
     struct folder_browser *browser,
     const struct url *url,
     const struct browser_url_method *method ));
#endif


/* url_element.c ----------------------------------------------------------- */

/* Decodes %XX, 
 * IF there is %XX > %7F returns type is RAW_BUFFER (charset unknown) 
 * otherwise uses charset of raw
 * If codes with %XX > %7F is able to handle as UTF-8, that is returned
*/
extern struct string * raw_to_parsed P_((struct string *raw, 
					 struct header_errors **header_error));

/* Does %XX escaping, escaping is done according of UTF-8 
   except if type is RAW_BUFFER
   returns US-ASCII string
*/
extern char * parsed_to_raw P_((struct string *parsed));

extern struct url_element * element_from_raw P_((struct string *raw));
extern struct url_element * element_from_parsed P_((struct string *parsed));
extern void free_url_element P_((struct url_element **ptr));

/* Shared -- do not free */
extern const struct string * parsed_from_element P_((struct url_element 
						     *elem,
						     struct header_errors **
						     header_error));
extern const struct string * raw_from_element P_((struct url_element *elem));

extern struct url_element * dup_url_element P_((struct url_element *elem));

/* url_path.c -------------------------------------------------------------- */

extern struct url_path * raw_to_url_path P_((struct string *raw));
extern struct string * url_path_to_raw P_((struct url_path *url_path));

extern int url_path_len P_((struct url_path *path));

#define URL_path_elem_magic     0xEC03

/* Returns reference to url_path_element, do not free! */
extern const struct url_path_elem {
    unsigned short        magic;     /* URL_path_elem_magic */

    struct url_element  * elem;
    int trailing_slash;   /* traling slash /  is not included on elem */
} * get_url_path_element P_((struct url_path *path, int idx));

/* For absolute paths, element 0 is:
       elem            == NULL
       trailing_slash  == 1

   On all elements except last, there is always
       trailing_slash  == 1

*/

extern void free_url_path P_((struct url_path **path));

extern struct url_path * join_url_path P_((struct url_path *parent,
					   struct url_path *relative));

extern struct url_path * dup_url_path P_((struct url_path *path));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
