static char rcsid[] = "@(#)$Id: wrapper.c,v 2.6 2022/07/14 14:16:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"

DEBUG_VAR(Debug,__FILE__,"screen");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(w_menu_init CUR_init)
static void CUR_init P_((struct menu_context *ctx));
static void CUR_init(ctx)
     struct menu_context *ctx;
{

    DPRINT(Debug,10, (&Debug, "CUR_init: %p\n",
		      ctx));

}

S_(w_menu_free CUR_free)
static void CUR_free P_((struct menu_context *ctx));
static void CUR_free(ctx)
     struct menu_context *ctx;
{

    DPRINT(Debug,10, (&Debug, "CUR_free: %p\n",
		      ctx));
}


S_(w_menu_Writechar CUR_Writechar)
static void CUR_Writechar P_((struct menu_context * ctx, int ch));
static void CUR_Writechar(ctx,ch)
     struct menu_context * ctx; 
     int ch;
{
    cur_Writechar(ch, NULL);
}

S_(w_menu_WriteUnicode CUR_WriteUnicode)
static void CUR_WriteUnicode P_((struct menu_context * ctx, int unicode));
static void CUR_WriteUnicode(ctx,unicode)
     struct menu_context * ctx; 
     int unicode;
{
    cur_WriteUnicode(unicode, NULL);
}

S_(w_menu_PutLineS CUR_PutLineS)
static void CUR_PutLineS  P_((struct menu_context * ctx,
			      struct string *text));
static void CUR_PutLineS(ctx,text)
     struct menu_context * ctx;
     struct string *text;
{    
    cur_PutLineS(text,NULL);      
}

S_(w_menu_PutLine0 CUR_PutLine0)
static void CUR_PutLine0 P_((struct menu_context * ctx,
			     int x, int y,
			     const char *line));
static void CUR_PutLine0(ctx,x,y,line)
     struct menu_context * ctx;
     int x; 
     int y;
     const char *line;
{
    cur_PutLine0(x,y,line,NULL);
}

S_(w_menu_CleartoEOLN CUR_CleartoEOLN)
static void CUR_CleartoEOLN P_((struct menu_context * ctx));
static void CUR_CleartoEOLN(ctx)
     struct menu_context * ctx;
{
    cur_CleartoEOLN();
}

S_(w_menu_CleartoEOS CUR_CleartoEOS)
static void CUR_CleartoEOS P_((struct menu_context * ctx));
static void CUR_CleartoEOS(ctx)
     struct menu_context * ctx;
{
    cur_CleartoEOS();
}

S_(w_menu_ReadCh2 CUR_ReadCh2)
static struct charset_state * CUR_ReadCh2 P_((struct menu_context *ctx,
					      int flags,
					      int break_flag));
static struct charset_state * CUR_ReadCh2(ctx,flags,break_flag)
     struct menu_context *ctx;
     int flags;
     int break_flag;
{

    return cur_ReadCh2(flags,break_flag);
}

S_(w_menu_ScreenSize CUR_ScreenSize)
static void CUR_ScreenSize P_((struct menu_context *ctx,
			       int *lines, int *columns));

static void CUR_ScreenSize(ctx,lines,columns)
     struct menu_context *ctx;
     int *lines; 
     int *columns;
{
    cur_ScreenSize(lines,columns);

    /* ? ? ? syncronize? */
    ctx->lines   = *lines;
    ctx->columns = *columns;
}

S_(w_menu_GetXYLocation CUR_GetXYLocation)
static void CUR_GetXYLocation P_((struct menu_context *ctx,
				      int *x, int *y));
static void CUR_GetXYLocation(ctx,x,y)
     struct menu_context *ctx;
     int *x; 
     int *y;
{
    cur_GetXYLocation(x,y);
}

S_(w_menu_ClearScreen CUR_ClearScreen)
static void CUR_ClearScreen P_((struct menu_context *ctx));
static void CUR_ClearScreen(ctx)
     struct menu_context *ctx;
{
    ctx->redraw      = 0;  /* cur_ClearScreen() clear flag from 
			      default_context now */			      
    cur_ClearScreen();
}

S_(w_menu_MoveCursor CUR_MoveCursor)
static void CUR_MoveCursor P_((struct menu_context *ctx,
			      int row, int col));
static void CUR_MoveCursor(ctx,row,col)
     struct menu_context *ctx;
     int row; 
     int col;
{
    cur_MoveCursor(row, col,NULL);
}

S_(w_menu_changemode CUR_changemode)
static void CUR_changemode P_((struct menu_context *ctx,
			       int start, int end));
static void CUR_changemode(ctx,start,end)
     struct menu_context *ctx;
     int start; 
     int end;
{
    cur_changemode(&ctx->modes, start, end);
}

S_(w_menu_SyncEnter CUR_SyncEnter)
static void CUR_SyncEnter P_((struct menu_context *ctx));
static void CUR_SyncEnter(ctx)
     struct menu_context *ctx;
{
    DPRINT(Debug,10, (&Debug, 
		      "CUR_SyncEnter: %p: Setting mode=0x%02x row=%d col=%d\n",
		      ctx,ctx->modes,ctx->row,ctx->col));

    /* Switch attributes, resetting all possible modes */
    cur_changemode(&CUR_modes,ctx->modes,~0);

    /* Move cursor */
    cur_MoveCursor(ctx->row,ctx->col,NULL);
}

S_(w_menu_SyncLeave CUR_SyncLeave)
static void CUR_SyncLeave P_((struct menu_context *ctx));
static void CUR_SyncLeave(ctx)
     struct menu_context *ctx;
{
    /* Remember attributes */
    ctx->modes    |=  CUR_modes;

    /* disable attributes */
    cur_changemode(&CUR_modes,0,ctx->modes);
   
    /* Remember cursor location */

    cur_GetXYLocation(&ctx->row, &ctx->col);

    DPRINT(Debug,10, (&Debug, 
		      "CUR_SyncLeave: %p: mode=0x%02x row=%d col=%d\n",
		      ctx,ctx->modes,ctx->row,ctx->col));

}

S_(w_menu_resized CUR_resized)
/* called from menu_resized() */
static void CUR_resized P_((struct menu_context *ctx));
static void CUR_resized(ctx)
     struct menu_context *ctx;
{
    ctx->lines      = ROOT_MENU.lines;
    ctx->columns    = ROOT_MENU.columns;
    ctx->changed    = ROOT_MENU.changed;   /* ? ? ? ? */

    SIGDPRINT(Debug,7, (&Debug,
			"CUR_resized: %p: %s, %d lines, %d columns\n",
			ctx,
			ctx->changed ? "setting resize" : "clearing resize",
			ctx->lines,ctx->columns));

}

S_(w_menu_calculate_line CUR_calculate_line)
static void CUR_calculate_line P_((struct menu_context *ctx,
				   int rel_line, int *result));

static void CUR_calculate_line(ctx,rel_line,result)
     struct menu_context *ctx;
     int rel_line; 
     int *result;
{
    *result = rel_line;
}

S_(w_menu_calculate_rline CUR_calculate_rline)
static int CUR_calculate_rline P_((struct menu_context *ctx,
				   int absline, int *result));
static int CUR_calculate_rline(ctx,absline,result)
     struct menu_context *ctx;
     int absline;
     int *result;
{
    *result = absline;
    
    return 1;
}


S_(w_menu_get_linelimit CUR_get_linelimit)
static void CUR_get_linelimit P_((struct menu_context *ctx,
				  int *startline, int *endline));
static void CUR_get_linelimit(ctx,startline,endline)
     struct menu_context *ctx;
     int *startline; 
     int *endline;
{
    *startline = 0;

    *endline = ctx->lines-1;
    if (ROOT_MENU.lines <= *endline)
	*endline = ROOT_MENU.lines-1;
}

S_(w_menu_reset_redraw CUR_reset_redraw)
/* called by need_redraw() */
static void CUR_reset_redraw P_((struct menu_context *ctx));
static void CUR_reset_redraw(ctx)
     struct menu_context *ctx;
{
    ctx->redraw    = ROOT_MENU.redraw;   /* ? ? ? ? */
}

S_(w_menu_do_redraw CUR_do_redraw)
static int CUR_do_redraw P_((struct menu_context *ctx));
static int CUR_do_redraw(ctx)
     struct menu_context *ctx;
{
    return 0;
}

struct  menu_draw_routine CURSES_ROUTINES = {
    MENU_DRAW_magic,

    CUR_init,
    CUR_free,
	
    CUR_Writechar,
    CUR_PutLineS,
    CUR_PutLine0,
    CUR_CleartoEOLN,
    CUR_CleartoEOS,
    CUR_ReadCh2,
    CUR_ScreenSize,
    CUR_GetXYLocation,
    CUR_ClearScreen,
    CUR_MoveCursor,
    CUR_changemode,
    CUR_SyncEnter,
    CUR_SyncLeave,
    CUR_resized,
    CUR_calculate_line,
    CUR_get_linelimit,
    CUR_reset_redraw,
    CUR_do_redraw,
    CUR_WriteUnicode,
    CUR_calculate_rline
};


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
