static char rcsid[] = "@(#)$Id: termtitle.c,v 2.4 2014/11/15 11:00:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"
#include "s_elm.h"

#include <errno.h>

DEBUG_VAR(Debug,__FILE__,"elmpage");


static char * title_string   = NULL;   /* Malloced */
static char * icon_string    = NULL;

static char * title_quit_string   = NULL;   
static char * icon_quit_string    = NULL;

static const char ELM_EXITING[] = "Elm: exiting";  

static char * title_suspended_string   = NULL;   
static char * icon_suspended_string    = NULL;

static const char ELM_SUSPENDED[] = "Elm: suspended";  

int set_terminal_titles(title,icon) 
     char *title;
     char *icon;
{

    /* These are not set when setting terminal to non-raw mode ..
       but instead only when exiting or suspended (with ctrl-Z) */
    if(!title_quit_string)
	title_quit_string = catgets(elm_msg_cat, ElmSet, ElmTitleQuit, 
				    ELM_EXITING);	
    if (!icon_quit_string)
	icon_quit_string = catgets(elm_msg_cat, ElmSet, ElmIconQuit, 
				    ELM_EXITING);	

    if(!title_suspended_string)
	title_suspended_string = catgets(elm_msg_cat, ElmSet, ElmTitleSusp, 
					 ELM_SUSPENDED);	
    if (!icon_suspended_string)
	icon_suspended_string = catgets(elm_msg_cat, ElmSet, ElmIconSusp, 
					ELM_SUSPENDED);	


    DPRINT(Debug,8,(&Debug, 
		    "Terminal (%s) title=%s icon=%s\n",
		    terminal_type,
		    title ? title : "<UNCHANGED>",
		    icon ? icon : "<UNCHANGED>"));

    if (RawState()) {
	char *str =  terminal_set_title(terminal_type,title,icon, NULL,0);
	int i;

	if (!str) {
	    DPRINT(Debug,4,(&Debug, 
			    "Can't set terminal %s titles to %s and %s\n",
			    terminal_type,
			    title ? title : "<NULL>",
			    icon ? icon   : "<NULL>"));
	    return 0;
	}

	DPRINT(Debug,4,(&Debug, 
			"Setting terminal title ("));
	for (i = 0; str[i]; i++) {
	    DPRINT(Debug,4,(&Debug, 
			    "%s%02X",
			    i ? " " : "", str[i]));
	}
	DPRINT(Debug,4,(&Debug,
			") [terminal %s]\n",terminal_type));
	
	for (i = 0; str[i]; i++) {
	    outchar(str[i]);
	}

	free(str);
    }

    if (title)
	title_string = strmcpy(title_string,title);
    if (icon)
	icon_string = strmcpy(icon_string,icon);


    return 1;
}

/* May be called from signal handler 
   to_display = 0  -- suspended 
              = 1  -- as set
	      = 2  -- exiting
*/

void switch_title(to_display)
     int to_display;
{
    char buffer[1024];

    char * str = NULL;
    

    switch (to_display) {
    case 0: 
	str = terminal_set_title(terminal_type,
				 title_suspended_string,
				 icon_suspended_string, 
				 buffer, sizeof buffer);
	break;
    case 1:
	str = terminal_set_title(terminal_type,
				 title_string,
				 icon_string, 
				 buffer, sizeof buffer);
	break;
    case 2:
	str = terminal_set_title(terminal_type,
				 title_quit_string,
				 icon_quit_string, 
				 buffer, sizeof buffer);
	break;
    }
    

    if (str) {
	int i;

	SIGDPRINT(Debug,4,(&Debug, 
			"Setting terminal title ("));
	for (i = 0; str[i]; i++) {
	    SIGDPRINT(Debug,4,(&Debug, 
			       "%s%02X",
			       i ? " " : "", str[i]));
	}
	SIGDPRINT(Debug,4,(&Debug,
			") [terminal %s]\n",terminal_type));
	
	for (i = 0; str[i]; i++) {
	    outchar(str[i]);
	}

    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
