static char rcsid[] = "@(#)$Id: menu_param.c,v 2.5 2018/06/30 16:06:49 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.5 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_screen.h"

DEBUG_VAR(Debug,__FILE__,"screen");

static void mp_lookup_any1 P_((struct menu_param *list, int idx, 
			      struct menu_param *v));
static void mp_lookup_any1(list,idx,v)
     struct menu_param *list; 
     int idx; 
     struct menu_param *v;
{
    int i;

    for (i = 0; i < idx; i++) {
	if (mp_END == list[i].t) 
	    panic("SCREEN PANIC",__FILE__,__LINE__,"mp_lookup_any1",
		  "Bad index",0);
    }

    if (v->t != list[i].t)
	panic("SCREEN PANIC",__FILE__,__LINE__,"mp_lookup_any1",
	      "Bad type",0);

    *v = list[i];
}

void mp_set_any1(list,idx,v)
     struct menu_param *list; 
     int idx; 
     struct menu_param *v;
{
    int i;

    for (i = 0; i < idx; i++) {
	if (mp_END == list[i].t) 
	    panic("SCREEN PANIC",__FILE__,__LINE__,"mp_set_any1",
		  "Bad index",0);
    }

    if (v->t != list[i].t)
	panic("SCREEN PANIC",__FILE__,__LINE__,"mp_set_any1",
	      "Bad type",0);
    
    list[i].u = v->u;
}

/* ----------------------------------------------------------------*/	    


int mp_lookup_integer(list,idx)
     struct menu_param *list; 
     int idx;
{
    struct menu_param v1;
    
    v1.t   = mp_integer;
    
    mp_lookup_any1(list,idx,&v1);
    
    return v1.u.i;
}


struct menu_common *  mp_lookup_mcommon(list,idx)
     struct menu_param *list;
     int idx;
{
    struct menu_param v1;
    
    v1.t   = mp_menu_common;
    
    mp_lookup_any1(list,idx,&v1);
    
    return v1.u.c;
}


struct menu_anon_param * mp_lookup_anon(list,idx)
     struct menu_param *list;
     int idx;
{
    struct menu_param v1;

    v1.t   = mp_anon_param;

    mp_lookup_any1(list,idx,&v1);
    
    return v1.u.a;
}

void mp_list_set_integer(list,idx,v)
     struct menu_param *list; 
     int idx; 
     int v;
{
    struct menu_param v1;

    v1.t   = mp_integer;
    v1.u.i = v;

    mp_set_any1(list,idx,&v1);    
}

void mp_list_set_mcommon(list,idx,v)
     struct menu_param *list;
     int idx;
     struct menu_common  *v;
{
    struct menu_param v1;

    v1.t   = mp_menu_common;
    v1.u.c = v;

    mp_set_any1(list,idx,&v1);    
}

void mp_list_set_anon(list,idx,v)
     struct menu_param *list;
     int idx;
     struct menu_anon_param  *v;
{
    struct menu_param v1;

    v1.t   = mp_anon_param;
    v1.u.a = v;

    mp_set_any1(list,idx,&v1);    
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
