static char rcsid[] = "@(#)$Id: read_rc.c,v 2.8 2015/03/17 16:35:17 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/read_rc.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains programs to allow the user to have a .elm/elmrc file
    in their home directory containing any of the following: 

	fullname= <username string>
	maildir = <directory>
	tmpdir  = <directory>
	sentmail = <file>
	editor  = <editor>
	receviedmail= <file>
	calendar= <calendar file name>
	shell   = <shell>
	print   = <print command>
	weedout = <list of headers to weed out>
	prefix  = <copied message prefix string>
	pager   = <command to use for displaying messages>
	configoptions = <list of letters to use for options menu>
	precedences = <list of delivery precedences>
	
	escape  = <single character escape, default = '~' >

--
	signature = <.signature file for all outbound mail>
OR:
	localsignature = <.signature file for local mail>
	remotesignature = <.signature file for non-local mail>
--

	readmsginc = <new folder message count display increment>
	sleepmsg = time to 'sleep' while displaying transient messages
	timeout = <seconds for main menu timeout or zero to disable>
	userlevel = <0=amateur, 1=okay, 2 or greater = expert!>

	sortby  = <sent, thread, received, from, size, subject, mailbox, status>
	alias_sortby  = <alias, name>

	alternatives = <list of addresses that forward to us>

	builtinlines = <use builtin pager if message shorter than # lines>

    and/or the logical arguments:
	
	autocopy    [on|off]
	askcc	    [on|off]
	copy        [on|off]	
	resolve     [on|off]
	weed        [on|off]
	noheader    [on|off]
	titles      [on|off]
	savebyname  [on|off]
	forcename   [on|off]
	movepage    [on|off]
	pointnew    [on|off]
	hpkeypad    [on|off]
	hpsoftkeys  [on|off]
	alwayskeep  [on|off]
	alwaysstore [on|off]
	alwaysdel   [on|off]
	arrow	    [on|off]
	menus	    [on|off]
	metoo	    [on|off]
	forms	    [on|off]
	names	    [on|off]
	ask	    [on|off]
	keepempty   [on|off]
	promptafter [on|off]
	sigdashes   [on|off]
	usetite	    [on|off]


    Lines starting with '#' are considered comments and are not checked
    any further!

**/

#include "def_elm.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"config");

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif       

#if DEBUG
static void dump_rc_results P_((void));
#endif

void directory_check() 
{
    char  filename[SLEN];
    int ch;

#if DEBUG
    if (Debug.active > 10) 	/** only do this if we REALLY want debug! **/
	dump_rc_results();
#endif

    /* see if the user has a $HOME/.elm directory */
    elm_sfprintf(filename, sizeof filename,
		 FRM("%s/.elm"), 
		 home);
    if (access(filename, 00) == -1) {
	int LINES, COLUMNS;
	struct menu_context *cpage;

	if(!OPMODE_IS_INTERACTIVE(opmode))  {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBatchDirNotice, 
			      "\nNotice:\
\nThis version of ELM requires the use of a .elm directory to store your\
\nelmrc and alias files. I'd like to create the directory .elm for you\
\nand set it up, but I can't in \"batch mode\".\
\nPlease run ELM in \"normal mode\" first.\n"));
	    exit(1);
	}
    
	NewLine();
	cpage = Raw(ON | NO_TITE);

	menu_get_sizes(cpage, &LINES, &COLUMNS);   

	menu_MoveCursor(cpage,LINES-1,0);
	menu_CleartoEOS(cpage);

    redraw1:
	menu_Write_to_screen(cpage,CATGETS(elm_msg_cat, ElmSet, ElmDirNotice, 
				"\n\rNotice:\
\n\rThis version of ELM requires the use of a .elm directory in your home\
\n\rdirectory to store your elmrc and alias files. Shall I create the\
\n\rdirectory .elm for you and set it up (%c/%c/q)? %c%c"),
	     *def_ans_yes, *def_ans_no, *def_ans_no, BACKSPACE);
    
	FlushBuffer();

	ch= menu_ReadCh(cpage,REDRAW_MARK|READCH_sig_char);


	if (REDRAW_MARK == ch)
	    goto redraw1;

	if (TERMCH_interrupt_char == ch ||
	    EOF == ch)
	    goto cancel;
    
#ifdef ASCII_CTYPE
	if (isascii(ch))
#endif
	    ch = tolower(ch);

	/* they took the default by pressing cr */
	if (ch == '\n' || ch == '\r') 
	    ch = *def_ans_no;
	  
	if (ch == *def_ans_no) {
	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeNo,
					 "No.\n\rVery well. I won't create it.\n\rBut, you may run into difficulties later.\n\r"));
	    if (sleepmsg > 0) {
		error_sleep(sleepmsg *2);
	    }
	}
	else if (ch == *def_ans_yes) {
	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeYes,
					 "Yes.\n\rGreat! I'll do it now.\n\r"));
	    create_new_elmdir();
	}
	else {
	cancel:
	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeQuit,
					 "Quit.\n\rOK.  Bailing out of ELM.\n\r"));
	    Raw(OFF | NO_TITE);
	    exit(1);
	}
	Raw(OFF | NO_TITE);
    }	  

  /* see if the user has a folders directory */
    {
	/* give_dt_estr_as_str adds / to end */
	const char * folders_val = give_dt_estr_as_str(&folders_e,"maildir",
						       NULL,NULL);

	if (folders_val) {
	    if (access(folders_val, 00) == -1) {
		int LINES, COLUMNS;
		struct menu_context *cpage;

		if (! OPMODE_IS_INTERACTIVE(opmode))  {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBatchNoticeFoldersDir, 
				      "\n\
Notice:\n\
ELM requires the use of a folders directory to store your mail folders in.\n\
I'd like to create the directory %s for you,\n\
but I can't in \"batch mode\". Please run ELM in \"normal mode\" first.\n"),
			      folders_val);
		    exit(1);
		}

		NewLine();
		cpage = Raw(ON | NO_TITE );

		menu_get_sizes(cpage, &LINES, &COLUMNS);   

		menu_MoveCursor(cpage,LINES-1,0);
		menu_CleartoEOS(cpage);

	    redraw2:
		menu_Write_to_screen(cpage,CATGETS(elm_msg_cat, ElmSet, ElmNoticeFoldersDir,
						   "\n\rNotice:\n\r\
ELM requires the use of a folders directory to store your mail folders in.\n\r\
Shall I create the directory %s for you (%c/%c/q)? %c%c"),
				     folders_val, *def_ans_yes, *def_ans_no, *def_ans_yes, BACKSPACE);
		
		FlushBuffer();
		ch = menu_ReadCh(cpage,REDRAW_MARK|READCH_sig_char);

		if (TERMCH_interrupt_char == ch ||
		    EOF == ch)
		    goto cancel2;

		if (REDRAW_MARK == ch)
		    goto redraw2;
		
#ifdef ASCII_CTYPE
		if (isascii(ch))
#endif
		    ch = tolower(ch);

		if (ch == '\n' || ch == '\r') /* they took the default by pressing cr */
		    ch = *def_ans_yes;

		if (ch == *def_ans_no) {
		    menu_Write_to_screen(cpage,
					 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeNo,
				     "No.\n\rVery well. I won't create it.\n\rBut, you may run into difficulties later.\n\r"));
		    if (sleepmsg > 0) {
			error_sleep(sleepmsg *2);
		    }
		}
		else if (ch == *def_ans_yes) {
		    menu_Write_to_screen(cpage,
					 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeYes,
						 "Yes.\n\rGreat! I'll do it now.\n\r"));
		    create_new_folders();
		}
		else {
		cancel2:
		    menu_Write_to_screen(cpage,
					 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeQuit,
						 "Quit.\n\rOK.  Bailing out of ELM.\n\r"));
		    Raw(OFF | NO_TITE);
		    exit(0);
		}
		Raw( OFF | NO_TITE );
	    }
	}
    }

/* validate/correct config_options string */

    if (config_options[0]) {
	char *t;
	char * s = shift_lower(config_options);
	
	for (t = config_options; *s; ++s) {
	    const struct opts_menu_item *o;
	    
	    if (*s == '_' || *s == '^') {
		*t++ = *s;
		continue;
	    }
	    o = find_cfg_opts(*s);
	    if (o != NULL)
		*t++ = *s; /* silently remove invalid options */
	}
	*t = '\0';
    }
}

void aliases_check(main_aliases)
     struct AliasView *main_aliases;
{
    const char *from_filename, *to_filename;

    struct aliases_find_state * state = aliases_find_init(main_aliases);

    while (aliases_find_compat(state, &from_filename,&to_filename)) {

	int LINES, COLUMNS;
	struct menu_context *cpage;
	int ch;

	if (! OPMODE_IS_INTERACTIVE(opmode))  {

	    if (to_filename)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmOldAliasBatch,
				  "\n\
Notice:\n\
Found alias file %s on old format. I'd like to convert \n\
it to %s for you, but I can't in \"batch mode\". \n\
Please run ELM in \"normal mode\" first.\n"),
		    from_filename,to_filename);

	    continue;  /* Just uses old file */
	}
  
	NewLine();
	cpage = Raw(ON | NO_TITE );

	menu_get_sizes(cpage, &LINES, &COLUMNS);   

	menu_MoveCursor(cpage,LINES-1,0);
	menu_CleartoEOS(cpage);
     
    redraw:
	if (to_filename)
	    menu_Write_to_screen(cpage,CATGETS(elm_msg_cat, ElmSet, ElmOldAliasConvert,
					       "\n\rNotice:\
\n\rFound alias file %s on old format. I'd like to \
\n\rconvert it to %s for you. Shall I c)onvert it \
\n\ror u)se it? (c/u/%c/q) c%c"),
				 from_filename,to_filename,
				 *def_ans_no,BACKSPACE);
	else
	    menu_Write_to_screen(cpage,CATGETS(elm_msg_cat, ElmSet, ElmOldAliasUse,
					     "\n\rNotice:\
\n\rFound alias file %s on old format. \
\n\rShall I use it (%c/%c/q)? %c%c"),
			       from_filename, *def_ans_yes, *def_ans_no, *def_ans_yes, BACKSPACE);

	FlushBuffer();
	ch = menu_ReadCh(cpage,REDRAW_MARK|READCH_sig_char);
	
	if (TERMCH_interrupt_char == ch ||
	    EOF == ch)
	    goto cancel3;

	if (REDRAW_MARK == ch)
	    goto redraw;

#ifdef ASCII_CTYPE
	if (isascii(ch))
#endif
	    ch = tolower(ch);

	if (ch == '\n' || ch == '\r') /* they took the default by pressing cr */
	    ch = to_filename ? 'c' : *def_ans_yes;

	
	if (ch == *def_ans_no) {

	    aliases_find_remove(state);
	    
	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmOldAliasNo,
					 "No.\n\rVery well. I won't use it.\n\r"));

	    if (sleepmsg > 0) {
		error_sleep(sleepmsg *2);
	    }

	} else if (ch == *def_ans_yes ||
		   ch == 'u') {

	    if (ch == *def_ans_yes)
		menu_Write_to_screen(cpage,
				     CATGETS(elm_msg_cat, ElmSet, ElmOldAliasYes,
					     "Yes.\n\rOK. I use it.\n\r"));
	    else
		menu_Write_to_screen(cpage,
				     CATGETS(elm_msg_cat, ElmSet, ElmOldAliasUseOK,
					     "Use.\n\rOK. I use it.\n\r"));

	    if (sleepmsg > 0) {
		error_sleep(sleepmsg *2);
	    }

	    /* Nothing need to be done, it is already on use */

	} else if (ch == 'c') {

	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmOldAliasConvert,
					 "Convert.\n\rGreat. I convert it.\n\r"));

	    if (sleepmsg > 0) {
		error_sleep(sleepmsg *2);
	    }

	    aliases_find_convert(state);

	} else {
	cancel3:
	    menu_Write_to_screen(cpage,
				 CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeQuit,
					 "Quit.\n\rOK.  Bailing out of ELM.\n\r"));
	    Raw(OFF | NO_TITE);
	    exit(0);
	}
	Raw( OFF | NO_TITE );

    }

    aliases_find_free(&state);

}


#if DEBUG
static void dump_rc_results()
{
    int i;

    for (i = 0; i < NUMBER_OF_SAVEABLE_OPTIONS; i++) {

	 if (DT_SYN == save_info[i].dt_type ||
	     DT_MLT == save_info[i].dt_type)
	     continue;	 

	 {   /* Not very effective */
	     FILE * X = debug_to_FILE(&Debug);

	     if (X) {
		 save_info[i].dt_type->print_value(X,
						   & save_info[i],
						   0,
						   system_charset /* ??? */);
		 fclose(X);
	     }
	 }

    }
    DPRINT(Debug,1,(&Debug,  "\n\n"));
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
