static char rcsid[] = "@(#)$Id: opt_generic.c,v 2.19 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.19 $   $State: Exp $
 *
 *  Most of code moved from src/options.c
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/options.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1986,1987 Dave Taylor
 * 			Copyright (c) 1988-1992 USENET Community Trust
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/options.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 * 			Copyright (c) 1986,1987 Dave Taylor
 *                      Copyright (c) 1988-1995 USENET Community Trust
 ***************************************************************************/

#include "def_elm.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_elm.h"
#include "opt_imp.h"

DEBUG_VAR(Debug,__FILE__,"ui");



static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str)
     char *str;
{
    return (unsigned char *)str;
}

static void  on_or_off P_((int *var, int x, int y,
			   struct menu_context  *page));
static void  on_or_off(var, x, y, page)
     int *var, x,y;
     struct menu_context  *page;
{
    /** 'var' field at x.y toggles between on and off... **/

    int ch;
    int oldvar = *var;

    if (*var)
	menu_PutLineX(page,x,y, 
			      CATGETS(elm_msg_cat, ElmSet, ElmOn, "ON "));
    else
	menu_PutLineX(page,x,y, 
		      CATGETS(elm_msg_cat, ElmSet, ElmOff, "OFF"));
    menu_CleartoEOLN(page);

    
    menu_PutLineX(page,
		  x, y+6, 
		  CATGETS(elm_msg_cat, ElmSet, ElmUseSpaceToToggle,
			  "(use <space> to toggle, any other key to leave)"));

    menu_MoveCursor(page,x,y+3);	/* at end of value... */
    
    do {
	ch = menu_ReadCh(page,READCH_sig_char|READCH_CURSOR);
	
	if (ch == TERMCH_interrupt_char ||
	    ch == EOF) {
	    *var = oldvar;
	    break;
	}
	
	if (ch == ' ') {
	    *var = ! *var;
	    
	    if (*var)
		menu_PutLineX(page,x,y, 
			      CATGETS(elm_msg_cat, ElmSet, ElmOn, "ON "));
	    else
		menu_PutLineX(page,x,y, 
			      CATGETS(elm_msg_cat, ElmSet, ElmOff, "OFF"));
	    
	}
    } while (ch == ' ');
    
    menu_MoveCursor(page,x,y+4); 	
    menu_CleartoEOLN(page);	/* remove help prompt */
}


/* Returns 1 if changed */
static int change_enum P_((struct dt_enumerate_info *enumeration,
			   int x, int y,
			   struct menu_context  *page,
			   const char *fieldname
			   
			   ));
static int change_enum(enumeration, x, y, page,fieldname)
     struct dt_enumerate_info *enumeration;
     int x, y;
     struct menu_context  *page;
     const char *fieldname;
{
    int c;
    int oldval = enumeration->val;
    int val    = enumeration->val;

    menu_PutLineX(page,
		  x,y, FRM("%s"), 
		  give_dt_enumerate_as_str(enumeration));
    menu_CleartoEOLN(page);
    
    menu_PutLineX(page,
		  x, y+20, 
		  CATGETS(elm_msg_cat, ElmSet, ElmSpaceToChange,
			  "<space> to change"));

    menu_MoveCursor(page,
		    x,y);	/* at end of value... */

    while ((c = menu_ReadCh(page,0)) == ' ') {

	val = (val +1 ) % enumeration->nlen;

	menu_PutLineX(page,
		      x,y, FRM("%s"), enumeration->list[val]);

	menu_CleartoEOLN(page);
	
	menu_PutLineX(page,
		      x, y+20, 
		      CATGETS(elm_msg_cat, ElmSet, ElmSpaceToChange,
			      "<space> to change"));

	menu_MoveCursor(page,
			x,y);	/* at end of value... */	
    }

    if (c == TERMCH_interrupt_char ||
	c == EOF) {
    fail:
	menu_PutLineX(page,
		      x,y, FRM("%s"), 
		      give_dt_enumerate_as_str(enumeration));
	menu_CleartoEOLN(page);

	return 0;
    }

    if (c != '\n') {
	char buffer[SLEN+1];
	int code;

	menu_MoveCursor(page,
			x,y);	/* at end of value... */	
	menu_CleartoEOLN(page);

	buffer[0] = c;
	buffer[1] = '\0';

	code = optionally_enter(buffer, x,y,
				OE_SIG_CHAR|OE_REDRAW_MARK|OE_APPEND_CURRENT,
			 sizeof buffer,page);

	if (0 != code)     /* Ctrl-C, error or REDRAW_MARK*/
	    goto fail;

	if (! set_dt_enumerate_as_str(enumeration,buffer,
				      fieldname,
				      0,NULL))
	    goto fail;
    } else
	enumeration->val = val;	

    menu_PutLineX(page,
		  x,y, FRM("%s"), 
		  give_dt_enumerate_as_str(enumeration));
    menu_CleartoEOLN(page);

    return oldval != enumeration->val;
}


static void sort_one_liner   P_((int sorting_by,
				 struct menu_context *page));
static void sort_one_liner(sorting_by, page)
     int sorting_by;
     struct menu_context *page;
{
    /** A one line summary of the particular sorting scheme... **/
    int LINES, COLUMNS;
    
    menu_get_sizes(page,&LINES, &COLUMNS);
    
    menu_ClearLine(page,LINES-3);
    
    switch (sorting_by) {
	
    case REVERSE SENT_DATE:	
	menu_print_format_center(page,LINES-3,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmSortRSentDate,
					 "This sort will order most-recently-sent to least-recently-sent"));
	break;
    case REVERSE THREAD:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRThread,
					 "This sort will order most-recent-thread to least-recent-thread"));
	break;

    case REVERSE RECEIVED_DATE:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, 
					 ElmSortRRecvDate,
					 "This sort will order most-recently-received to least-recently-received"));
	break;

    case REVERSE MAILBOX_ORDER:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRMailbox,
					 "This sort will order most-recently-added-to-folder to least-recently"));
	break;
    case REVERSE SENDER:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRSender,
					 "This sort will order by sender name, in reverse alphabetical order"));
	break;

    case REVERSE SIZE:	      
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRSize,
					 "This sort will order messages by longest to shortest"));
	break;

    case REVERSE SUBJECT:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRSubject,
					 "This sort will order by subject, in reverse alphabetical order"));
	break;

    case REVERSE STATUS:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRStatus,
					 "This sort will order by reverse status - Deleted through Tagged..."));
	break;

    case SENT_DATE:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortSentDate,
					 "This sort will order least-recently-sent to most-recently-sent"));
	break;

    case THREAD:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortThread,
					 "This sort will order least-recent-thread to most-recent-thread"));
	break;

    case RECEIVED_DATE:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortRecvDate,
					 "This sort will order least-recently-received to most-recently-received"));
	break;
	
    case MAILBOX_ORDER:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortMailbox,
					 "This sort will order least-recently-added-to-folder to most-recently"));
	break;

    case SENDER:			
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortSender,
					 "This sort will order by sender name"));
	break;

    case SIZE:			
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortSize,
					 "This sort will order messages by shortest to longest"));
	break;

    case SUBJECT:		       
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortSubject,
					 "This sort will order messages by subject"));
	break;

    case STATUS:		       
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmSortStatus,
					 "This sort will order by status - Tagged through Deleted..."));
	break;
    }
}

static void alias_sort_one_liner P_((int sorting_by,
				     struct menu_context *page));
static void alias_sort_one_liner(sorting_by,page)
     int sorting_by;
     struct menu_context *page;
{
    /** A one line summary of the particular sorting scheme... **/
    int LINES, COLUMNS;
    
    menu_get_sizes(page,&LINES, &COLUMNS);
    
    menu_ClearLine(page,LINES-3);
    
    switch (sorting_by) {
	
    case REVERSE ALIAS_SORT:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortRAlias,
					 "This sort will order by alias name, in reverse alphabetical order"));
	break;

    case REVERSE NAME_SORT:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortRName,
					 "This sort will order by user (real) name, in reverse alphabetical order"));
	break;

    case REVERSE TEXT_SORT:	
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortRText,
					 "This sort will order aliases in the reverse order as listed in aliases.text"));
	break;
	
    case ALIAS_SORT:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortAlias,
					 "This sort will order by alias name"));
	break;

    case NAME_SORT:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortName,
					 "This sort will order by user (real) name"));
	break;

    case TEXT_SORT:		
	menu_print_format_center(page,LINES-1-2,
				 CATGETS(elm_msg_cat, ElmSet, ElmASortText,
					 "This sort will order aliases in the order as listed in aliases.text"));
	break;
    }
}




static int change_sort P_((struct dt_sort_info *var, int x, int y,
			   struct menu_context *page));
static int change_sort(var, x, y, page)
     struct dt_sort_info *var;
     int x,y;
     struct menu_context *page;
{
    /** change the sorting scheme... **/
    /** return !0 if new sort order, else 0 **/
    
    int last_sortby,    /* so we know if it changes... */
	sign = 1;		/* are we reverse sorting??    */
    int ch;			/* character typed in ...      */

    int last_unstable   = unstable_reverse_thread;

    int LINES, COLUMNS;
    int z,lastval=0;

    menu_get_sizes(page,&LINES, &COLUMNS);

    /* mailbox sort values are not in order! */
    for (z = 0; var->sortval[z].kw; z++)
	if (lastval < var->sortval[z].sv)
	    lastval = var->sortval[z].sv;


/*	*var = sortby; 	or...	*var == sortby; 	*/
    last_sortby = var->val;	/* remember current ordering   */


    if (var == &sortby) {
	menu_PutLine0(page,x, y, sort_name(PAD));	   
	menu_CleartoEOLN(page);

	sort_one_liner(var->val, page);

    } else if (var == &alias_sortby) {
	menu_PutLine0(page,x, y, alias_sort_name(PAD));	   
	menu_CleartoEOLN(page);

	alias_sort_one_liner(var->val,page);
    } else {
	menu_PutLine0(page,x, y, give_dt_sort_as_str(var));	   
	menu_CleartoEOLN(page);

    }


    if (var != &sortby ||
	var->val != REVERSE THREAD)
	menu_PutLineX(page,x, COLUMNS-30, 
		      CATGETS(elm_msg_cat, ElmSet, ElmSpaceForNext,
			      " (SPACE for next, or R)everse)"));
    else
	menu_PutLineX(page,x, COLUMNS-30, 
		      CATGETS(elm_msg_cat, ElmSet, ElmReverseUnstable,
			      "(SPACE, R)everse or U)nstable)"));


    menu_MoveCursor(page,x, y);
    
    do {
	int o = var->val;
	
	ch = menu_ReadCh(page, READCH_sig_char|READCH_CURSOR);
	
	if (ch == TERMCH_interrupt_char ||
	    ch == EOF) {
	    var->val             = last_sortby;
	    unstable_reverse_thread = last_unstable;
	    break;
	}

#ifdef ASCII_CTYPE
	if (isascii(ch))
#endif
	    ch = tolower(ch);

	switch (ch) {
	case ' ' : 
	    if (var->val < 0) { 
		sign = -1; 
		var->val = - var->val; 
	    } else 
		sign = 1;		/* insurance! */

	    var->val = sign * ((var->val + 1) % (lastval+1));
	    if (var->val == 0 &&
		var->sortval[0].sv != 0) 
		var->val = sign;  /* snicker */
	    
	    if (var == &sortby) {
		menu_PutLine0(page,x, y, sort_name(PAD));
		sort_one_liner(var->val, page);
	    } else if (var == &alias_sortby) {
		menu_PutLine0(page,x, y, alias_sort_name(PAD));	   
		alias_sort_one_liner(var->val,page);
	    } else {
		menu_PutLine0(page,x, y, give_dt_sort_as_str(var));	   
		menu_CleartoEOLN(page);
		menu_PutLineX(page,x, COLUMNS-30, 
			      CATGETS(elm_msg_cat, ElmSet, ElmSpaceForNext,
				      " (SPACE for next, or R)everse)"));
	    }

	    menu_MoveCursor(page, x, y);
	    break;
	    
	case 'r'   : 
	    var->val = - var->val;

	    if (var == &sortby) {
		menu_PutLine0(page, x, y, sort_name(PAD));
		sort_one_liner(var->val, page);
	    }
	    else if (var == &alias_sortby) {
		menu_PutLine0(page, x, y, alias_sort_name(PAD));	   
		alias_sort_one_liner(var->val,page);
	    }	    
	    else
	    {
		menu_PutLine0(page, x, y, give_dt_sort_as_str(var));	   
		menu_CleartoEOLN(page);
		menu_PutLineX(page,x, COLUMNS-30, 
			      CATGETS(elm_msg_cat, ElmSet, ElmSpaceForNext,
				      " (SPACE for next, or R)everse)"));
	    }
	    
	    menu_MoveCursor(page, x, y);
	    
	    break;
	    
	  case 'u': 
	      if (var == &sortby &&
		  var->val == REVERSE THREAD) {
		  
		  unstable_reverse_thread = !unstable_reverse_thread;
		  menu_PutLine0(page, x, y, sort_name(PAD));
		  sort_one_liner(var->val, page);
		  menu_MoveCursor(page, x, y);
		  		  
	      }
	      break;
	}

	if (var == &sortby &&
	    ( o     == REVERSE THREAD ||
	      var->val == REVERSE THREAD)) {
	    
	    if (var->val != REVERSE THREAD)
		menu_PutLineX(page,x, COLUMNS-30, 
			      CATGETS(elm_msg_cat, ElmSet, ElmSpaceForNext,
				      " (SPACE for next, or R)everse)"));
	    else
		menu_PutLineX(page,x, COLUMNS-30, 
			      CATGETS(elm_msg_cat, ElmSet, ElmReverseUnstable,
				      "(SPACE, R)everse or U)nstable)"));
	    menu_MoveCursor(page, x, y);
	    
	}

    } while (ch == ' ' || ch == 'r' || ch == 'u');

    menu_MoveCursor(page,x, COLUMNS-30);	
    menu_CleartoEOLN(page);

    menu_ClearLine(page,LINES-3);		/* clear sort_one_liner()! */
    

    if (var == &sortby &&
        (var->val != last_sortby ||
         unstable_reverse_thread != last_unstable)) {

     return 1;
    }

    return(var->val != last_sortby);
}


static int info_enter P_((char *name, int ypos, int xpos, int append_current, 
			  int passwd, 
			  struct menu_context *page));

/*
 * This routine is a "shell" to optionally_enter(), etc. so that
 * we can use save_info structure and tag the param as being changed
 * locally (so we know to save it to the .elm/elmrc file).
 */
static int info_enter(name, ypos, xpos, append_current, passwd, page)
     char *name;
     int ypos, xpos, append_current, passwd;
     struct menu_context *page;
{
    int x,q = 0;
    int number;
    int LINES, COLUMNS;

    menu_get_sizes(page,&LINES, &COLUMNS);

    for (x = 0; x < NUMBER_OF_SAVEABLE_OPTIONS; x++) {
	q = strcmp(name, save_info[x].name);
	if (q <= 0)
	    break;
    }

    if (q)
	return(1);
    
    if (&rc_DT_SORT == save_info[x].dt_type) {
	if (change_sort(save_info[x].val.sort, 
			ypos, xpos, page) != 0) {
	    ++q;
	}


    } else if (DT_BOL == save_info[x].dt_type) {
	number = *SAVE_INFO_BOL(x);
	on_or_off(&number, ypos, xpos, page);

	if (number != *SAVE_INFO_BOL(x)) {
	    *SAVE_INFO_BOL(x) = number;
	    ++q;
	}
	
    } else if (&rc_DT_ENUM == save_info[x].dt_type) {

	if (change_enum(save_info[x].val.enumerate, ypos, xpos, page,
			save_info[x].name))
	    q++;

    } else {   /* Hopefully generic routine ... */	
	int code;
	char * s;
	struct string * buffer = NULL;
	
	if (RCTYPE_magic != save_info[x].dt_type->magic)
	    panic("RC PANIC",__FILE__,__LINE__,"info_enter",
		  "Bad config item type",0);

	s = save_info[x].dt_type->get_value(& save_info[x]);

	if (s)
	    buffer = new_string2(system_charset,s2us(s));
	else
	    buffer = new_string(system_charset);

	/* XXX */

	code = optionally_enter2(page,&buffer,ypos, xpos,
				 (append_current ? OE_APPEND_CURRENT : 0) |
				 (passwd ? OE_PASSWD : 0) |
				 OE_SIG_CHAR|OE_REDRAW_MARK,
				 FRM(""));


	if (0 != code || !buffer)     /* Ctrl-C, error or REDRAW_MARK*/ {

	    if (buffer)
		free_string(&buffer);

	    return 0;
	}

	if (!s || !string_matches_ascii(buffer,s2us(s),0,SMA_op_normal)) {
	    
	    if (save_info[x].dt_type->parse_line(& save_info[x],
						 1 /* local */ ,buffer,
						 0,"<config editor>",
						 0,0))
		q++;
	}	    	

	free_string(&buffer);
    }

    if (q)
	mark_XX(& (save_info[x]), 1 /* no history record */);
    
    return(q != 0);
}


/* ------------------------------------------------------------------ */


struct optsmenu * malloc_optsmenu()
{
    struct optsmenu *ret = safe_malloc(sizeof (*ret));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->magic = OPTION_MENU_magic;

    ret->items       = NULL;
    ret->item_count  = 0;

    ret->prompt_len  = 20;

    return ret;
}

void free_optsmenu(ptr)
     struct optsmenu **ptr;
{

    if (OPTION_MENU_magic != (*ptr)->magic)
	panic("RC PANIC",__FILE__,__LINE__,"free_optsmenu",
	      "Bad magic number",0);

    if ((*ptr)->items) {
	int i;

	for (i = 0; i < (*ptr)->item_count; i++) {

	    if ((*ptr)->items[i].menu_prompt)
		free_string(& ((*ptr)->items[i].menu_prompt));


	    if ((*ptr)->items[i].parm)
		free((*ptr)->items[i].parm);
	    (*ptr)->items[i].parm = NULL;


	    if ((*ptr)->items[i].one_liner_text)
		free_string(& ((*ptr)->items[i].one_liner_text));
	  
	}

	free((*ptr)->items);
	(*ptr)->items = NULL;

    }
    (*ptr)->item_count = 0;

    
    (*ptr)->magic = 0;     /* Invalidate */

    free(*ptr);
    *ptr = NULL;
}

void NULL_option_post_handling(f)
     int f;
{
    /* Nothing */
}

/* pointers are shared -- must be malloced and caller must not free them */
void add_option(ptr,letter,parm,menu_prompt,one_liner, post)
     struct optsmenu *ptr; 
     int letter;
     char *parm; 
     struct string *menu_prompt;
     struct string *one_liner;
     option_post_handling_f *post;
{
    int len;
    int x;
    int A;

    if (OPTION_MENU_magic != ptr->magic)
	panic("RC PANIC",__FILE__,__LINE__,"add_option",
	      "Bad magic number",0);

    len = ptr->item_count + 1;
    ptr->items = safe_array_realloc(ptr->items,
				    len,  sizeof (ptr->items[0]));
    
    x = ptr->item_count;

    ptr->items[x].letter      = letter;
    ptr->items[x].parm        = parm;
    ptr->items[x].menu_prompt = menu_prompt;
    ptr->items[x].one_liner_text = one_liner;
    ptr->items[x].post        = post;


    /* XXXX Do not take account double width characters!! */
    A = string_len( ptr->items[x].menu_prompt);

    if (ptr->prompt_len < A)
	ptr->prompt_len = A;
   
    ptr->item_count++;
}
		    

void add_old_options(ptr,opts)
     struct optsmenu *ptr;
     const struct OLD_optsmenu *opts;
{
    int count = 0;
    int i,x;
    int len;
    charset_t msg_charset  = display_charset;

    if (OPTION_MENU_magic != ptr->magic)
	panic("RC PANIC",__FILE__,__LINE__,"add_old_options",
	      "Bad magic number",0);

    while (opts[count].parm)
	count++;

    if (!count)
	return;


    len = ptr->item_count + count;
    ptr->items = safe_array_realloc(ptr->items,
				    len, sizeof (ptr->items[0]));
    
    for ( i = 0, x = ptr->item_count; 
	  i < count && x < len;
	  i++) {
	char *c;
	int A;

	if (opts[i].conditional_option_p &&
	    ! *(opts[i].conditional_option_p))
	    continue;

	ptr->items[x].letter = opts[i].letter;

	ptr->items[x].parm =
	    safe_strdup(opts[i].parm);

	c = catgets(elm_msg_cat, ElmSet, 
		    opts[i].menu_msg, 
		    opts[i].menu);	
	ptr->items[x].menu_prompt = 
	    new_string2(msg_charset,s2us(c));

	/* XXXX Do not take account double width characters!! */
	A = string_len( ptr->items[x].menu_prompt);

	c = catgets(elm_msg_cat, ElmSet, 
		    opts[i].one_liner_msg, 
		    opts[i].one_liner);
	ptr->items[x].one_liner_text =
	    new_string2(msg_charset,s2us(c));
       
	ptr->items[x].post = 
	    opts[i].post ? opts[i].post : NULL_option_post_handling;

	if (ptr->prompt_len < A)
	    ptr->prompt_len = A;

	x++;
    }
    ptr->item_count = x;

}

const struct opts_menu_item * gen_find_cfg_opts(cfg_opts,c)
     struct optsmenu * cfg_opts;
     int c;
{
    int i;

    if (OPTION_MENU_magic != cfg_opts->magic)
	panic("RC PANIC",__FILE__,__LINE__,"gen_find_cfg_opts",
	      "Bad magic number",0);


    
    for (i = 0; i < cfg_opts->item_count; i++) {
	
	if (c == cfg_opts->items[i].letter) {
	    
	    return & (cfg_opts->items[i]);
	}
    }
    
    return NULL;
}

static void gen_display_options P_((struct optsmenu *cfg_opts,
				    const char * opt_string,
				    const struct string * title,
				    struct menu_context *page));

static void gen_display_options(cfg_opts,opt_string,title,page)
     struct optsmenu *cfg_opts;
     const char * opt_string;
     const struct string * title;
     struct menu_context *page;
{
    /** Display all the available options.. **/
    
    int printed_title = FALSE;
    int y;
    
    const char *s;
    int LINES, COLUMNS;

    menu_get_sizes(page,&LINES, &COLUMNS);
	
    menu_ClearScreen(page);

    for (s = opt_string, y = 0; *s; s++, y++) {
	const struct opts_menu_item *o;

	if (*s == '^') {
	    printed_title = TRUE;
	    
	    menu_StartXX(page,pg_BOLD);
	    
	    menu_print_center(page,y,title);
	    
	    menu_EndXX(page,pg_BOLD);
	    
	    continue;
	}
	if (*s == '_') {
	    continue;
	}
	o = gen_find_cfg_opts(cfg_opts,*s);
	
	if (o != NULL && y<LINES-7) {
	    PutLineX(y, 0, FRM("%-*.*S : %s"), 
		     cfg_opts->prompt_len,
		     cfg_opts->prompt_len,
		     o->menu_prompt,
		     str_opt_nam(o->parm, FULL));
	}

    }

    if (!printed_title) {
	
	menu_StartXX(page,pg_BOLD);

	menu_print_center(page,y,title);

	menu_EndXX(page,pg_BOLD);
    }
}



struct option_extra * alloc_extra_action_f(
#if ANSI_C
					   int key,
					   option_extra_func * func,
					   const char *format,
					   const char *msg, ...
#else
					   key,func,format,msg, va_alist
#endif
					   )
#if !ANSI_C
     int key;
     option_extra_func * func;
     const char *format;
     const char *msg; 
     va_dcl
#endif
{
    struct option_extra *ret = safe_malloc(sizeof (*ret));

    struct string *text;
    va_list vl;

    Va_start(vl, msg);           /* defined in hdrs/elm_defs.h */

    text = elm_smessage(0,format,msg,vl);

    va_end(vl);


    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->magic = OPTION_EXTRA_magic;

    ret->key       = key;
    ret->func      = func;
    ret->help_text = text;

    return ret;
}

void free_extra_action_list(list)
     struct option_extra **list;
{
    
    while (*list) {

	struct option_extra *ptr = *list;

	if (OPTION_EXTRA_magic != ptr->magic)
	    panic("RC PANIC",__FILE__,__LINE__,"free_extra_action_list",
		  "Bad magic number",0);

	*list = ptr->next;

	if (ptr->help_text)
	    free_string(& (ptr->help_text));

	ptr->magic = 0;          /* Invalidate */
	free(ptr);

    }
} 

/*  0 == OK
    EOF
    'q'       pressed 'q'

    return value of extra_actions->func()

*/

int gen_options(cfg_opts, parent_page,extra_actions,cmds, title, 
		opt_string, menu_text)
     struct optsmenu     * cfg_opts;
     struct menu_context * parent_page;
     struct option_extra * extra_actions;
     struct elm_commands * cmds  /* for help */;
     struct string       * title;
     const char          * opt_string;
     struct string       * menu_text;
{
    struct menu_context *page = new_menu_context();
    struct menu_context *prompt_area = NULL;
    

    int LINES, COLUMNS;
    int redraw = 1;
    int ret = 0;

    menu_get_sizes(page,&LINES, &COLUMNS);

    prompt_area = new_menu_subpage(page,LINES-4,4,
				   subpage_simple_noredraw,NULL);

    while(1) {
	const struct opts_menu_item *o;
	struct option_extra * x;
	int ch,c1;

    resize_mark:
	if (menu_resized(page)) {
	
	    menu_get_sizes(page,&LINES, &COLUMNS);
	    
	    menu_subpage_relocate(prompt_area,page,LINES-3,3);

	    redraw = 1;
	} 

	if (menu_need_redraw(page) || redraw) {
	    menu_ClearScreen(page);   /* Reset possible redraw flag */
	    redraw = 0;
	    
	    gen_display_options(cfg_opts,opt_string,title,page);

	    menu_MoveCursor(page,LINES-6,0);
	    menu_CleartoEOS(page);

	    menu_print_center(page,LINES-6, menu_text);
			      					    
	}


	{   
	    int lin,col;

	    menu_ClearScreen(prompt_area);   /* Reset possible redraw flag */

	    menu_PutLineX(prompt_area,
			  0, 0, 
			  CATGETS(elm_msg_cat, ElmSet, ElmPrompt, "Command: "));
	    menu_GetXYLocation(prompt_area,&lin,&col);

	    menu_CleartoEOS(prompt_area);   
	    
	    show_last_error();
	    menu_MoveCursor(prompt_area,lin,col);

	    ch = menu_ReadCh(prompt_area, REDRAW_MARK|READCH_resize|READCH_CURSOR|
			     READCH_sig_char);

	    menu_CleartoEOS(prompt_area);

	    if (isascii(ch) && isprint(ch)) {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %c [%d]\n\n", ch, ch));
	    } else {
		DPRINT(Debug,4,(&Debug, 
				"\nCommand: %d\n\n", ch));
	    }
	    
	    clear_error();	/* clear error buffer */
	    
	    menu_MoveCursor(prompt_area,lin,col);
	}


	c1 = ch;

	switch(ch) {
	case REDRAW_MARK:
	    DPRINT(Debug,4, (&Debug, "     .... redraw\n"));

	    redraw = 1;
	    continue;

	case EOF:
	    DPRINT(Debug,4, (&Debug, "     .... EOF\n"));

	    ret = EOF;
	    goto DONE;

	case RESIZE_MARK:
	    DPRINT(Debug,4, (&Debug, "     .... resizing\n"));

	    goto resize_mark;
	
	case TERMCH_interrupt_char:
	    DPRINT(Debug,4, (&Debug, "     .... interrupt\n"));
	    
	    goto DONE;

	case '>' : 
	    menu_Writechar(prompt_area,ch);

	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSaveOptions,
			      "Save options in .elm/elmrc..."));
	    FlushBuffer();    
	    save_options(NULL);		
	    continue;

	case '?' : 
	case HELP_MARK:  {

	    int c = help_generic(cmds,FALSE, page, prompt_area);

	    if (EOF == c) {
		ret = c;
		goto DONE;
	    }

	    continue;
	    
	case 'q':
	    menu_Writechar(prompt_area,ch);
	    FlushBuffer();    

	    ret = ch;
	    goto DONE;
	    

	}
	    break;


	case ctrl('L'): 
	    DPRINT(Debug,4, (&Debug, "     .... ^L\n"));

	    redraw = 1;
	    continue;

	}

	o = gen_find_cfg_opts(cfg_opts,ch);


	if (o) {
	    char * x;

	FOUND:

	    menu_Writechar(prompt_area,ch);

	    menu_ClearLine(page,LINES-6);
	    menu_print_center(page,LINES-6,o->one_liner_text);

	    FlushBuffer();    

	    x = index(opt_string,c1);

	    if (x) {
		int y = x-opt_string;
		
		if (y < LINES-6) {

		    int r = info_enter(o->parm, y, 
				       cfg_opts->prompt_len + 3,
				       FALSE, FALSE, 
				       page);

		    (o->post)(r);

		    if (!r) { /* FAILED -- REDRAW */
			redraw = 1;
		    }

		} else
		    goto FAIL_LINES;

	    } else {
	    FAIL_LINES:

		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCommandUnknown,
				  "Command unknown!"));
	    }

	    menu_ClearLine(page,LINES-6);
	    menu_print_center(page,LINES-6, menu_text);

	    continue;
	}


	for (x = extra_actions; x; x = x->next) {

	    if (OPTION_EXTRA_magic != x->magic)
		panic("RC PANIC",__FILE__,__LINE__,"gen_options",
		      "Bad magic number",0);

	    if (ch == x->key) {
		int r = x->func(cfg_opts,page,ch);

		if (256 == r)
		    break;
		ret = r;
		goto DONE;
	    }
	}
	
	if (x)
	    continue;

#ifdef ASCII_CTYPE
	if (isascii(ch))
#endif
	    c1 = tolower(ch);

	
	if (ch != c1) {

	    o = gen_find_cfg_opts(cfg_opts,c1);

	    if (o)
		goto FOUND;


	    for (x = extra_actions; x; x = x->next) {
		
		if (OPTION_EXTRA_magic != x->magic)
		    panic("RC PANIC",__FILE__,__LINE__,"gen_options",
			  "Bad magic number",0);
		
		if (c1 == x->key) {
		    int r = x->func(cfg_opts,page,ch);
		    
		    if (256 == r)
			break;
		    ret = r;
		    goto DONE;
		}
	    }
	}
	

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCommandUnknown,
			  "Command unknown!"));    
    }

 DONE:

    erase_menu_context (&prompt_area);
    erase_menu_context (&page);

    menu_trigger_redraw(parent_page);
    menu_set_default(parent_page);

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
