static char rcsid[] = "@(#)$Id: network.c,v 2.1 2020/01/29 16:20:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.1 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org
 *****************************************************************************/

#include "def_elm.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"net");

void setup_mbx_cancel_message(cancel_info,msg)
     struct cancel_data **cancel_info;
     enum mbx_cancel_message msg;
{
    static const int close_delay_msec = 2000; /* 2000 milliseconds: 2 seconds */
    static const int exit_delay_msec  = 2000; /* 2000 milliseconds: 2 seconds */
    static const int check_delay_msec =  500; /*  500 milliseconds: 0.5 seconds */
         
    DPRINT(Debug,9, (&Debug,"setup_mbx_cancel_message: "));
    if (*cancel_info) {
	DPRINT(Debug,9, (&Debug," *cancel_info=%p",*cancel_info));
	if (is_canceled(*cancel_info)) {
	    DPRINT(Debug,9, (&Debug," (was already canceled)"));
	}
    } else {
	DPRINT(Debug,9, (&Debug," *cancel_info=NULL"));
    }
    DPRINT(Debug,9, (&Debug,", msg=%d",msg));
    switch (msg) {
    case mbx_closing_con:      DPRINT(Debug,9, (&Debug," mbx_closing_con"));      break;
    case mbx_leaving_mailbox:  DPRINT(Debug,9, (&Debug," mbx_leaving_mailbox"));  break;
    case mbx_checking_mailbox: DPRINT(Debug,9, (&Debug," mbx_checking_mailbox")); break;
    }    
    DPRINT(Debug,9, (&Debug,"\n"));

    if (*cancel_info) {
	switch (msg) {
	case mbx_closing_con:
	    set_cancel_message(*cancel_info,close_delay_msec,
			       CATGETS(elm_msg_cat, MeSet, 
				       MeClosingConnections,
				       "Closing connections..."));
	    break;
	case mbx_leaving_mailbox:
	    set_cancel_message(*cancel_info,exit_delay_msec,
			       CATGETS(elm_msg_cat, MeSet, 
				       MeLeavingMailbox,
				       "Leaving mailbox ..."));

	    break;
	case mbx_checking_mailbox:
	    set_cancel_message(*cancel_info,check_delay_msec,
			       CATGETS(elm_msg_cat, MeSet, 
				       MeCheckingMailbox,
				       "Checking mailbox ..."));	    			       
	    break;
	}
    } else {
	switch (msg) {
	case mbx_closing_con:
	    *cancel_info =
		new_schedule_cancel(close_delay_msec,
				    CATGETS(elm_msg_cat, MeSet, 
					    MeClosingConnections,
					    "Closing connections..."));

	    break;
	case mbx_leaving_mailbox:
	    *cancel_info =
		new_schedule_cancel(exit_delay_msec,
				    CATGETS(elm_msg_cat, MeSet, 
					    MeLeavingMailbox,
					    "Leaving mailbox ..."));
	    break;
	case mbx_checking_mailbox:
	    *cancel_info =
		new_schedule_cancel(check_delay_msec,
				    CATGETS(elm_msg_cat, MeSet, 
					    MeCheckingMailbox,
					    "Checking mailbox ..."));	 
	    break;
	}

	DPRINT(Debug,9, (&Debug,"setup_mbx_cancel_message: NEW --"));
	if (*cancel_info) {
	    DPRINT(Debug,9, (&Debug," *cancel_info=%p",*cancel_info));
	} else {
	    DPRINT(Debug,9, (&Debug," *cancel_info=NULL"));
	}
	DPRINT(Debug,9, (&Debug,"\n"));
    }
}



/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
