static char rcsid[] = "@(#)$Id: mkhdrs.c,v 2.11 2020/05/23 15:44:23 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.11 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/mkhdrs.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This contains the header generating routines for the ELM
    program.
**/

#include "def_elm.h"
#include "s_elm.h"

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif       

DEBUG_VAR(Debug,__FILE__,"header");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}

static const unsigned char *cs2us P_((const char *str));
static const unsigned char *cs2us(str) 
     const char *str;
{
    return (const unsigned char *)str;
}

void generate_references(current_header,headers)
     struct header_rec * current_header;
     struct mailing_headers *headers;
{
    /* Generate References: */

    /* RFC 2822:
             The "References:" field will contain the contents
             of the parent's "References:" field (if any) followed
             by the contents of the parent's "Message-ID:" field
             (if any).  If the parent message does not contain
             a "References:" field but does have an "In-Reply-To:"
             field containing a single message identifier, then the
             "References:" field will contain the contents of the
             parent's "In-Reply-To:" field followed by the contents
             of the parent's "Message-ID:" field (if any).
    */

    if (headers->references)
	free_references(& headers->references);

    if (current_header->references) {

	headers->references = 
	    dup_references_no_phrase(current_header->references);
	
	if (current_header->message_id)
	    references_add_item(headers->references,
				current_header->message_id,
				NULL,NULL);
	
    } else if (current_header->in_reply_to &&
	       1 == references_item_count(current_header->in_reply_to)) {

	headers->references = 
	    dup_references_no_phrase(current_header->in_reply_to);

	if (current_header->message_id)
	    references_add_item(headers->references,
				current_header->message_id,
				NULL,NULL);

    } else if (current_header->message_id) {
	headers->references = 
	    new_references(current_header->message_id,
			   NULL,NULL);
    }
}


void generate_reply_to(current_header,headers)
     struct header_rec * current_header;
     struct mailing_headers *headers;
{
    /** Generate an 'in-reply-to' message... **/
    int found = 0;

    if (headers->in_reply_to)
	free_references(& headers->in_reply_to);

    if (add_irt_phrase) {
	struct string * text = new_string(display_charset);
	struct string * timetext = NULL;
    
	if (current_header->message_id) 
	    add_ascii_to_string(text,s2us("from "));
	else 
	    add_ascii_to_string(text,s2us("From "));
	
	if (current_header->from) {
	    int idx;
	    int len   = addr_list_item_count(current_header->from);
	    
	    for (idx = 0; idx < len; idx++) {
		int group = -1;
		const struct address * address = 
		    addr_list_get_item(current_header->from,idx,&group);
		
		const char          * addr        = address_get_ascii_addr(address);
		const struct string * fullname    = address_get_phrase(address);
		
		if (found)
		    add_ascii_to_string(text,s2us(", "));
		
		if (fullname && string_len(fullname)) {
		    
		    append_string(& text,fullname,1);
		    found++;
		    
		} else if (addr) {
		    add_ascii_to_string(text,cs2us(addr));	    
		    found++;
		}
	    }
	}
	
	if (!found && current_header->env_from[0]) {
	    add_ascii_to_string(text,s2us("(env: "));
	    add_ascii_to_string(text,s2us(current_header->env_from));
	    add_ascii_to_string(text,s2us(")"));
	} else if (!found)
	    add_ascii_to_string(text,s2us("someone"));
	
	timetext =  elm_date_text(current_header,
				  ptr_date_header_field /* Use Date: header field value format*/,
				  elm_date_no_zone      /* Zone is always added */ );
	if (timetext) {
	    add_ascii_to_string(text,s2us(" at "));
	    append_string(& text, timetext,1);

	    free_string(&timetext);
	}
		
	headers->in_reply_to =
	    new_references(current_header->message_id,text,NULL);
	free_string(&text);
	
    } else if (current_header->message_id) {
	/* RFC 2822 (obsoletes RFC 822) says that in-reply-to
	   header should only include message-id
	*/

	headers->in_reply_to =
	    new_references(current_header->message_id,NULL,NULL);

    }
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
