static char rcsid[] = "@(#)$Id: header_alloc.c,v 2.20 2021/01/17 18:53:16 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.20 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 * Some code copied from Elm 2.4 src/newmbox.c. That file is following
 * copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_messages.h"

DEBUG_VAR(Debug,__FILE__,"messages");


void realloc_headers(storage,current_count)
     struct current_storage *storage;
     int current_count;
{

    /* Code (indirectly) copied from src/newmbox.c 
       function read_headers()
    */

    if (current_count >= storage->max_headers) {
	struct header_rec **new_headers;
	int new_max;

	new_max = storage->max_headers + KLICK;
	if (storage->max_headers == 0) {
	    new_headers = (struct header_rec **)
		safe_calloc(new_max, sizeof(struct header_rec *));
	} else {
	    new_headers = (struct header_rec **)
		safe_array_realloc((char *) storage->headers,
				   new_max, sizeof(struct header_rec *));
	}
	storage->headers = new_headers;
	while (storage->max_headers < new_max)
	    storage->headers[storage->max_headers++] = NULL;
    }
}



struct header_rec *malloc_header_rec()
{
    struct header_rec *h = safe_zero_alloc(sizeof(*h));
		
    header_zero(h);

    return h;
}

void free_header_rec(h)
     struct header_rec **h;
{
    header_clear(*h);
    free(*h);
    *h = NULL;    
}

void alloc_header(storage,current_count)
     struct current_storage *storage;
     int current_count;
{
    if (storage->max_headers <= current_count ||
	current_count < 0)
	panic("MBX VIEW PANIC",__FILE__,__LINE__,"alloc_header",
	      "Bad current_count",0);

    if (storage->headers[current_count] == NULL) {
	storage->headers[current_count] = malloc_header_rec();
    }
}


static time_t now = 0;

void header_clear(h)      /* Free's fields */
     struct header_rec *h;
{
    if (0 == now) now = time(NULL);
    
    h->lines            = 0;
    if (h->size_lines_s)
	free_string(& h->size_lines_s);
    
    h->index_number_X   = 0; 
    h->status           = 0;
    h->status1          = 0;
    h->encrypted        = 0;
    h->exit_disposition = 0;
    h->status_chgd      = 0;
    h->content_length   = -1;
    h->offset           = -1;
    h->received_time    = now;
    h->env_from[0]      = '\0';
    if (h->from)
	free_addr_list(& h->from);
    if (h->to)
	free_addr_list(& h->to);
    if (h->cc)
	free_addr_list(& h->cc);
    if (h->reply_to)
	free_addr_list(& h->reply_to);
    if (h->message_id)
	free_message_id(& h->message_id);    
    if (h->in_reply_to)
	free_references(& h->in_reply_to);
    if (h->references)
	free_references(& h->references);
    h->time_zone[0]     = '\0';
    h->time_sent        = 0;
    if (h->time_menu_s)
	free_string(& (h->time_menu_s));
    h->time_menu_year   = 0;
    h->time_menu_type   = time_menu_null;
    h->tz_offset        = 0;
    if (h->subject)
	free_string(& h->subject);
    h->mailx_status[0]  = '\0';
    mime_t_clear (& h->mime_rec);
    free_rec_mbx_info(h);
    if (h->header_error)
	free_header_errors(& (h->header_error));

    free_partial_vector(h);

    if (h->list_info)
	free_list_info(& (h->list_info));
    
    h->pgp              = 0;
    h->binary           = 0;
    h->have_from        = 0;
    h->body_parsed      = 0;
    h->mime_parsed      = 0;
    h->time_menu_today  = 0;
    h->header_charset_set = 0;
    
    h->header_charset   = NULL;
    h->override_charset = NULL;
    h->default_body_charset = NULL;
}

void header_free(h)
     struct header_rec **h;
{
    header_clear(*h);
    free(*h);
    *h = NULL;
}

void header_zero(h)
     struct header_rec *h;
{
    if (0 == now) now = time(NULL);
    
    h->lines            = 0;
    h->size_lines_s     = NULL;
    
    h->index_number_X   = 0; 
    h->status           = 0;
    h->status1          = 0;
    h->encrypted        = 0;
    h->exit_disposition = 0;
    h->status_chgd      = 0;
    h->content_length   = -1;
    h->offset           = -1;
    h->received_time    = now;
    h->time_sent        = 0;
    h->env_from[0]      = '\0';
    h->from             = NULL;
    h->to               = NULL;
    h->cc               = NULL;
    h->reply_to         = NULL;
    h->message_id       = NULL;
    h->in_reply_to      = NULL;
    h->references       = NULL;
    h->time_zone[0]     = '\0';
    h->time_sent        = 0;
    h->time_menu_s      = NULL;
    h->time_menu_year   = 0;
    h->time_menu_type   = time_menu_null;
    h->tz_offset        = 0;
    h->subject          = NULL;
    h->mailx_status[0]  = '\0';
    mime_t_zero (&(h->mime_rec));

    h->header_error     = NULL;
    h->mbx_info         = NULL;
    h->partial_vector   = NULL;
    h->partial_len      = 0;
    h->list_info        = NULL;

    h->pgp              = 0;
    h->binary           = 0;
    h->have_from        = 0;
    h->body_parsed      = 0;
    h->mime_parsed      = 0;
    h->time_menu_today  = 0;
    h->header_charset_set = 0;
    
    h->header_charset   = NULL;
    h->override_charset = NULL;
    h->default_body_charset = NULL;
}


void header_parse_helper(current_header,parsed_headers)
     struct header_rec *current_header;
     header_list_ptr parsed_headers;
{
    enum message_hide_v mh = 
	give_dt_enumerate_as_int(&message_hide_hack);

    header_list_ptr tmphdr;

    DPRINT(Debug,13,(&Debug,
		     "header_parse_helper: Filling hdr index #%d\n",
		     current_header->index_number_X));
		     
    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Sensitivity"))) {
	char header_buffer[80];	
	const char * body_value;
	
	/* header_trim_whitespace_helper return either original body or pointer to buffer, 
	   may return NULL on overflow; returns also return NULL if body == NULL
	*/
	
	if ((body_value = header_trim_whitespace_helper(tmphdr->body,
							header_buffer,
							sizeof header_buffer))) {
	    if (0 == strcmp(body_value,"2"))
		current_header->status |= PRIVATE_MAIL;
	    else if (0 == strcmp(body_value,"3"))
		current_header->status |= CONFIDENTIAL;
	}
    }
    
    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Importance"))) {
	char header_buffer[80];	
	const char * body_value;
	
	/* header_trim_whitespace_helper return either original body or pointer to buffer, 
	   may return NULL on overflow; returns also return NULL if body == NULL
	*/
	
	if ((body_value = header_trim_whitespace_helper(tmphdr->body,
							header_buffer,
							sizeof header_buffer))) {
	   	
	    if (0 == strcmp(body_value,"2"))
		current_header->status |= URGENT;
	}
    }
    
    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Priority"))) {
	if (0 != istrcmp(tmphdr->body,"normal") &&
	    0 != istrcmp(tmphdr->body,"non-urgent"))
	    current_header->status |= URGENT;
    }

    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Action"))) {
	current_header->status |= ACTION;

	
    }

    mime_parse_helper(current_header,parsed_headers);

    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Status")) &&
	tmphdr->body) {
	mailbox_2_status(tmphdr->body,current_header);
    }
    
    if (NULL != (tmphdr = locate_header_by_name(parsed_headers,
						"Subject")) &&
	tmphdr->body
	) {
	char * Subject = safe_strdup(tmphdr->body);
	
	if (current_header->subject)
	    free_string(&(current_header->subject));
	
	remove_possible_trailing_spaces(Subject);

	if (use_ct_cs_for_subj_hack &&
	    (! current_header->header_charset_set) &&
	    check_8bit_str(Subject)) {

	    /* Process 8-bit subject with using charset parameter from
	       header field Content-Type
	    */

	    header_list_ptr ct = locate_header_by_name(parsed_headers,
						       "Content-Type");
	    char * c;
	    
	    if (ct && ct->body &&
		NULL != (c = strchr (ct->body, ';'))) {
		
		char value [20];

		c++;
		
		if (mime_get_param("charset",value,c,
				   sizeof value)) {
		    
		    charset_t X = MIME_name_to_charset(value,0);
		    if (X) {
			const char * MIME_name UNUSED_VAROK = 
			    get_charset_MIME_name(X);
			
			DPRINT(Debug,13,(&Debug,
					 "header_parse_helper: [use-content-type-charset-for-8bit-subject-hack] Using charset %s for Subject\n",
					 MIME_name ? MIME_name : value));
			
			current_header->subject = 
			    hdr_to_string(HDR_TEXT,
					  Subject,
					  X,
					  !(current_header -> status &
					    NOHDRENCODING) &&
					  is_rfc1522(Subject)); 
		    } else {
			DPRINT(Debug,13,(&Debug,
					 "header_parse_helper: [use-content-type-charset-for-8bit-subject-hack] charset %s not found\n",
					 value));
		    }
		    
		} else {
		    DPRINT(Debug,13,(&Debug,
				     "header_parse_helper: [use-content-type-charset-for-8bit-subject-hack] Not found charset from content-type: %s\n",c));
		}
	    } else {
		DPRINT(Debug,13,(&Debug,
				 "header_parse_helper: [use-content-type-charset-for-8bit-subject-hack] have 8-bit subject\n"));
	    }
	}

	if (! current_header->subject) {

	    const char * MIME_name UNUSED_VAROK = 
		get_charset_MIME_name(current_header->header_charset);

	    if (MIME_name) {
		DPRINT(Debug,13,(&Debug,
				 "header_parse_helper: Using header charset %s %s for Subject\n",
				 MIME_name,
				 current_header->header_charset_set ? "(set)" : "(default)"
				 ));
	    }
	    	    
	    current_header->subject = 
		hdr_to_string(HDR_TEXT,
			      Subject,
			      current_header->header_charset,
			      !(current_header -> status &
				NOHDRENCODING) &&
			      is_rfc1522(Subject));		
	}
	
	/* This does not work correctly with unknown character 
	   sets... */
	if (current_header->subject)
	    remove_control(current_header->subject);
	
	free(Subject);
    } else if (!current_header->subject)
	current_header->subject = new_string(display_charset);
    
    
    if (current_header->from)
	free_addr_list(& current_header->from);

    for (tmphdr = locate_header_by_name(parsed_headers,
					"From");
	 tmphdr;
	 tmphdr = tmphdr -> next_this_header) {
	
	struct addr_list * addrs = 
	    parse_header_address("From",tmphdr->body, 
				 !(current_header -> status & 
				   NOHDRENCODING) &&
				 is_rfc1522(tmphdr->body),
				 current_header->header_charset,
				 & (current_header-> header_error));
	
	if (addrs) {	    

	    if (current_header->from) {
		append_addr_list(current_header->from, addrs);
		free_addr_list(&addrs);
	    
	    } else
		current_header->from = addrs;

	}	       
    }

    if (current_header->list_info)
	free_list_info(& (current_header->list_info));
    current_header->list_info = 
	parse_list_headers(parsed_headers,
			   !(current_header -> status & NOHDRENCODING),
			   current_header-> header_charset,
			   & (current_header-> header_error) );

    if (current_header->to)
	free_addr_list(& current_header->to);

    for (tmphdr = locate_header_by_name(parsed_headers,
					"To");
	 tmphdr;
	 tmphdr = tmphdr -> next_this_header) {

	if (tmphdr->body) {
	    struct addr_list * addrs = 
		parse_header_address("To",
				     tmphdr->body,
				     !(current_header -> status & 
				       NOHDRENCODING) &&
				     is_rfc1522(tmphdr->body),
				     current_header->header_charset,
				     & (current_header-> header_error));
	    
	    if (addrs) {
		
		if (current_header->to) {
		    append_addr_list(current_header->to, addrs);
		    free_addr_list(& addrs);
		} else
		    current_header->to = addrs;
	    }
	}
    }

    if (current_header->cc)
	free_addr_list(& current_header->cc);

    for (tmphdr = locate_header_by_name(parsed_headers,
					"Cc");
	 tmphdr;
	 tmphdr = tmphdr -> next_this_header) {

	if (tmphdr->body) {
	    struct addr_list * addrs = 
		parse_header_address("Cc",tmphdr->body,
				     !(current_header -> status & 
				       NOHDRENCODING) &&
				     is_rfc1522(tmphdr->body),
				     current_header->header_charset,
				     & (current_header-> header_error));
	    
	    if (addrs) {
		if (current_header->cc) {
		    append_addr_list(current_header->cc, addrs);
		    free_addr_list(& addrs);
		} else 
		    current_header->cc = addrs;
	    }
	}
    }

    if (current_header->reply_to)
	free_addr_list(& current_header->reply_to);

    for (tmphdr = locate_header_by_name(parsed_headers,
					"Reply-To");
	 tmphdr;
	 tmphdr = tmphdr -> next_this_header) {

	if (tmphdr->body) {
	    struct addr_list * addrs = 
		parse_header_address("Reply-To",tmphdr->body,
				     !(current_header -> status & 
				       NOHDRENCODING) &&
				     is_rfc1522(tmphdr->body),
				     current_header->header_charset,
				     & (current_header-> header_error));
	    
	    if (addrs) {
		if (current_header->reply_to) {
		    append_addr_list(current_header->reply_to, addrs);
		    free_addr_list(& addrs);
		} else 
		    current_header->reply_to = addrs;
	    }
	}
    }


    /* message_hide_hack values:   0 == none                          */
                                /* 1 = FOLDER INTERNAL DATA           */

    switch (mh) {
	header_list_ptr tmphdr2;

    case message_hide_FID:
	tmphdr  = locate_header_by_name(parsed_headers, "Subject");
	tmphdr2 = locate_header_by_name(parsed_headers, "X-IMAP");

	if (tmphdr && tmphdr2 &&
	    tmphdr->body &&
	    NULL != strstr(tmphdr->body,
			   "DON'T DELETE THIS MESSAGE -- FOLDER INTERNAL DATA")) {
	    current_header->exit_disposition = HIDE;
	    DPRINT(Debug,10,(&Debug, "message_hide_hack=%d -- hiding message: %s\n",
			     mh,tmphdr->body));
	}
	break;

    case message_hide_none:
    case NUM_message_hide_hack:
	/* Not used */
	break;
    }
}			      

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
