case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	ln ../../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting src/messages/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.11 2020/05/21 02:58:29 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
CP		=	$cp
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
SHELL		=	/bin/sh

OBJ		=	messages.o header_alloc.o storage.o digest.o \
 partial.o canceled_mail.o duplicate.o status.o status_common.o \
 thread.o thread_messages.o mailfile.o

all:			Makefile libmessages.a

install_s:		Makefile libmessages.a

uninstall_s:		

clean:
	$(RM) $(OBJ) libmessages.a

Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

libmessages.a:		$(OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

#	Dependencies of header files upon other header files they include
.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_messages.h \
 $(IHDR)/me.h $(IHDR)/misclib.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h: ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_messages.h:		$(IHDR)/elm_defs.h $(IHDR)/me.h \
 $(INCLDIR)/mailerlib.h  $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/mboxlib.h $(INCLDIR)/schedule_time.h 
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(IHDR)/misclib.h $(INCLDIR)/addrlib.h \
  $(INCLDIR)/aliaslib.h $(INCLDIR)/mime.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

#	Dependencies of C object files

messages.o:	     def_messages.h 
header_alloc.o:	     def_messages.h 
canceled_mail.o:     def_messages.h $(INCLDIR)/s_elm.h $(INCLDIR)/s_me.h
storage.o:           def_messages.h $(INCLDIR)/s_elm.h
digest.o:            def_messages.h $(INCLDIR)/s_elm.h
partial.o:	     def_messages.h $(INCLDIR)/s_me.h
duplicate.o:	     def_messages.h $(INCLDIR)/s_me.h
status.o:	     def_messages.h 
status_common.o:     def_messages.h $(INCLDIR)/s_me.h
thread.o:	     def_messages.h 
thread_messages.o:   def_messages.h $(INCLDIR)/s_me.h
mailfile.o:	     def_messages.h $(INCLDIR)/s_me.h
!NO!SUBS!
