static char rcsid[] = "@(#)$Id: alias_screen.c,v 2.8 2018/06/28 07:37:39 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Inludes code from Elm 2.4 src/screen.c which have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "def_mcommon.h"

DEBUG_VAR(Debug,__FILE__,"menu");

static void print_alias_line P_((struct aliasview_record  *entry,
				 int message_number, int selected,
				 struct menu_context  *page,
				 int index_width));

void mc_screen_print_alias_line(u,idx, page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{
    struct AliasView *aview = u->alias.aw;
    
    /* from function show_headers() */
    
    int current = get_alias_current(aview);
    struct  aliasview_record  * a = give_alias(aview,idx);
    
    if (a) {
	int is_current = (idx == current-1);
	int index_width = 3;
	if (list)
	    index_width = mp_lookup_integer(list,elm_mp_index_width);
	
	DPRINT(Debug,14,(&Debug," ... mc_screen_print_alias_line idx %d index_width %d\n",
			 idx,index_width));
	
	print_alias_line(a, idx+1,is_current,page,
			index_width);
    } else {
	/* SHould there be print dummy line? */
    }
}

void mc_screen_print_alias_sepline(u,idx,page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{

}


int mc_screen_setup_alias_init(u,page,list)
     union mcommon_union * u;
     struct menu_context * page;
     struct menu_param   * list;
{
    int r = 0;
    
    if (list) {
	int index_width = 3;
	mp_list_set_integer(list,elm_mp_index_width,index_width);
	
	DPRINT(Debug,14,(&Debug,
			 "mc_screen_setup_alias_init:  index_width %d\n",
			 index_width));
	r = 1;
    }

    DPRINT(Debug,14,(&Debug,
		     "mc_screen_setup_alias_init=%d\n",r));
    return r;
}

void mc_screen_setup_alias_line(u,idx,page,list)
     union mcommon_union * u;
     int                   idx;
     struct menu_context * page;
     struct menu_param   * list;
{    
    if (list) {
	int index_width = mp_lookup_integer(list,elm_mp_index_width);
	
	/* Printed index is idx+1 */
	
	if (idx >= 9999 &&  index_width < 5) {
	    index_width = 5;
	    mp_list_set_integer(list,elm_mp_index_width,index_width);
	    
	    DPRINT(Debug,14,(&Debug," ... mc_screen_setup_alias_line idx %d index_width %d\n",
			     idx,index_width));
	    
	} else if (idx >= 999 && index_width < 4) {
	    index_width = 4;
	    mp_list_set_integer(list,elm_mp_index_width,index_width);
	    
	    DPRINT(Debug,14,(&Debug," ... mc_screen_setup_alias_line idx %d index_width %d\n",
			     idx,index_width));
	}
    }
}

static void print_alias_line(entry,message_number,selected,page,index_width)
     struct  aliasview_record  *entry;
     int message_number; 
     int selected;
     struct menu_context  *page;
     int index_width;
{
    struct string * buffer = build_alias_line(entry,message_number,selected,
					      page,index_width);
    
    if (selected && has_highlighting && ! arrow_cursor) {
	menu_StartXX(page,pg_STANDOUT);
	menu_Write_to_screen(page,FRM("%S\n\r"), buffer);	/* avoid '%' probs */
	menu_EndXX(page,pg_STANDOUT);
    } else
	menu_Write_to_screen(page,FRM("%S\n\r"), buffer);	/* avoid '%' probs */
    
    free_string(&buffer);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
