static char rcsid[] = "@(#)$Id: alias_pattern.c,v 2.8 2018/08/12 08:42:17 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 * Inludes code from Elm 2.4 src/pattern.c which have following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 ****************************************************************************/

#include "def_mcommon.h"

DEBUG_VAR(Debug,__FILE__,"menu");

static int name_matches P_((struct aliasview_record  * a, struct string *pat));
static int comment_matches P_((struct aliasview_record  * a, struct string *pat));
static int address_matches P_((struct aliasview_record  * a, struct string *pat,
			       struct AliasView *aview));


int mc_matches_alias(u,idx, meta_pattern)
     union mcommon_union *u;
     int idx;
     struct string * meta_pattern;
{
    struct AliasView *aview = u->alias.aw;
    struct aliasview_record  *a = give_alias(aview,idx);
    int r = 0;
    
    if (a) {
	r = name_matches(a, meta_pattern) || 
	    alias_matches(a, meta_pattern); 
    }

    return r;
}

static int name_matches(a, pattern)
     struct aliasview_record  * a;
     struct string * pattern;
{
    /** Returns true iff the pattern occurs in it's entirety
	in the name of the indicated alias 
	
    **/
    
    int r = 0;
    
    if (a) {
	const struct address_alias * alias = aliasview_address_alias(a);
	const struct addr_list * list_addr = NULL;
       
	/* NOTE: alias_matches() is not supposed to match
                 alias comment (and not address part)

	   alias comment is matched in comment_matches()	 

	   name == first name, last name or phrase
	*/

	{   /* 1) Person alias */
	    
	    const struct string *firstn = NULL;
	    const struct string *lastn  = NULL;
	    const struct address *address = NULL;
	    
	    if (address_alias_get_person(alias,&firstn,&lastn,&address)) {
		
		if (firstn && find_pattern_from_string(firstn,pattern,1 /* ignore case */))
		    r++;

		if (lastn && find_pattern_from_string(lastn,pattern,1 /* ignore case */))
		    r++;
	    }
	}


	/*  2) Address list */

	list_addr = address_alias_get_list(alias);
	    
	if (list_addr && list_group_matches(list_addr,pattern))
	    r++;


	{  /* 3) Group */
	    
	    const struct string *phrase        = NULL;
	    const struct alias_vector *vector  = NULL;
	    
	    if (address_alias_get_group(alias,&phrase,&vector)) {
		
		if (phrase && find_pattern_from_string(phrase,pattern,1 /* ignore case */))
		    r++;
		
	    }	    	    
	}

    }

    return r;
}

int alias_matches(a, pattern)
     struct aliasview_record  * a;
     struct string * pattern;
{
    /** Returns true iff the pattern occurs in it's entirety
	in the key of the indicated alias **/
    

    int r = 0;

    if (a) {
      
	const struct string *s = aliasview_key(a);
	
	if (find_pattern_from_string(s,pattern,1))
	    r++;
    }

    return r;
}



static int comment_matches(a, pattern)
     struct aliasview_record  * a;
     struct string * pattern;
{
    /** Returns true iff the pattern occurs in it's entirety
	in the comment field of the indicated alias **/

    int r = 0;
    
    if (a) {

	const struct address_alias * alias = aliasview_address_alias(a);

	const struct string * comment =  address_alias_get_comment(alias);
	
	if (comment && find_pattern_from_string(comment,pattern,1))
	    r++;
	
    }

    return r;

}

static int address_matches(a,pattern, aview)
     struct aliasview_record  * a;
     struct string * pattern;
     struct AliasView *aview;
{
    int res = 0;
        
    /** Returns true iff the pattern occurs in it's entirety
	in the fully expanded address of the indicated alias **/
    
    if (a) {
	
	const struct string * alias = aliasview_key(a);

	struct addr_list *result = 
	    get_alias_address_expanded(alias,NULL,aview,0,
				       NULL);


	if (result) {

	    if (list_addr_matches(result,pattern))
		res = 1;
		
	    free_addr_list(&result);	
	}
    }

    return(res);
}

enum pattern_result mc_match_in_text_alias(u,meta_pattern, page, LOC)
     union mcommon_union *u;
     struct string * meta_pattern;
     struct menu_context  *page;
     struct screen_parts *LOC; 
{   
    struct AliasView *aview = u->alias.aw;

    /* From pattern_match() */

    int current = get_alias_current(aview);
    int ac = get_alias_count(aview);
    int selected = get_alias_selected(aview);
    int i;
    int ret = 0;

    for (i = current; i < ac; i++) {
	struct aliasview_record  * a = give_alias(aview,i);
	
	if (a && (
		  name_matches(a, meta_pattern) || 
		  alias_matches(a, meta_pattern) ||
		  comment_matches(a, meta_pattern) ||
		  address_matches(a, meta_pattern, aview)
		  )) {
	    
	    if (!selected || 
		(selected && aliasview_have_status_mask(a,VISIBLE))) {
		
		current = ++i;
		set_alias_current(aview,current);
		
		ret =  pattern_found;
		goto out;
	    }
	}
    }
 out:

    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */

