case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	ln ../../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH		= "
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH		=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting src/menu_common/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.7 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CP		=	$cp
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
SHELL		=	/bin/sh

OBJ		=	mcommon.o alias.o mailbox.o alias_limit.o \
 message_limit.o alias_pattern.o message_pattern.o alias_screen.o \
 message_screen.o alias_item.o mailbox_item.o

all:			Makefile libmcommon.a

install_s:		Makefile libmcommon.a

uninstall_s:		

clean:
	$(RM) $(OBJ) libmcommon.a

Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

libmcommon.a:		$(OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

#	Dependencies of header files upon other header files they include
.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_mcommon.h \
 $(IHDR)/me.h $(IHDR)/misclib.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h:   ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_mcommon.h:		$(IHDR)/elm_defs.h $(IHDR)/me.h \
 $(INCLDIR)/mboxlib.h 
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(IHDR)/misclib.h $(INCLDIR)/addrlib.h \
 $(INCLDIR)/aliaslib.h $(INCLDIR)/mime.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
mcommon.o:	     def_mcommon.h     
alias.o:	     def_mcommon.h $(INCLDIR)/s_aliases.h    
mailbox.o:	     def_mcommon.h   $(INCLDIR)/s_elm.h      
alias_limit.o:	     def_mcommon.h $(INCLDIR)/s_aliases.h $(INCLDIR)/s_elm.h
message_limit.o:     def_mcommon.h $(INCLDIR)/s_elm.h  
alias_pattern.o:     def_mcommon.h 
message_pattern.o:   def_mcommon.h $(INCLDIR)/s_elm.h
alias_screen.o:     def_mcommon.h
message_screen.o:   def_mcommon.h $(INCLDIR)/s_elm.h    
alias_item.o:       def_mcommon.h $(INCLDIR)/s_aliases.h $(INCLDIR)/s_elm.h    
mailbox_item.o:     def_mcommon.h $(INCLDIR)/s_elm.h    
!NO!SUBS!

