static char rcsid[] = "@(#)$Id: menu2.c,v 2.3 2014/07/14 15:07:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.3 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 * This code originally written by Michael Elkins <elkins@aero.org>.
 *****************************************************************************/

#include "def_elm.h"
#include "menu2.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ui");

#define BOL 1
#define STR 2
#define INT 3

static int do_item P_((struct menu_item *it, struct menu_context *page));
static int do_item (it, page)
     struct menu_item *it;
     struct menu_context *page;
{
    short len;
    char buf[STRING];
    int ch;
    
    menu_ClearLine(page,
		   it->offset);
    menu_Write_to_screen(page,
			 FRM("%s"),it->option);
    len = strlen (it->option) + 1;
    if (it->type == STR)
	return 
	    optionally_enter (it->d.c, it->offset, len, 
			      OE_APPEND_CURRENT|OE_REDRAW_MARK,
			      it->size,page);
    else if (it->type == BOL) {
	int old_val = *(it->d.i);
	for (;;) {
	    menu_MoveCursor(page,it->offset, len);
	    menu_CleartoEOLN(page);
	    if (*(it->d.i) == TRUE)
		menu_Write_to_screen(page,
				     CATGETS(elm_msg_cat, ElmSet, 
					     ElmMenu2True,
					     "TRUE"));
	    else if (*(it->d.i) == FALSE)
		menu_Write_to_screen(page,
				     CATGETS(elm_msg_cat, ElmSet, 
					     ElmMenu2False,
					     "FALSE"));
	    ch = menu_ReadCh(page,OE_REDRAW_MARK|READCH_sig_char);
	    if (ch == EOF) 
		return -1;
	    if (ch == REDRAW_MARK)
		return REDRAW_MARK;

	    if (ch == TERMCH_interrupt_char) {
		*(it->d.i) = old_val;
		return 0;
	    }

	    if (ch == '\n')
		return 0;
	    else if (ch == ' ')
		*(it->d.i) = *(it->d.i) ? FALSE : TRUE;
	}
    }
    else if (it->type == INT) {
	int code;
	elm_sfprintf (buf,sizeof buf,
		      FRM("%d"), *(it->d.i));
	code = optionally_enter (buf, it->offset, len, 
				 OE_APPEND_CURRENT|OE_REDRAW_MARK,
				 sizeof buf, page);
	if (code != 0)
	    return code;
	*(it->d.i) = atoi (buf);
    }
    return 0;
}

int generic_menu (items, max, title, prompt)
     struct menu_item items[];
     int max;
     char *prompt, *title;
{
    int ret = 1;
     short i = 0;
  char buf[STRING], buf2[STRING];
  int ch;
  short update = TRUE;
  int precmd = 0;

  struct menu_context *page = new_menu_context();

  menu_ClearScreen (page);
  for (;;) {
      int LINES, COLUMNS;

      menu_set_default(page);

  resize_mark:
      menu_get_sizes(page,&LINES, &COLUMNS);

      if (menu_resized(page)) {
	  
	  menu_get_sizes(page,&LINES, &COLUMNS);
	  update = 1;
	  
      } else if (menu_need_redraw(page))
	  update = 1;

	if (update) {
	
	    Centerline (1, title,page);

      for (i = 0 ; i < max ; i++) {
	strfcpy(buf,items[i].option, sizeof buf);
	strfcat(buf," ",sizeof buf);
	if (items[i].type == BOL) {
	  if (*items[i].d.i == TRUE)
	    strfcat (buf, "TRUE", sizeof buf);
	  else
	    strfcat (buf, "FALSE", sizeof buf);
	}
	else if (items[i].type == STR)
	  strfcat (buf, items[i].d.c, sizeof buf);
	else if (items[i].type == INT) {
	  elm_sfprintf (buf2, sizeof buf2,
			FRM("%d"), 
			*items[i].d.i);
	  strfcat (buf, buf2, sizeof buf);
	}
	ClearLine(items[i].offset);
	PutLine0 (items[i].offset, 0, buf);
      }
      update = FALSE;
    }

	menu_ClearLine(page,LINES-3);
	menu_PutLine0(page,LINES-3, 0, prompt);
	if (precmd) {
	    ch = precmd;
	    precmd = 0;
	} else
	    ch = menu_ReadCh(page, REDRAW_MARK|READCH_resize|READCH_sig_char);

    if (ch == TERMCH_interrupt_char) {
        ret = 0;
	goto OUT;
    }

    if (EOF == ch) {
      ret =  0;
      goto OUT;
    }
    switch (ch) {
    case RESIZE_MARK:
	DPRINT(Debug,4,  (&Debug, "    .... resizing\n"));
	goto resize_mark;

    case '\n':
      ret = 1;
      goto OUT;
    case REDRAW_MARK:
      update = TRUE;
      break;
    default:
      for (i = 0; i < max ; i++) {
	if (ch == items[i].key) {
	    int code = do_item (&items[i], page);
	  if (REDRAW_MARK == code)
	    precmd = ch;
	  if (-1 == code) {
	      goto OUT;
	  }
	  update = TRUE;
	  break;
	}
      }
      if (i == max && isascii(ch)) {
	for (i = 0; i < max ; i++) {
	  if (isascii (items[i].key) && isascii(ch) && 
	      tolower(ch) == tolower(items[i].key)) {
	      int code = do_item (&items[i], page);
	    if (REDRAW_MARK == code)
	      precmd = ch;
	    if (-1 == code) {
		goto OUT;
	    }
	    update = TRUE;
	    break;
	  }
	}
      }
    }
  }
 
 OUT:
  erase_menu_context(&page);
  return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
