static char rcsid[] = "@(#)$Id: in_utils.c,v 2.13 2022/07/14 14:16:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/in_utils.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/in_utils.c.
 *  That code was following copyright:
 *
 *  The Elm Mail System
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 *                      Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Mindless I/O routines for ELM 
	
**/

#include "def_elm.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ui");

static unsigned char *s2us P_((char *str));
static unsigned char *s2us(str) 
     char *str;
{
    return (unsigned char *)str;
}
static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}

#include <errno.h>
#ifndef ANSI_C
extern int errno;		/* system error number */
#endif       

extern int tabspacing;

int prompt_letter(
#if ANSI_C
		  int line, char *letters, int def,
		  int flags, 
		  struct menu_context  *page,
		  const char * format, const char *msg, ...
#else
		  line, letters, def, flags, page, format, msg, va_alist
#endif
		  )
#if !ANSI_C
     int line; 
     char *letters;
     int def;
     int flags; 
     struct menu_context  *page;
     const char * format; 
     const char *msg;
     va_dcl     
#endif
{
    struct string *question = NULL;

    int ch;
    int center = flags & PROMPT_center;
    int yesno  = flags & PROMPT_yesno;
    int mark   = flags & PROMPT_redraw_mark;
    int ctrlL  = flags & PROMPT_ctrlL;
    int cancel = flags & PROMPT_cancel;
    int cols = 0;


    va_list vl;
    
    DPRINT(Debug,6, (&Debug,
		     "prompt_letter: center=%d yesno=%d mark=%d ctrlL=%d\n",
		     center,yesno,mark,ctrlL));

    Va_start(vl, msg);           /* defined in hdrs/elm_defs.h  */
    question = elm_smessage(0,format,msg,vl);
    va_end(vl);

    do {
	int LINES, COLUMNS;
	int l;
	char *x;

	menu_get_sizes(page,&LINES, &COLUMNS);

	/* FIXME:   Not correct */
	l = string_len(question);
	cols = COLUMNS - ( l + 5 );	/* 5 for "Yes." + 1 */
	if (cols < 0) {
	    cols = 0;
	}

	DPRINT(Debug,6, (&Debug,"prompt_letter: pos line=%d column=%d\n",
			 line, (center || (cols < 2)) ? 0 : cols-2));

	menu_MoveCursor(page,line, (center || (cols < 2)) ? 0 : cols-2);
	menu_CleartoEOLN(page);

	menu_PutLineX(page,line, center ? cols/2 : cols,
		      FRM("%S%c%c"), question, def, BACKSPACE);
	FlushBuffer();

	ch = menu_ReadCh(page, REDRAW_MARK
			 | ( cancel ? READCH_sig_char : 0 ));
	if (ch == REDRAW_MARK) {
	    if (mark)
		break;
	    continue;
	}

	if (ctrlL && ch == ('L'&31)) {
	    break;
	}

	if (cancel && ch == TERMCH_interrupt_char)
	    break;

	if (ch == EOF)
	    break;
	
	/* Look first letters without lowercasing */
	for (x = letters; *x; x++) {

	    if (ch == *x) {
		menu_Writechar(page,ch);
		goto out;
	    }
	}

	if(ch == '\n' || ch == '\r')
	    ch = def;
	else {
#ifdef ASCII_CTYPE
	    if (isascii(ch))
#endif
		ch = tolower(ch);
	}

	for (x = letters; *x; x++) {
	    
	    if (ch == *x) {
		menu_Writechar(page,ch);
		goto out;
	    }
	}

	if(ch == *def_ans_yes && yesno) {
	    menu_Write_to_screen(page,CATGETS(elm_msg_cat, ElmSet, 
					      ElmYesWord, "Yes."));
	    break;
	} else if (ch == *def_ans_no && yesno) {
	    menu_Write_to_screen(page,CATGETS(elm_msg_cat, ElmSet, 
					      ElmNoWord, "No."));
	    break;
	}

	menu_Writechar(page,'?');
	FlushBuffer();

	if (POLL_method)
	    wait_for_timeout(1);
	else
	    sleep(1);
	
    } while (EOF != ch);


 out:
    FlushBuffer();
    free_string(&question);

    if (EOF != ch && REDRAW_MARK != ch && ('L'&31) != ch &&
	TERMCH_interrupt_char != ch) {
	if (sleepmsg > 0) {

	    if (POLL_method)
		wait_for_timeout((sleepmsg + 1) / 2);
	    else
		sleep((sleepmsg + 1) / 2);

	}
	menu_MoveCursor(page,line, (center || (cols < 2)) ? 0 : cols-2);
	menu_CleartoEOLN(page);       
    }
    
    return ch;
}

int want_to(question, dflt, where, clear_and_center, page)
     char *question;
     int dflt;
     int where, clear_and_center;
     struct menu_context  *page;
{
	/** Ask 'question' on 'where' left enough to just leave room for an
	    answer, returning the answer in lower case.
	    Echo answer as full "Yes" or "No".  'dflt' is the 
	    default answer if <return> is pressed. 

	**/
	int ch, cols;
	int LINES, COLUMNS;
	int redraw1 = 0;

redraw:
	menu_get_sizes(page,&LINES, &COLUMNS);
	
	cols = COLUMNS - (strlen(question) + 5 );	/* 5 for "Yes." + 1 */
	if (cols < 0) {
	    cols = 0;
	}

	DPRINT(Debug,6, (&Debug,"want_to: pos line=%d column=%d\n",
		   where, (clear_and_center || (cols < 2)) ? 0 : cols-2));

	menu_MoveCursor(page,
			where, (clear_and_center || (cols < 2)) ? 0 : cols-2);
	menu_CleartoEOLN(page);

	menu_PutLineX(page,
		      where, clear_and_center ? cols/2 : cols,
		      FRM("%s%c%c"), question, dflt, BACKSPACE);
	FlushBuffer();

	ch = menu_ReadCh(page, REDRAW_MARK);
	if (ch == REDRAW_MARK) {
	    menu_ClearScreen(page);   /* Clear possible redraw mark */
	    
	    /* Call refresh routines of children */
	    menu_redraw_children(page);
	    
	    redraw1++;
	    goto redraw;
	}
	if (ch == EOF) {
	    leave(0,1); 
	}
	ch = tolower(ch);

	while (!( ch == *def_ans_yes || ch == *def_ans_no || ch == '\n' || ch == '\r')) {
	    ch = menu_ReadCh(page,REDRAW_MARK);
	    if (ch == REDRAW_MARK) {
		menu_ClearScreen(page);   /* Clear possible redraw mark */

		/* Call refresh routines of children */
		menu_redraw_children(page);

		redraw1++;
		goto redraw;
	    }
	    if (ch == EOF) {
		leave(0,1);  /* ????  global reference */
	    }
#ifdef ASCII_CTYPE
	    if (isascii(ch))
#endif
		ch = tolower(ch);
	}
	if(ch == '\n' || ch == '\r')
	  ch = dflt;

	if(ch == *def_ans_yes)
	    menu_Write_to_screen(page,
				 CATGETS(elm_msg_cat, ElmSet, ElmYesWord, 
					 "Yes."));
	else if (ch == *def_ans_no)
	    menu_Write_to_screen(page,
				 CATGETS(elm_msg_cat, ElmSet, ElmNoWord, 
					 "No."));
	else {
	    DPRINT(Debug,3,(&Debug,"want_to [%s]=%c\n",question,ch));
	    return(ch); /* Don't write anything, just return */
	}
	FlushBuffer();
	if (sleepmsg > 0) {

	    if (POLL_method)
		wait_for_timeout((sleepmsg + 1) / 2);
	    else
		sleep((sleepmsg + 1) / 2);

	}
	menu_MoveCursor(page,where, 
			(clear_and_center || (cols < 2)) ? 0 : cols-2);
	menu_CleartoEOLN(page);

	if (redraw1)
	    menu_trigger_redraw(page);

	DPRINT(Debug,3,(&Debug,"want_to [%s]=%c\n",question,ch));
	return(ch);
}

int read_number(ch, item, dfltval, page,prompt_area)
     int ch;
     const struct string *item;
     int dfltval;
     struct menu_context  *page;
     struct menu_context  *prompt_area;
{
    /** Read a number, where 'ch' is the leading digit! **/
	
    /* If redraw is used use
                menu_trigger_redraw(page)
    */

    struct string  * buff = new_string(display_charset);

    int  need_redraw = 0;
    int  num, status;
    int  bad, li,co, line;

    fill_ascii_to_string(buff,1,ch);
    menu_get_sizes(page,&li, &co);

redraw:
    /* FIXME --optionally_enter*  should use prompt_page */
    line = menu_GetAbsLine(prompt_area,0);

    status = optionally_enter2(page,
			       &buff, line, co-40,
			       OE_APPEND_CURRENT|OE_REDRAW_MARK|
			       OE_SIG_CHAR /* allow Ctrl-C */,
			       CATGETS(elm_msg_cat, ElmSet, 
				       ElmSetCurrentTo,
				       "Set current %S to :"), item);
	 
    if (status == -1)  /* Ctrl-C */
	return(dfltval);
    if (status == REDRAW_MARK) {
	menu_ClearScreen(page);   /* Reset possible redraw flag */

	/* Can not set menu_trigger_redraw here or causes
	   redraw loop ... */
	need_redraw = 1;
	goto redraw;
    }

    if (need_redraw)
	menu_trigger_redraw(page);

    if (0 == string_len(buff)) {
	free_string(&buff);
	return dfltval;
    }

    num = string_to_long(buff,&bad);

    free_string(&buff);

    if (bad >= 0)
	return dfltval;
    return(num);
}

struct in_utils_edit {
    int prompt_line;
    int prompt_col;
};
				   			
			    
static struct string **gb_optionally_enter P_((struct enter_info *I,
					       enum enter_mode em,
					       struct menu_context  *base_page));

static struct string **gb_optionally_enter(I,em, base_page)
     struct enter_info *I;
     enum enter_mode em;
     struct menu_context  *base_page;
{
    int passwd;
    int append_current;
    const char * s UNUSED_VAROK = NULL;

    if (ENTER_INFO_magic != I->magic)
        panic("INPUT PANIC",__FILE__,__LINE__,
              "gb_optionally_enter",
              "Bad magic number (enter_info)",0);

    DPRINT(Debug,10,(&Debug, "gb_optionally_enter: em=%d",
		     em));
    if ((s = enter_mode_debug_name(em))) {
	DPRINT(Debug,10,(&Debug, " %s",s));
    }
    DPRINT(Debug,10,(&Debug, "\n"));
					  
    passwd         = ison(I->flags,OE_PASSWD);
    append_current = ison(I->flags,OE_APPEND_CURRENT);
    
    switch(em) {
	int line,col;
	int line1,col1;
    case em_redraw_initial:
	if (!append_current) {
	    PutLineX(I->in_utils->prompt_line, I->in_utils->prompt_col, FRM("%S"), I->pvector[0]);
	    if(!passwd && I->pvector[1]) {
		GetXYLocation(&line, &col); /* Record position after prompt */
		
		Write_to_screen(FRM("%S"), I->pvector[1]);	
		CleartoEOLN();
		MoveCursor(line,col);
	    }
	    I->ch_count = 0;
	    break;
	}
	/* FALLTHRU */

    case em_redraw:
	GetXYLocation(&line1, &col1);
	PutLineX(I->in_utils->prompt_line, I->in_utils->prompt_col, FRM("%S"), I->pvector[0]);

	if(!passwd && I->pvector[1]) {
	    Write_to_screen(FRM("%S"), I->pvector[1]);	
	}
	CleartoEOLN();
	if (em_redraw == em) {
	    int end_line,end_col;
	    GetXYLocation(&line, &col);  /* Clear also next lines if cursor was there */
	    
	    end_line = line; end_col = col;
	    
	    
	    while (line < line1) {
		line++;
		ClearLine(line);
	    }

	    MoveCursor(end_line,end_col);
	}

	break;
    case em_enter:
	DPRINT(Debug,4,
	       (&Debug, "-- gb_optionally_enter(..,%d)=NULL\n",
		em));

	return NULL;

    default:
	break;
    }

    DPRINT(Debug,4,(&Debug, "-- gb_optionally_enter(..,%d)=non null\n",
		    em));


    return &(I->pvector[1]);
}


int optionally_enter2 P_((struct menu_context  *page,
			  struct string **buffer, 
			  int x, int y, int flags, 
			  const char * format, const char *msg, ...));

int optionally_enter2 (
#if ANSI_C
		       struct menu_context  *page,
		       struct string **buffer, 
		       int x, int y, int flags, 
		       const char * format, const char *msg, ...
#else
		       page, buffer, x, y, flags, format, msg, va_alist
#endif
		      )
#if !ANSI_C
     struct menu_context  *page;
     struct string **buffer;
     int x; 
     int y; 
     int flags; 
     const char * format; 
     const char *msg;
     va_dcl     
#endif
{
    
    /** This will display the string on the screen and allow the user to
	either accept it (by pressing RETURN) or alter it according to
	what the user types.   The various flags are:
	string    is the buffer to use (with optional initial value)
	x,y	   is the location we're at on the screen (-1,-1 means
	that we can't use this info and need to find out
	the current location)
	append_current  means that we have an initial string and that
	the cursor should be placed at the END of the line,
	not the beginning (the default).
	passwd	   accept non-printing characters and do not echo
	entered characters.
      
	If we hit an interrupt or EOF we'll return non-zero.
    **/
   
    int ret = 0;

    struct string *question = NULL;
    struct string *vector[2];
    struct in_utils_edit IU;
    struct enter_info INFO;

#if 0
    static int nested_redraw_mark = 0;
#endif

    va_list vl;

    zero_enter_info(&INFO);
    
    Va_start(vl, msg);           /* defined in hdrs/elm_defs.h */
    question = elm_smessage(0,format,msg,vl);
    va_end(vl);

    if(!(x >=0 && y >= 0))
	menu_GetXYLocation(page,&x, &y);

    DPRINT(Debug,10, (&Debug, "optionally_enter2: (x,y) = %d,%d (line,col)\n",
		      x,y));

    menu_MoveCursor(page,x,y);

#if 0    /* ????    where this is needed?? */    
    if (redraw && nested_redraw_mark) {
	nested_redraw_mark = 0;
	  
	DPRINT(Debug,4,
	       (&Debug,
		"optionally_enter2: nested_redraw_mark set returning REDRAW_MARK\n"));
	ret = REDRAW_MARK;
	goto out;
    }

    nested_redraw_mark = 1;
#endif

    /** now we have the screen as we want it and the cursor in the 
	right place, we can loop around on the input and return the
	string as soon as the user presses <RETURN>
    **/

    vector[0] = question;
    vector[1] = *buffer;
    
    INFO.in_utils    = &IU;
    INFO.pvector     = vector;
    IU.prompt_line          = x;
    IU.prompt_col          = y;
    
    INFO.give_buffer  = gb_optionally_enter;
    INFO.alter_buffer = default_alter_buffer;
    INFO.full_page    = default_full_page;
    INFO.prompt_hint  = default_prompt_hint;
    INFO.flags       = flags;
    INFO.ch_count    = 0;
    INFO.builtin     = NULL;
    INFO.browser     = NULL;
    INFO.address     = NULL;
    INFO.current_page = page;

    ret = enter_helper(&INFO, page,page);
    
    *buffer = vector[1];

#if 0
 out:
    nested_redraw_mark = 0;
#endif

    free_string(&question);

    DPRINT(Debug,4,(&Debug,  
		    "-- optionally_enter2=%d (%s%s*buffer=%p%s)\n",
		    ret,
		    ret == REDRAW_MARK ? "REDRAW_MARK, ": "",
		    ret == OE_ALT_SOLIDUS ? "OE_ALT_SOLIDUS, ": "",
		    *buffer,
		    *buffer ? "" : " = NULL"));	 

    return ret;
}

int optionally_enter(string, x, y, flags, size,page)
     char *string;
     int  x,y,flags; 
     int size;
     struct menu_context  *page;
{
    int ret;
    struct string * buffer = NULL;
    char *str = NULL;

    DPRINT(Debug,50,
	   (&Debug, 
	    "optionally_enter: flags=%d size=%d\n",
	    flags,size));

    buffer = new_string2(display_charset,s2us(string));
    
    ret = optionally_enter2(page, &buffer,x,y,flags,FRM(""));
    
    if (buffer) {
	/* We line was totally erased, it does not necessary be
	   display_charset (but instead keyboard charset)
	*/
	struct string * s1 = convert_string(display_charset,buffer,0);

	/* Includes only printable characters if not passwd,
	 * so we not need ask printable only characters
	 */
	str = us2s(stream_from_string(s1,0,NULL));	    
	free_string(&s1);
    }
    if (str) {
	strfcpy(string,str,size);	
	free(str); str = NULL;
    } else
	string[0] = '\0';

    DPRINT(Debug,50,(&Debug,  
		     "optionally_enter=%d string=%s\n",
		     ret,string));


    if (buffer)
	free_string(&buffer);

    return(ret);
}

int pattern_enter(string, alt_string, x, y, alternate_prompt, 
		  prompt,  redraw, page)
     struct string **string, **alt_string;
     struct string *alternate_prompt, *prompt;
     int  x,y;
     int *redraw;
     struct menu_context  *page;
{
    /** This function is functionally similar to the routine
	optionally-enter, but if the first character pressed
	is a '/' character, then the alternate prompt and string
	are used rather than the normal one.  This routine 
	returns 1 if alternate was used, 0 if not

	returns -1 on failure (EOF*)
    **/

    struct string *vector[2];
    struct in_utils_edit IU;
    struct enter_info INFO;
    int mode = 0;
    int ret;

    zero_enter_info(&INFO);
    
    if(!(x >=0 && y >= 0))
	menu_GetXYLocation(page, &x, &y);

    vector[0] = prompt;
    vector[1] = *string;

    INFO.in_utils     = &IU;
    INFO.pvector      = vector;
    IU.prompt_line    = x;
    IU.prompt_col     = y;
    INFO.give_buffer  = gb_optionally_enter;
    INFO.alter_buffer = default_alter_buffer;
    INFO.full_page    = default_full_page;
    INFO.prompt_hint  = default_prompt_hint;
    INFO.flags       = OE_ALT_SOLIDUS|OE_REDRAW_MARK;
    INFO.ch_count    = 0;   
    INFO.browser     = NULL;
    INFO.builtin     = NULL;
    INFO.address     = NULL;
    INFO.current_page = page;

 again:
    switch(mode) {
    case 0:
	vector[0] = prompt;
	vector[1] = *string;
	break;
    case 1:
	vector[0] = alternate_prompt;
	vector[1] = *alt_string;
	break;
    }

    MoveCursor(x,y);
    CleartoEOLN();

    ret = enter_helper(&INFO, page,page);

    switch(mode) {
    case 0:
	*string  = vector[1];
	break;
    case 1:
	*alt_string = vector[1]; 
	break;
    }


    switch(ret) {
    case REDRAW_MARK:
	*redraw = REDRAW_MARK;
	INFO.flags  |= OE_APPEND_CURRENT;

	goto again;
    case 0:   /* OK */       
	return mode;
    case OE_ALT_SOLIDUS:
	mode = !mode;    /* TOGGLE mode */
	goto again;
    case -1:    /* Interrupt */
	
	if (*string)
	    free_string(string);
	return 0;
    }

    return -1;
}

int GetPrompt(page, wait_time)
     struct menu_context *page;
     int wait_time;
{    
	/** This routine does a read/timeout for a single character.
	    The way that this was determined is that the routine to
	    read a character is called, then the "errno" is checked
	    against EINTR (interrupted call).  If they match, this
	    returns NO_OP_COMMAND otherwise it returns the normal
	    command.  On many systems, the EINTR will never be returned
	    so we instead longjmp from the signal handler.
	**/

	int ch;

	if (wait_time > 0) {
	  alarm((unsigned) wait_time);
	}
	if (SETJMP(GetPromptBuf)) {
	    
	    InGetPrompt = 0;
	    ch = NO_OP_COMMAND;	  
	    alarm((unsigned) 0);

	    
	    DPRINT(Debug,9, (&Debug, "GetPrompt: Interrupted by jump\n"));

	    wait_got_jump();


#ifdef REMOTE_MBX
	    {
		struct cancel_data *cd	= NULL;

		setup_mbx_cancel_message(&cd,mbx_closing_con);
				
		DPRINT(Debug,9, (&Debug, "GetPrompt: Closing cached connections\n"));
		
		if (close_cached_connections(cd)) {
		    DPRINT(Debug,9, (&Debug,
				     "GetPrompt: Cached connections closed\n"));
		}

		if (is_canceled(cd)) {
		    DPRINT(Debug,9, (&Debug,
				     "GetPrompt: Cancel on close_cached_connections\n"));
		}
		
		free_cancel(&cd);
	    }
#endif
	}
	else {
	  errno = 0;
	  InGetPrompt = 1;
	  ch = menu_ReadCh(page, 0|READCH_CURSOR);
	  if (errno == EINTR)  ch = NO_OP_COMMAND;
#ifdef	EAGAIN
	  if (errno == EAGAIN) ch = NO_OP_COMMAND;
#endif
#ifdef	EWOULDBLOCK
	  if (errno == EWOULDBLOCK) ch = NO_OP_COMMAND;
#endif
	  InGetPrompt = 0;
	  alarm((unsigned) 0);
	}
	return(ch);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
