static char rcsid[] = "@(#)$Id: sendcmd.c,v 1.11 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.11 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");


/* increment refcount */
struct elm_commands *give_send_commands() 
{        

    static struct elm_commands  * send_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (send_commands) {
	inc_commands_refcount(send_commands);
	return send_commands;
    }
    
    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSendKeyTitle,"Send command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandSendDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&send_commands);


    /* TODO? center */
    add_commands_title(ret,pg_BOLD,CATGETS(elm_msg_cat, CommandSet,
					   CommandSendTitle1,
					   "            Commands available from the Mail Pre-Send Screen in Elm %s"),
		       VERSION);

    {
	int cmds[] = { '\n','\r',  0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandSendDefaultAction,
				       "Default action.\n"));
    }


    add_commands_help_single(ret,NULL,0,' ',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandSendPreviewMessage,
				     "Preview the message."));

    add_commands_help_single(ret,NULL,0,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));

    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendAttachments,
				     "Add attachments to message or view attachments."));

    {
	int cmds[] = { 'b','B',  0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandSendBcc,
				       "Edit Bcc header field of message."));
    }


    {
	int cmds[] = { 'c','C',  0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandSendCc,
				       "Edit Cc header field of message."));
    }


    add_commands_help_single(ret,NULL,0,'D',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendDsnSettings,
				     "View or set delivery notification settings of message."));
    
    
    add_commands_help_single(ret,NULL,0,ctrl('D'),
			     CATGETS(elm_msg_cat, CommandSet, CommandSendDsnToggle,
				     "Toggle delivery notification setting of message."));

    add_commands_help_single(ret,NULL,0,'e',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendEditMessage,
				     "Edit message text."));
    
    {
	int cmds[] = { 'f',*def_ans_no,  0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandSendForget,
				       "Forget the message."));
    }

    if (use_PGP)
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#if defined(REMOTE_MBX)
    else 
	add_commands_help_single(ret,NULL,0,ctrl('F'),
				 CATGETS(elm_msg_cat, CommandSet, CommandCommonForgetPassphrase,
					 "Forget PGP passphrase and close cached connections."));
#endif

    add_commands_help_single(ret,NULL,0,'H',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandSendPreviewMsgAllHdr,
				     "Preview the message with all headers (ignore weedout-without-title list)."));

    add_commands_help_single(ret,NULL,0,'h',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendHeaders,
				     "View or set header fields of message."));

    if (have_ISPELL)
	add_commands_help_single(ret,NULL,0,'i',
				 CATGETS(elm_msg_cat, CommandSet, CommandSendIspell,
					 "Pass message to ispell."));

    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

    if (use_PGP)
	add_commands_help_single(ret,NULL,0,'P',
				 CATGETS(elm_msg_cat, CommandSet, CommandSendPgp,
					 "Sign or encrypt message with PGP."));

    add_commands_help_single(ret,NULL,0,'p',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendCopy,
				     "Set copy file/folder target for message."));

    add_commands_help_single(ret,NULL,0,'R',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendReturnPath,
				     "Edit Return-Path of message."));


    {
	int cmds[] = { 's','S',  0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandSendSubject,
				       "Edit Subject of message."));
    }



    {
	int cmds[] = { 't','T',  0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandSendTo,
				       "Edit To header field of message."));
    }

    add_commands_help_single(ret,NULL,0,'V',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandSendGotoPreviewMenu,
				     "Go to preview menu."));

    add_commands_help_single(ret,NULL,0,'v',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandSendPreviewMimeSt,
				     "Preview MIME structure (attachments) in the message."));

    add_commands_help_single(ret,NULL,0,'w',
			     CATGETS(elm_msg_cat, CommandSet, CommandSendViewFolder,
				     "View current folder."));

    add_commands_help_single(ret,NULL,0,*def_ans_yes,
			     CATGETS(elm_msg_cat, CommandSet, CommandSendMessage,
				     "Send the message."));

    sort_commands(ret); /* *def_ans_yes can vary */
    

    DPRINT(Debug,30,(&Debug,
		     "give_send_commands=%p [pointer %p]\n",
		     ret,&send_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_preview_commands() 
{        

    static struct elm_commands  * preview_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (preview_commands) {
	inc_commands_refcount(preview_commands);
	return preview_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPreviewKeyTitle,"Preview command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandPreviewDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&preview_commands);

    add_commands_title(ret,pg_BOLD,CATGETS(elm_msg_cat, CommandSet,
					   CommandPreviewTitle1,
					   "            Commands available from the Mail Preview Screen in Elm %s"),
		       VERSION);

    {
	int cmds[] = { '\n','\r',  0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandSendDefaultAction,
				       "Default action.\n"));
    }

    add_commands_help_single(ret,NULL,0,' ',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPreviewDisplayMessage,
				     "Display the message."));
				     
    add_commands_help_single(ret,NULL,0,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));

    add_commands_help_single(ret,NULL,0,'f',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandSendForget,
				     "Forget the message."));

     add_commands_help_single(ret,NULL,0,'H',
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandPreviewDisplayMsgAllHdr,
				      "Display the message with all headers (ignore weedout-without-title list)."));
    
    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

    add_commands_help_single(ret,NULL,0,'m',
			     CATGETS(elm_msg_cat, CommandSet,
				    CommandPreviewMailMessage,
				    "Mail the message."));

    add_commands_help_single(ret,NULL,0,'V',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPreviewGotoPreSend,
				     "Go to Mail Pre-Send Screen"));

    add_commands_help_single(ret,NULL,0,'v',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandPreviewViewMimeSt,
				     "View MIME structure (attachments) in the message."));
   
    DPRINT(Debug,30,(&Debug,
		     "give_preview_commands=%p [pointer %p]\n",
		     ret,&preview_commands));

    return ret;
}

/* increment refcount */
struct elm_commands *give_checkfrom_commands() 
{
    static struct elm_commands  *checkfrom_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (checkfrom_commands) {
	inc_commands_refcount(checkfrom_commands);
	return checkfrom_commands;
    }
    
    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandCFKeyTitle,
					      "From Address confirmation")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandCFDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&checkfrom_commands);
    
    {
	int cmds[] = { '\n','\r',  0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandSendDefaultAction,
				       "Default action.\n"));
    }
    
    add_commands_help_single(ret,NULL,0,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));
    
    {
	int cmds[] = { 'c', *def_ans_yes, 0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCFContinue,
				       "Continue to send or preview message."));
    }
    
    add_commands_help_single(ret,NULL,0,'f',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandCFforget,
				     "Forget the message."));
    
    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));
    
    {
	int cmds[] = { 'V', *def_ans_no,  0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCFPreviewMenu,
				       "Do not continue; Go to preview menu."));
    }
    
    DPRINT(Debug,30,(&Debug,
		     "*give_checkfrom_commands=%p [pointer %p]\n",
		     ret,&checkfrom_commands));
    
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
