static char rcsid[] = "@(#)$Id: quota_dispcmd.c,v 1.2 2020/01/18 20:07:41 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.2 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_quotadisp_commands()
{
    static struct elm_commands  * quotadisp_commands = NULL;
  
    struct elm_commands  * ret = NULL;
    
    if (quotadisp_commands) {
	inc_commands_refcount(quotadisp_commands);
	return quotadisp_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandQuotaKeyTitle,"Quota display command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandQuotaDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&quotadisp_commands);

    
    {
	int cmds[] = { '\n','\r',  0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandQuotaReturnKey,
				       "Go to the next page or quit a quota screen."));
    }
    
    {
	int cmds[] = { ' ',  '+',  RIGHT_MARK, PAGEDOWN_MARK, 0 };
	
	add_commands_help_many(ret,0,cmds,
				 CATGETS(elm_msg_cat, CommandSet,
					 CommandQuotaNextPage,
					 "Go to the next page."));
    }

    {
	int cmds[] = { '-',  LEFT_MARK, PAGEUP_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet,
				       CommandQuotaPreviousPage,
				       "Go to the previous page."));
	
    }


    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));
     }

    add_commands_help_single(ret,NULL,0, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainRewriteScreen,
				     "Rewrite the screen."));

    add_commands_help_single(ret,NULL,0,'q',
			     CATGETS(elm_msg_cat, CommandSet, CommandQuotaQuit,
				     "Quit a quota screen."));
       
    DPRINT(Debug,30,(&Debug,
		     "give_quotadisp_commands=%p [pointer %p]\n",
		     ret,&quotadisp_commands));
    
    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
