static char rcsid[] = "@(#)$Id: onethreadcmd.c,v 1.4 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");


static struct elm_commands *give_view_thread_common_commands P_((void));
static struct elm_commands *give_view_thread_common_commands() 
{        

    static struct elm_commands  * view_thread_common_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (view_thread_common_commands) {
	inc_commands_refcount(view_thread_common_commands);
	return view_thread_common_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailKeyTitle,
					      "Viewing thread mails command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&view_thread_common_commands);


    add_commands_help_single(ret,NULL,0,'|',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandCommonPipe,
				     "Pipe the current message or tagged messages to the command specified."));



    {
        struct elm_commands *core = give_common_core_commands();
      
        add_commands_help_merge(ret,core,0);
      
        free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_view_thread_common_commands=%p [pointer %p]\n",
		     ret,&view_thread_common_commands));


    return ret;
}

struct elm_commands *give_view_thread_mail_commands() 
{        

    static struct elm_commands  * view_thread_mail_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (view_thread_mail_commands) {
	inc_commands_refcount(view_thread_mail_commands);
	return view_thread_mail_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailKeyTitle,
					      "Viewing thread mails command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&view_thread_mail_commands);

    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainOptionsMenu,
				     "Go to the options submenu."));


    {
        int cmds[] = { 'q', 'Q', ctrl('Q'), 'i', 'x', 'X', 0 };

	add_commands_help_many(ret,0,cmds,
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandViewThreadMailQuit,
					 "Return to thread index."));
    }

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandMainToggleMenu,
				     "Toggle menu on/off"));
    
    {
        struct elm_commands *mbx = give_additional_mailbox_commands();
      
        add_commands_help_merge(ret,mbx,0);
      
	free_commands(&mbx);    /* Just decrements refcount */
     }
     
     {
       struct elm_commands *core = give_view_thread_common_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_view_thread_mail_commands=%p [pointer %p]\n",
		     ret,&view_thread_mail_commands));

     return ret;
}

struct elm_commands *give_view_thread_pager_commands() 
{        

    static struct elm_commands  * view_thread_pager_commands = NULL;

    struct elm_commands  * ret = NULL;

    if (view_thread_pager_commands) {
	inc_commands_refcount(view_thread_pager_commands);
	return view_thread_pager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailPgKeyTitle,
					      "Viewing thread mails command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandViewThreadMailPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&view_thread_pager_commands);

    /* none */

    {
      struct elm_commands *core = give_view_thread_common_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_view_thread_pager_commands=%p [pointer %p]\n",
		     ret,&view_thread_pager_commands));

    return ret;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
