static char rcsid[] = "@(#)$Id: genericreplycmd.c,v 1.6 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_generic_reply_commands() 
{        

    static struct elm_commands  * generic_reply_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (generic_reply_commands) {
	inc_commands_refcount(generic_reply_commands);
	return generic_reply_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandGenericReplyKeyTitle,
					      "Generic reply command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandGenericReplyDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&generic_reply_commands);

    
    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested ,'?',
			     CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				     "Show command help or this screen of information."));

    add_commands_help_single(ret,NULL,0,'a',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericReplyAll,
				     "Reply to the all recipients and to the mailing list."));

    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested, 'i',
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGnericReplyIndex,
				     "Quit generic reply screen and go to the index screen."));


    add_commands_help_single(ret,NULL,0,'l',    
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericReplyList,
				     "Reply to the mailing list."));

    add_commands_help_single(ret,NULL,FLAG_KEY_no_nested, ctrl('L'),
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericReplyRedraw,
				     "Redraws generic reply screen."));


    add_commands_help_single(ret,NULL,0,'o',    
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericOwner,
				     "Reply to the owner of the mailing list."));

    {
      int cmds[] = { 't', 'f', 0 };
      
      add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericAuthor,
				     "Reply to the auther of the message. This ignores Reply-To: -header field."));
    }


    {
      int cmds[] = { ctrl('J'),ctrl('M'), 'q', 'x', TERMCH_interrupt_char, 0 };

      add_commands_help_many(ret,FLAG_KEY_no_nested, cmds,
			     CATGETS(elm_msg_cat, CommandSet,
				     CommandGenericReplyQuit,
				     "Quit generic reply screen."));
    }

    DPRINT(Debug,30,(&Debug,
		     "give_generic_reply_commands=%p [pointer %p]\n",
		     ret,&generic_reply_commands));

    return ret;
}
