static char rcsid[] = "@(#)$Id: duplicate_removalcmd.c,v 1.8 2014/11/15 11:00:24 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");

/* increment refcount */
struct elm_commands *give_dupremA_commands P_((void));
struct elm_commands *give_dupremA_commands() 
{

    static struct elm_commands  * dupremA_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (dupremA_commands) {
	inc_commands_refcount(dupremA_commands);
	return dupremA_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemKeyTitle,
					      "Duplicate removal command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&dupremA_commands);

    {
	int cmds[] = { '?', HELP_MARK, 0 };

	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandCommonCommandHelp,
				       "Show command help or this screen of information."));	
    }

    add_commands_help_single(ret,NULL,0,'o',
			     CATGETS(elm_msg_cat, CommandSet, CommandDupRemOptionsMenu,
				     "Go to the options submenu."));

    add_commands_help_single(ret,NULL,0,F3_KEY_MARK,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandDupRemToggleMenu,
				     "Toggle menu on/off"));


    DPRINT(Debug,30,(&Debug,
		     "give_dupremA_commands=%p [pointer %p]\n",
		     ret,&dupremA_commands));

    return ret;
}


/* increment refcount */
struct elm_commands *give_dupremmbx_commands() 
{        

    static struct elm_commands  * dupremmbx_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (dupremmbx_commands) {
	inc_commands_refcount(dupremmbx_commands);
	return dupremmbx_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemKeyTitle,
					      "Duplicate removal command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&dupremmbx_commands);

    {
	int cmds[] = { 'i', 'q', 'Q', 'x', 'X', ctrl('Q'), 0 };


	add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet, CommandDupRemReturnIndex,
				     "Quit duplicate removal screen and return to index."));
    }


    {
	struct elm_commands *A = give_dupremA_commands();
	
	add_commands_help_merge(ret,A,0);

	free_commands(&A);    /* Just decrements refcount */
    }


    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }

    {   /* no duprem_common commands */

	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }

    DPRINT(Debug,30,(&Debug,
		     "give_dupremmbx_commands=%p [pointer %p]\n",
		     ret,&dupremmbx_commands));

    return ret;
}

/* increment refcount */
struct elm_commands *give_dupremmain_commands() 
{        

    static struct elm_commands  * dupremmain_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (dupremmain_commands) {
	inc_commands_refcount(dupremmain_commands);
	return dupremmain_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemKeyTitle,"Duplicate removal command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&dupremmain_commands);

    {
      int cmds[] = { '$', F5_KEY_MARK, 0 };

      add_commands_help_many(ret,0,cmds,
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandDupRemResynchronizeFolder,
				     "Quit duplicate removal screen and force resynchronization of the folder."));

    }    


    add_commands_help_single(ret,NULL,0,'c',
			     CATGETS(elm_msg_cat, CommandSet, CommandDupRemChangeFolder,
				     "Quit  duplicate removal screen and change folders, leaving the current folder."));



    {
	int cmds[] = { 'i', 'q', 0 };

	add_commands_help_many(ret,0,cmds,
			       CATGETS(elm_msg_cat, CommandSet, CommandDupRemReturnIndex,
				       "Quit duplicate removal screen and return to index."));
    }


    add_commands_help_single(ret,NULL,0,'Q',
			     CATGETS(elm_msg_cat, CommandSet, CommandDupRemQuickQuit,
				     "Quit duplicate removal screen and  quit the mailer, save read, leave unread, delete deleted."));

    add_commands_help_single(ret,NULL,0,'X',
			     CATGETS(elm_msg_cat, CommandSet, CommandDupRemQuickExit,
				     "Quit duplicate removal screen and exit leaving the folder untouched, unconditionally."));



    {
	int cmds[] = { 'x', ctrl('Q'), 0 };
    
	/* Ctrl-Q is not on pager commands */

	add_commands_help_many(ret,0,cmds,
				 CATGETS(elm_msg_cat, CommandSet, 
					 CommandDupRemExitFolder,
					 "Quit duplicate removal screen and exit leaving the folder untouched, ask permission if changed."));
			     
    }


    {
	struct elm_commands *A = give_dupremA_commands();
	
	add_commands_help_merge(ret,A,0);

	free_commands(&A);    /* Just decrements refcount */
    }


    {
	struct elm_commands *mbx = give_additional_mailbox_commands();
	
	add_commands_help_merge(ret,mbx,0);

	free_commands(&mbx);    /* Just decrements refcount */
    }

    {   /* no duprem_common commands */

	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }


    DPRINT(Debug,30,(&Debug,
		     "give_dupremmain_commands=%p [pointer %p]\n",
		     ret,&dupremmain_commands));



    return ret;
}

/* increment refcount */
struct elm_commands *give_duprempager_commands() 
{        

    static struct elm_commands  * duprempager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (duprempager_commands) {
	inc_commands_refcount(duprempager_commands);
	return duprempager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemPgKeyTitle,"Duplicate removal command")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandDupRemPgDescTitle,
					      "Elm %s PL%s Action (pager)"),
				      VERSION,PATCHLEVEL),
			&duprempager_commands);

    {
	struct elm_commands *cpager = give_cpager_commands();
	
	add_commands_help_merge(ret,cpager,0);

	free_commands(&cpager);    /* Just decrements refcount */

    }


    {   /* no duprem_common commands */

	struct elm_commands *core = give_common_core_commands();
	
	add_commands_help_merge(ret,core,0);

	free_commands(&core);    /* Just decrements refcount */
    }


    DPRINT(Debug,30,(&Debug,
		     "give_duprempager_commands=%p [pointer %p]\n",
		     ret,&duprempager_commands));

    return ret;
}
