static char rcsid[] = "@(#)$Id: builtincmd.c,v 1.10 2016/10/26 16:02:45 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_command.h"
#include "s_command.h"
#include "patchlevel.h"

DEBUG_VAR(Debug,__FILE__,"command");


/* increment refcount */
struct elm_commands *give_builtinpg_core_commands() 
{        

    static struct elm_commands  * builtinpg_core_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (builtinpg_core_commands) {
	inc_commands_refcount(builtinpg_core_commands);
	return builtinpg_core_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandBuiltinKeyTitle,"Key")),
		       format_string(CATGETS(elm_msg_cat, CommandSet,
					     CommandBuiltinDescTitle,
					     "Elm %s PL%s Action"),
				     VERSION,PATCHLEVEL),
		       &builtinpg_core_commands);

    add_commands_title(ret,pg_BOLD,
		       CATGETS(elm_msg_cat, CommandSet,
			       CommandBuiltinHelpTitle,
			       "Help for builtin++ pager"));

        {
	int cmds[] = { '\n','\r', 0 };
	
	add_commands_help_many(ret,0, cmds,
			       CATGETS(elm_msg_cat, CommandSet, 
				       CommandBuiltinNextLine,
				       "Scroll forward (next line)."));
    }


     {
	 int cmds[] = { ' ', '+', PAGEDOWN_MARK, 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinNextScreen,
					"Display next screen of current message (or first screen of next)."));
     }
     

     {
	 int cmds[] = { '-', PAGEUP_MARK, 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinPreviousScreen,
					"Display previous screen of current message."));

     }

     {
	 int cmds[] = { '/', FIND_MARK, 0 };
	 
	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinSearch,
					"Search for pattern in message (on builtin++ pager)."));

     }

     {
	 int cmds[] = { '?', HELP_MARK, 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinHelp,
					"Show this help screen."));

     }

     add_commands_help_single(ret,NULL,0,ctrl('D'),
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinNextHalfScreen,
				      "Scroll forward a half screen."));

     add_commands_help_single(ret,NULL,0,'G',
			      CATGETS(elm_msg_cat, CommandSet,
				      CommandBuiltinLastScreen,
				      "Display last screen of current message."));
     

     add_commands_help_single(ret,NULL,0,ctrl('L'),
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinRefresh,
				      "Redraw current screen (refresh display)."));
     
     add_commands_help_single(ret,NULL,0,ctrl('P'),
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinPreviousLine,
				      "Go backwards (up) one line (previous line)."));

     {
	 int cmds[] = { 'q', 'x', TERMCH_interrupt_char, 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinQuitPager0,
					"Quit builtin++ pager."));
     }

     add_commands_help_single(ret,NULL,0,ctrl('U'),
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinPreviousHalfScreen,
				      "Go backwards (up) a half screen."));

     add_commands_help_single(ret,NULL,0,'W',
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinForceWordWrap,
				      "Forces word wrapping or toggles it on/off."));

     if (pager_paragraph_width > 0)
	 add_commands_help_single(ret,NULL,0,'w',
				  CATGETS(elm_msg_cat, CommandSet, 
					  CommandBuiltinToggleFullWidth,
					  "Toggles between full width and %d character width paragraphs."),
				  pager_paragraph_width);
     else
	 add_commands_help_single(ret,NULL,0,'w',
				  CATGETS(elm_msg_cat, CommandSet, 
					  CommandBuiltinToggleParagraphWidth,
					  "Toggles paragraph width."));

     add_commands_help_single(ret,NULL,0,'\\',
			      CATGETS(elm_msg_cat, CommandSet, 
				      CommandBuiltinToggleWrapInd,
				      "Hide or show wrap indicator (\\)."));
     

     {
	 int cmds[] = { '^', HOME_MARK, 0 };

	 add_commands_help_many(ret,0, cmds,
				CATGETS(elm_msg_cat, CommandSet, 
					CommandBuiltinFirstScreen,
					"Display first screen of current message."));

     }

     DPRINT(Debug,30,(&Debug,
		     "give_builtinpg_core_commands=%p [pointer %p]\n",
		     ret,&builtinpg_core_commands));

     return ret;

}

/* increment refcount */
struct elm_commands *give_builtinpager_commands() 
{        

    static struct elm_commands  * builtinpager_commands = NULL;
    struct elm_commands  * ret = NULL;

    if (builtinpager_commands) {
	inc_commands_refcount(builtinpager_commands);
	return builtinpager_commands;
    }

    ret =  new_commands(format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandBuiltinKeyTitle,"Key")),
			format_string(CATGETS(elm_msg_cat, CommandSet,
					      CommandBuiltinDescTitle,
					      "Elm %s PL%s Action"),
				      VERSION,PATCHLEVEL),
			&builtinpager_commands);

    add_commands_title(ret,pg_BOLD,
		       CATGETS(elm_msg_cat, CommandSet,
			       CommandBuiltinHelpTitle,
			       "Help for builtin++ pager"));

    add_commands_help_single(ret,NULL,0,'i',
			     CATGETS(elm_msg_cat, CommandSet, 
				     CommandBuiltinQuitPagerIndex,
				     "Quit builtin++ pager or return to the index menu."));

    {
	struct elm_commands *core = give_builtinpg_core_commands();
	
	add_commands_help_merge(ret,core,0);
	free_commands(&core);    /* Just decrements refcount */

    }

    DPRINT(Debug,30,(&Debug,
		     "give_builtinpager_commands=%p [pointer %p]\n",
		     ret,&builtinpager_commands));

    return ret;

}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
