case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	ln ../../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH		= "
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH		=	$source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting src/command/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 1.22 2020/01/18 20:07:41 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
# Variables
#	Variables established by Configure
AR		=	$ar
CC		=	$cc
CP		=	$cp
CCFLAGS		=	$ccflags $picflag $xencf
CHMOD		=	$chmod
LINT		=	$lint
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
RM		= 	$rm -f
TOUCH		=	$touch
TAGS		=	ctags
$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'

#	Other general variables
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE) $(DEBUG) 
INCLDIR		=	$(SRCROOT)/hdrs
IHDR		=	../../hdrs
SHELL		=	/bin/sh

OBJ		=	maincmd.o command.o pagercmd.o extendedcmd.o \
 listinfocmd.o genericreplycmd.o partialcmd.o digestcmd.o builtincmd.o \
 duplicate_removalcmd.o aliascmd.o sendcmd.o view_foldercmd.o \
 canceledmailcmd.o threadcmd.o onethreadcmd.o visit_mailboxcmd.o \
 attach_menucmd.o fbrowsercmd.o opt_gencmd.o headercmd.o quota_dispcmd.o

all:			Makefile libelmcommand.a

install_s:		Makefile libelmcommand.a

uninstall_s:		

clean:
	$(RM) $(OBJ) libelmcommand.a

Makefile: Makefile.SH ../../config.sh
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

libelmcommand.a:	$(OBJ)
			$(AR) r $@ $?
			$(RANLIB) $@

#	Dependencies of header files upon other header files they include
.PRECIOUS: $(IHDR)/elm_defs.h $(IHDR)/defs_major.h def_mcommon.h \
 $(IHDR)/me.h $(IHDR)/misclib.h

$(IHDR)/elm_defs.h:	$(IHDR)/defs_major.h $(INCLDIR)/elm_nl_types.h \
 $(INCLDIR)/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/defs_major.h:   ../../config.h $(IHDR)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

def_command.h:		$(IHDR)/elm_defs.h $(IHDR)/me.h $(INCLDIR)/mboxlib.h \
 $(INCLDIR)/elm_globals.h
			cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(IHDR)/misclib.h: $(INCLDIR)/mlist_common.h
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR)/me.h:	$(INCLDIR)/melib.h $(IHDR)/misclib.h $(INCLDIR)/addrlib.h \
 $(INCLDIR)/aliaslib.h $(INCLDIR)/mime.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
maincmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
command.o:           def_command.h $(INCLDIR)/s_command.h 
pagercmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
extendedcmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
listinfocmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
genericreplycmd.o:   def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
partialcmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
digestcmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
builtincmd.o:	     def_command.h $(INCLDIR)/s_command.h $(IHDR)/patchlevel.h
duplicate_removalcmd.o: def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
aliascmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
sendcmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
view_foldercmd.o:	def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
canceledmailcmd.o:	def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
threadcmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
onethreadcmd.c:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
visit_mailboxcmd.o:	def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
attach_menucmd.o:	def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
fbrowsercmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
opt_gencmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(INCLDIR)/opt_imp.h
headercmd.o:		def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
quota_dispcmd.o:	def_command.h $(INCLDIR)/s_command.h \
 $(IHDR)/patchlevel.h
!NO!SUBS!
