/* $Id: def_block.h,v 2.10 2020/05/21 02:58:29 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mboxlib.h"
#include "schedule_time.h"
#include "me.h"
#include "mailerlib.h"

#define BLOCK_magic		0xED00

struct text_block {
    unsigned short        magic;     /* BLOCK_magic */

    struct text_block_type  *block_type;

    union {
	void                * dummy;
	struct fileblock    * fileblock;
	struct stringblock  * stringblock;
    } u;

    int quote;
};

typedef void tb_free_block P_((struct text_block *block));
typedef void tb_alloc_block P_((struct text_block *block));
typedef charset_t tb_get_charset_from_block P_((struct text_block *block));

/* idx == 0 is first line */
typedef struct string * get_line_from_block P_((struct text_block *block, int *idx, int *errors));

/* Returns NULL if no filename */
typedef const char * tb_get_filename_from_block P_((struct text_block *block));

#define BLOCK_type_magic	0xED01

struct text_block_type {
    unsigned short        magic;     /* BLOCK_type_magic */

    tb_free_block              * tb_free_it;
    tb_alloc_block             * tb_alloc_it;
    tb_get_charset_from_block  * tb_get_charset_from_it;
    get_line_from_block        * get_line_from_it;
    tb_get_filename_from_block * tb_get_filename_from_it;
};

struct text_block * alloc_block P_((struct text_block_type *block_type));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
