static char rcsid[] = "@(#)$Id: args.c,v 2.62 2025/06/14 06:44:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.62 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, 
 *                            hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************
 *  Based on Elm 2.4 src/args.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************
 *  Incorparated Elm 2.5 code from src/args.c. 
 *  That code was following copyright:
 *
 *  The Elm Mail System  -  $Revision: 2.62 $   $State: Exp $
 *
 *                      Copyright (c) 1988-1995 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** starting argument parsing routines for ELM system...

**/

#include "def_elm.h"
#include "patchlevel.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"ELM");

struct Attachments attach_files = { NULL, 0 };

const struct Attachments NULL_Attachments = { NULL, 0 };

void add_Attachments(A,x) 
     struct Attachments *A;
     mime_t *x;
{
    if (x->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"add_Attachments",
		   "Bad magic number");

    A->attach_files = safe_array_realloc(A->attach_files,
					 (A->attachment_count+1),
					 sizeof (A->attach_files[0]));
    A->attach_files[A->attachment_count++] = *x;

    mime_t_zero(x);        /* Quarantee no double pointters */
}

void free_Attachments(A) 
     struct Attachments *A;
{    
    if (A->attach_files) {
	int i;

	for (i = 0; i < A->attachment_count; i++) {
	    mime_t_clear(& (A->attach_files[i]) );
	}
	free(A->attach_files);
	A->attach_files     = NULL;
	A->attachment_count = 0;
    }
}

extern char *optarg;		/* optional argument as we go */
extern int   optind;			/* argnum + 1 when we leave   */


static void args_version P_((int i));
static void args_help P_((void));

char * wanted_charset;
int wanted_switchmode = -1;

char * conf_backup_suffix;

char * wanted_title_string;
char * wanted_icon_string;
char * with_title;
char * wanted_mailbox_title;
int    opmode                    = 0;   /* Yet unknown */
int    TreatAsSpooled;

int confirm_url;
int have_DW_characters;

static const char OPTION_LETTERS[] =  "46?aA:b:cd:D:f:hi:kKmMO:r:s:StvVwX:yz-:";

void set_early_options(argc, argv)
     int argc;
     char *argv[];
{
    int c = 0;

    
    while ((c = ELM_GETOPT(argc, argv,OPTION_LETTERS)) != EOF) {
	switch (c) {	    
	case 'd' : 
#if DEBUG
	    set_debugging(optarg);	   
#endif
	    /* error is printed later */
	    break;
	}
    }

    optind = 1;   /* Reset scanning */
}

enum long_option_code {
    OPTION_bad,
    OPTION_title_name,
    OPTION_icon_name,
    OPTION_with_title,
    OPTION_with_title0,
    OPTION_mailbox_title,
    OPTION_confirm_url,
    OPTION_folder_selection,
    OPTION_have_DW_characters,
    OPTION_mail_file,
    OPTION_mail_file_args,
    OPTION_messages,
    OPTION_transaction
};

static struct long_option {

    char * opt_text;
    enum long_option_code code;

} long_options[] = {
    { "title-name=",      OPTION_title_name    },
    { "icon-name=",       OPTION_icon_name     },
    { "with-title=",      OPTION_with_title    },
    { "with-title",       OPTION_with_title0   },
    { "mailbox-title=",   OPTION_mailbox_title },
    { "confirm-url",      OPTION_confirm_url   },
    { "folder-selection", OPTION_folder_selection },
    { "have-double-wide-characters", OPTION_have_DW_characters },
    { "mail-file=",       OPTION_mail_file     },
    { "mail-file",        OPTION_mail_file_args },
    { "messages=",        OPTION_messages      },
    { "transaction=",      OPTION_transaction   },
};

#define NUM_long_options (sizeof long_options / sizeof (long_options[0]))

static enum long_option_code find_long_option P_((char * optarg,
						  char ** param)); 
static enum long_option_code find_long_option(optarg,param)
     char  * optarg;
     char ** param; 
{
    enum long_option_code ret =  OPTION_bad;

    enum {
	no_match,
	inside_match,
	found_match
    }  matches[NUM_long_options];

    int x,p;
    int count = 0;

    for (x = 0; x < NUM_long_options; x++)
	     matches[x] = inside_match  ;

    if (param)
	*param = NULL;

    for (p = 0; optarg[p]; p++) {
	for (x = 0; x < NUM_long_options; x++) {
	    
	    switch (matches[x]) {
	    case no_match:                break;
	    case inside_match:
		if (! long_options[x].opt_text[p]) {
		    DPRINT(Debug,10,(&Debug, 
				     "find_long_option: %d: pos %d, '%s' is only prefix of '%s'\n",
				     x,p,long_options[x].opt_text,optarg));

		    matches[x] = no_match;

		} else if ( optarg[p] != long_options[x].opt_text[p]) {
		    DPRINT(Debug,10,(&Debug, 
				     "find_long_option: %d: pos %d, '%s' does not match to '%s'\n",
				     x,p,long_options[x].opt_text,optarg));

		    matches[x] = no_match;

		} else if ('=' == optarg[p]) {
		    DPRINT(Debug,10,(&Debug, 
				     "find_long_option: %d: pos %d, '%s' matches to '%s'\n",
				     x,p,long_options[x].opt_text,optarg));
		    if (param)
			*param = &(optarg[p+1]);

		    matches[x] = found_match;
		}
		break;
	    case found_match:                 break;
	    }

	}
    }

    for (x = 0; x < NUM_long_options; x++) {

	switch (matches[x]) {
	case no_match:                break;
	case inside_match:

	    if (! long_options[x].opt_text[p]) {
			    
		DPRINT(Debug,10,(&Debug, 
				 "find_long_option: %d: pos %d, '%s' matches to '%s'\n",
				 x,p,long_options[x].opt_text,optarg));
		
		if (param)
		    *param = NULL;

		matches[x] = found_match;
		count++;
		ret = long_options[x].code;
	    } else {

		DPRINT(Debug,10,(&Debug, 
				 "find_long_option: %d: pos %d, '%s' is longer than '%s'\n",
				 x,p,long_options[x].opt_text,optarg));
		
		matches[x] = no_match;;
	    }
	    break;

	case found_match:
	    count++;
	    ret = long_options[x].code;
	    break;
	}
    }

    if (count > 1) {
	DPRINT(Debug,10,(&Debug, 
			 "find_long_option: %d matches for  '%s'\n",
			 count,optarg));
	ret = OPTION_bad;
    }

    DPRINT(Debug,10,(&Debug, 
		     "find_long_option=%d",ret));

    switch (ret) {
    case OPTION_title_name:         DPRINT(Debug,10,(&Debug, " OPTION_title_name")); break;
    case OPTION_icon_name:          DPRINT(Debug,10,(&Debug, " OPTION_icon_name"));  break;
    case OPTION_with_title:         DPRINT(Debug,10,(&Debug, " OPTION_with_title")); break;
    case OPTION_with_title0:        DPRINT(Debug,10,(&Debug, " OPTION_with_title0")); break;
    case OPTION_mailbox_title:      DPRINT(Debug,10,(&Debug, " OPTION_mailbox_title")); break;
    case OPTION_confirm_url:        DPRINT(Debug,10,(&Debug, " OPTION_confirm_url")); break;
    case OPTION_folder_selection:   DPRINT(Debug,10,(&Debug, " OPTION_folder_selection")); break;
    case OPTION_have_DW_characters: DPRINT(Debug,10,(&Debug, " OPTION_have_DW_characters")); break;
    case OPTION_mail_file:          DPRINT(Debug,10,(&Debug, " OPTION_mail_file"));   break;
    case OPTION_mail_file_args:     DPRINT(Debug,10,(&Debug, " OPTION_mail_file_args")); break;
    case OPTION_messages:           DPRINT(Debug,10,(&Debug, " OPTION_messages")); break;
    case OPTION_transaction:        DPRINT(Debug,10,(&Debug, " OPTION_transaction")); break;

    case OPTION_bad:                DPRINT(Debug,10,(&Debug, " OPTION_bad")); break;
    }

    if (param) {
	if (*param) {
	    DPRINT(Debug,10,(&Debug, " *param=%s",
			     *param));
	}  else {
	    DPRINT(Debug,10,(&Debug, " *param=<NULL>"));
	}
    }

    DPRINT(Debug,10,(&Debug, "\n"));

    return ret;
}

enum short_option_code {
    SHORTOPT_IPv4  = ipv4_option /* '4' */,
    SHORTOPT_IPv6  = ipv6_option /* '6' */,
    SHORTOPT_ArrowCursor  = 'a',
    SHORTOPT_AttachFile   = 'A',
    SHORTOPT_BackupSuffix = 'b',
    SHORTOPT_CheckMode    = 'c',
    SHORTOPT_Debug        = 'd',
    SHORTOPT_DisplayCS    = 'D',
    SHORTOPT_MailFolder   = 'f',
    SHORTOPT_ArgsHelp     = 'h',
    SHORTOPT_IncludeFile  = 'i',
    SHORTOPT_ignored1     = 'k',
    SHORTOPT_ignored2     = 'K',
    SHORTOPT_MenuOff      = 'm',
    SHORTOPT_TreatSpool   = 'M',
    SHORTOPT_OpenURL      = 'O',
    SHORTOPT_RCFile       = 'r',
    SHORTOPT_Subject      = 's',
    SHORTOPT_SendOnly     = 'S',
    SHORTOPT_No_tite      = 't',
    SHORTOPT_Version      = 'v',
    SHORTOPT_SndMailV     = 'V',
    SHORTOPT_WriteRC      = 'w',
    SHORTOPT_transaction  = 'X',
    SHORTOPT_unread       = 'y',
    SHORTOPT_nonempty     = 'z',
    SHORTOPT_long_option  = '-',
    
    SHORTOPT_getopt_error = '?'   /* getopt() returns '?' on error */
};



/* Retuns array of files requested */
char ** parse_arguments(argc, argv, to_whom, url_mode, 
			ret_included_file,ret_subject)
     int argc;
     char *argv[];
     char ***to_whom;
     char **url_mode;
     const char ** ret_included_file;
     const char ** ret_subject;
{
    /** Set flags according to what was given to program.  If we are 
	fed a name or series of names, put them into the 'to_whom' buffer
	and if the check_only flag wasn't presented, set mail_only to ON,
	and if stdin is not a tty, set batch_only  to ON;
	Return req_mfile, which points to a named mail file or is empty.
    **/

    int c = 0;
    int v = 0;
    char ** req_vector = NULL;
    int req_len = 0;
    int args_as_mail_files = 0;
    
    *to_whom = NULL;
   
    *ret_included_file = NULL;
    *ret_subject       = NULL;
    *url_mode = NULL;

    while ((c = ELM_GETOPT(argc, argv,OPTION_LETTERS)) != EOF) {
	enum short_option_code  code = c;  /* Get warning abount missing enum
					      values on switch */
	switch (code) {	      
	    
	case SHORTOPT_IPv4:
	case SHORTOPT_IPv6:
	    if (add_ipv_option(code,ipv4_option_printerr) <= ipv_opt_unsupported) {
		exit(1);
	    }	      
	    break;
	    
	case SHORTOPT_ArrowCursor:
	    arrow_cursor++;
	    break;
	case SHORTOPT_AttachFile: 
	    if(!Attach_it(optarg)){
		exit(1);
	    }
	    
	    if (opmode && opmode != OPMODE_SEND) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadAoption,
				  "Option -A incompatible with given other options."));
		exit(1);
	    }
	    
	    opmode = OPMODE_SEND;
	    break;
	    
	case SHORTOPT_BackupSuffix:
	    if (conf_backup_suffix) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsDupBackupOpt,
				  "Duplicate backup option: Both -b%s and -b%s given."),
			  conf_backup_suffix,optarg);
		exit(1);
	    }
	    
	    conf_backup_suffix = optarg;
	    
	    break;
	case SHORTOPT_CheckMode: 
	    
	    if (opmode && opmode != OPMODE_CHECK) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadCoption,
				  "Option -c is incompatible with given other options."));
		exit(1);
	    }
	    
	    opmode = OPMODE_CHECK;
	    use_tite = 0;     
	    break;
	    
	case SHORTOPT_Debug: 
#if DEBUG
	    set_debugging(optarg);	   
#else
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsIngoringDebug,
			      "Warning: system created without debugging enabled - request ignored\n"));
	    error_sleep(1);
#endif
	    break;
	    
	case SHORTOPT_DisplayCS: 	  
	    if (0 == strcmp("NOSWITCH",optarg))
		wanted_switchmode  = 0;
	    else if ('=' == optarg[0]) {
		wanted_charset = safe_strdup(optarg+1);
		wanted_switchmode  = 0;
	    } else {
		wanted_charset = safe_strdup(optarg);
		wanted_switchmode  = 1;
	    }
	    break;
	    
	case SHORTOPT_MailFolder: 
	    req_vector = safe_array_realloc(req_vector,
					    (req_len+2), sizeof(req_vector[0]));
	    
	    req_vector[req_len]   = safe_strdup(optarg);  /* Not really required? */
	    req_vector[req_len+1] = NULL;
	    req_len++;
	    
	    if (opmode && !OPMODE_IS_READMODE(opmode)) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadFoption,
				  "Option -f is incompatible with given other options."));
		exit(1);
	    }
	    
	    if (!opmode)
		opmode = OPMODE_READ;
	    
	    break;
	case SHORTOPT_getopt_error:   /* getopt() returns '?' on error */
	case SHORTOPT_ArgsHelp:
	    args_help();
	    break;
	    
	case SHORTOPT_IncludeFile: 
	    
	    if (opmode && opmode != OPMODE_SEND) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadIoption,
				  "Option -i is incompatible with given other options."));
		exit(1);
	    }
	    
	    if (*ret_included_file) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadCantIncludeSeveralFiles,
				  "Option -i already given. Can't include several files."));
		exit(1);
	    }
	    
	    *ret_included_file = optarg;
	    
	    opmode = OPMODE_SEND;    
	    break;
	    
	case SHORTOPT_ignored1:
	    /* Ignored 

	       Keypad - force knowledge of HP terminal keyboard, to allow
	       the use of the NEXT, PREV and HOME/SHIFT-HOME keys.
	    */
	    break;

	case SHORTOPT_ignored2:
	    /* Ignored

	       Keypad + softkeys - enable use of softkeys on HP terminals only. 
	    */
	    break;
	    
	case SHORTOPT_TreatSpool: 
	      TreatAsSpooled = TRUE;			

	      if (opmode && !OPMODE_IS_READMODE(opmode)) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMoption,
				    "Option -M is incompatible with given other options."));
		  exit(1);
	      }

	      if (!opmode)
		  opmode = OPMODE_READ;    

	      break;

	  case SHORTOPT_MenuOff: mini_menu = 0;	break;
	  case SHORTOPT_RCFile : set_user_rc_location(optarg); break;

	  case SHORTOPT_SendOnly: 
	      if (opmode && opmode != OPMODE_SEND) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadSoption,
				    "Option -S incompatible with given other options."));
		  exit(1);
	      }

	      opmode = OPMODE_SEND;			
	      break;
	  case SHORTOPT_Subject: 

	      if (opmode && opmode != OPMODE_SEND) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadsOption,
				    "Option -s is incompatible with given other options."));
		  exit(1);
	      }

	      if (*ret_subject) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsSeveralSubjectOptions,
				    "Several -s 'subject' options is not possible."));
		  exit(1);
	      }

	      *ret_subject = optarg;
	      opmode = OPMODE_SEND;
	      break;

	  case SHORTOPT_OpenURL: /* Open url */

	      if (*url_mode) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsSeveralUrlOptions,
				    "Several -O 'url' options is not possible."));
		  exit(1);
	      }
	      *url_mode = safe_strdup(optarg);  /* Not really required? */		  
	      break;
	  case SHORTOPT_No_tite  : use_tite = 0;	break;
	  case SHORTOPT_SndMailV : sendmail_verbose++;  break;
	  case SHORTOPT_Version  : v++;                 break;
	  case SHORTOPT_WriteRC  : write_elmrc++;       break;

	  case SHORTOPT_transaction : 
	      if (!set_transaction_file(optarg))
		  exit(1);
	      break;

	  case SHORTOPT_unread:
	      if (opmode && opmode != OPMODE_READ) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadYoption,
				    "Option -y incompatible with given other options."));
		  exit(1);
	      }
              opmode  = OPMODE_READ_UNREAD;
	      break;

	  case SHORTOPT_nonempty: 
	      if (opmode && opmode != OPMODE_READ) {
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadZoption,
				    "Option -z incompatible with given other options."));
		  exit(1);
	      }
	      opmode = OPMODE_READ_NONEMPTY;

	      break;

	case SHORTOPT_long_option:
	    {
	      char *param = NULL;

	      switch (find_long_option(optarg,&param)) {

	      case OPTION_title_name:
		  wanted_title_string = param;
		  break;

	      case OPTION_icon_name:
		  wanted_icon_string = param;
		  break;

	      case OPTION_with_title:
		  with_title = param;
		  break;

	      case OPTION_with_title0:
		  with_title = "";
		  break;

	      case OPTION_mailbox_title:
		  wanted_mailbox_title = param;
		  break;
		  
	      case  OPTION_confirm_url :
		  confirm_url = 1;
		  break;

	      case  OPTION_folder_selection:

		  if (opmode && opmode != OPMODE_READ) {
		      lib_error(CATGETS(elm_msg_cat, ElmSet, 
					ElmArgsBadFSoption,
					"Option --folder-selection is incompatible with given other options."));
		      exit(1);
		  }

		  opmode = OPMODE_READ_SELECT;
		  break;

	      case OPTION_have_DW_characters:
		  have_DW_characters = 1;
		  break;

	      case OPTION_mail_file:

		  if(!add_mail_file(param)) {
		      exit(1);
		  }

		  break;
	      case OPTION_mail_file_args:
		  args_as_mail_files = 1;
		  break;

	      case OPTION_messages:

		  if (!open_messages_log(param)) {
		      exit(1);
		  }
		  break;

	      case OPTION_transaction: /* Same as -X option */
		  if (!set_transaction_file(param))
		      exit(1);
		  break;

		  
	      case OPTION_bad:
		  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadLongOption,
				    "Bad Long option: %s\n"),
			    optarg);
	  
		  exit(1);
	      }
	      
	  }
	      break;
	  }
    }

    if (have_DW_characters && wanted_charset) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadDW,
			      "Option --have-double-wide-characters do not work with -D %s%s option.\n"),
		      wanted_switchmode ? "" : "=",
		      wanted_charset);

	    exit(1);
    }


    if (v)
	args_version(v);

    if (args_as_mail_files) {

	if (!*url_mode && !opmode)
	    opmode = OPMODE_READ;
	else if (OPMODE_IS_CHECKMODE(opmode)) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMailFileOptC,
			      "Option --mail-file is incompatible with -c option."));
	    exit(1);
	} else if ((opmode & OPMODE_READ_SELECT) == OPMODE_READ_SELECT) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMailFileReadSel,
			  "Option --mail-file is incompatible with --folder-selection option."));
	
	    exit(1);
	}
	
	if (optind < argc) {
	    int i;
	    int ok = 1;

	    for (i = optind; i < argc; i++) {
		if(!add_mail_file(argv[i]))
		    ok = 0;
	    }
	
	    if (!ok)
		exit(1);
	    
	} else {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsMailFileParams,
			      "Option --mail-file requires file name(s) as argumens."));
	    exit (1);
	}
	
    } else if (optind < argc) {


	if (opmode && 
	    !OPMODE_IS_SENDMODE(opmode) &&
	    !OPMODE_IS_CHECKMODE(opmode)) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadParams,
			      "Given addresses are incompatible with given options."));
	    exit(1);
	}

	*to_whom = argv + optind;
	if (!opmode)
	    opmode = OPMODE_SEND;
	
    }

    if (OPMODE_IS_CHECKMODE(opmode) ||  *to_whom || req_len > 0 ||
	(opmode & OPMODE_READ_SELECT) == OPMODE_READ_SELECT) {
	    
	    if (*url_mode) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadOoption,
				    "Option -O is incompatible with given other options or arguments"));
		exit(1);
	    }

    }

    if (OPMODE_IS_CHECKMODE(opmode) &&
	mail_files_used() >  no_mail_files_given) {

	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMailFileOptC,
			      "Option --mail-file is incompatible with -c option."));

	    exit(1);
    }

    if (((opmode & OPMODE_READ_SELECT) == OPMODE_READ_SELECT) &&
	mail_files_used() >  no_mail_files_given) {

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMailFileReadSel,
			  "Option --mail-file is incompatible with --folder-selection option."));
	
	exit(1);
    }

    if (req_vector && 	mail_files_used() >  no_mail_files_given) {

	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsBadMailFileOptF,
			  "Option --mail-file is incompatible with -f option."));
	
	exit(1);
    }
	
    if (!isatty(STDIN_FILENO)) {

	    if (opmode == OPMODE_SEND 
		|| 
		(!opmode && *url_mode)
		) {

		opmode = OPMODE_SEND;

		if(!*ret_subject || **ret_subject == '\0')
		    *ret_subject = DEFAULT_BATCH_SUBJECT;
		
		if (*ret_included_file) {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsInclFileBatch,
				      "Can't specify an included file in batch mode!"));
		    exit(1);
		}

	    }  

	    if (OPMODE_IS_SENDMODE(opmode) &&
		! *to_whom && ! *url_mode) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsNoFileBatch,
				  "Must specify a recipient in batch mode."));
		exit(1);
	    }		

	    opmode |= OPMODE_BATCH;
    }

    if (attach_files.attachment_count > 0) {
	    if (! OPMODE_IS_SENDMODE(opmode) && !*url_mode) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsAttachFileNotSend,
				  "Can't specify an attached files with no-one to send to!"));
		exit(1);
	    }
    }

    if (*ret_included_file) {
	    
	    if (! OPMODE_IS_SENDMODE(opmode) && !*url_mode) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsInclFileNotSend,
				  "Can't specify an included file with no-one to send to!"));
		exit(1);
	    }

    }

    if (wanted_mailbox_title && req_len < 2) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsSeveralFoldersForTitle,
			      "--mailbox-title requires that several folders is given with -f arguments"));
	    exit(1);
	    
    }

    if (confirm_url && !*url_mode) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsConfirmUrlNeedsO,
			      "--confirm-url requires that url is given with -O argument"));
	    exit(1);
    } 


	/* This sets opmode only if not running URL mode 
	   and it is not set 
	   and not on batch mode 
	*/

    if (!*url_mode && 
	    opmode == 0) {

	    DPRINT(Debug,2,(&Debug, 
			    "Elm: Setting operation mode to read (mailbox)\n"));
	    
	    opmode = OPMODE_READ;
    }
    
    return(req_vector);
}




static void args_help()
{
    int x;
    
    /**  print out possible starting arguments... **/
    
    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmArgsHelp1a,
		      "\nPossible Starting Arguments for ELM program:\n\n\r"));

    
    for (x = 0; OPTION_LETTERS[x]; x++) {

	int have_arg = ':' == OPTION_LETTERS[x+1];

	enum short_option_code code = OPTION_LETTERS[x];

	
	if (isascii(code) && isprint (code)) {
	    switch (code) {
		
	    case SHORTOPT_IPv4:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						   ElmArgsSHUseIPv4,
						   "\t -%c \t\tUse IPv4 connection\n\r"),
					   code);
		break;
	    case SHORTOPT_IPv6:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						   ElmArgsSHUseIPv6,
						   "\t -%c \t\tUse IPv6 connection\n\r"),
					   code);
		break;
	    case SHORTOPT_ArgsHelp:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHThisHelp,
				  "\t -%c \t\tHelp - give this list of options\n\r"),
			  code);
		break;
	    case SHORTOPT_ArrowCursor:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHArrowCUrsor,
				  "\t -%c \t\tArrow - use the arrow pointer regardless\n\r"),
			  code);
		break;
	    case SHORTOPT_AttachFile: 
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHAttachFile,
				  "\t -%cx\t\tAttach file 'x' (requires .elm/mime.types)\n\r"),
			  code);
		break;
	    case SHORTOPT_BackupSuffix:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHBackupSuffix,
				  "\t -%cx\t\tUse suffix 'x' for config file backups\n\r"),
			  code);
		break;
	    case SHORTOPT_CheckMode: 
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHCheckMode,
				  "\t -%c \t\tCheckalias - check the given aliases only\n\r"),
			  code);
		break;
	    case SHORTOPT_Debug:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHDebug,
				  "\t -%cclass=debugfile:n\tDebug - set debug level to 'n' for 'class'\n\r"),
			  code);
		break;
		
	    case SHORTOPT_DisplayCS:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHUseDiplayCS,
				  "\t -%cx\t\tUse display charset 'x'\n\r"),
			  code);
		break;

	    case SHORTOPT_MailFolder: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						       ElmArgsSHMailFolder,
							"\t -%cx\t\tFolder - read folder 'x' rather than incoming mailbox\n\r"),
						code);
		break;

	    case SHORTOPT_IncludeFile: lib_error(CATGETS(elm_msg_cat, ElmSet, 
							 ElmArgsSHIncludeFile,
							 "\t -%cx\t\tInclude prepared file 'x' in edit buffer for send\n\r"),
						 code);
		break;

	    case SHORTOPT_ignored1:  break;
	    case SHORTOPT_ignored2:  break;
		
	    case SHORTOPT_MenuOff: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						     ElmArgsSHMenuOff,
						     "\t -%c \t\tMenu - Turn off menu, using more of the screen\n\r"),
					     code);
		break;
	    case SHORTOPT_TreatSpool: lib_error(CATGETS(elm_msg_cat, ElmSet, 
							ElmArgsSHTreatSpool,
							"\t -%c \t\tMagic mode - treat all folders as spool files.\n\r"),
						code);
		break;

	    case SHORTOPT_OpenURL: lib_error(CATGETS(elm_msg_cat, ElmSet, 
							ElmArgsSHOpenURL,
						     "\t -%cx\t\tOpen url 'x'\n\r"),
					     code);

		break;
	    case SHORTOPT_RCFile:
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmArgsSHRCFile,
				  "\t -%cx\t\tRcfile - Use 'x' as the elmrc instead of the default\n\r"),
			  code);
		break;
		
	    case SHORTOPT_Subject: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						     ElmArgsSHSubject,
						     "\t -%cx\t\tSubject 'x' - for batch mailing\n\r"),
					     code);
		break;
	    case SHORTOPT_SendOnly: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHSendOnly,
						      "\t -%c \t\tSend-only mode\n\r"),
					      code);		
		break;

	    case SHORTOPT_No_tite:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHNoTiTe,
						      "\t -%c \t\tTiTe - don't use termcap/terminfo ti/te entries.\n\r"),
					      code);
		break;

	    case SHORTOPT_Version:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHVersion,
						      "\t -%c \t\tPrint out ELM version information.\n\r"),
					      code);
		break;
		
	    case SHORTOPT_SndMailV: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHSndMailV,
						      "\t -%c \t\tSubject 'x' - for batch mailing\n\r"),
					      code);
		break;

	    case SHORTOPT_WriteRC:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHWriteRC,
						      "\t -%c \t\tWrite .elm/elmrc, .elm/mime.charsets and other .elm files\n\r"),
					      code);
		break;

	    case SHORTOPT_transaction:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
							  ElmArgsSHTransaction,
							  "\t -%cx\t\ttLog remote protocol transaction to file 'x'.\n\r\
\t    \t\tWarning: A transaction (transcript) file will include passwords!\n\r"),
						  code);
		break;

	    case SHORTOPT_unread:  lib_error(CATGETS(elm_msg_cat, ElmSet, 
						     ElmArgsSHUnread,
						     "\t -%c \t\tdon't enter ELM if no unread mail is pending\n\r"),
					     code);
		break;

	    case SHORTOPT_nonempty: lib_error(CATGETS(elm_msg_cat, ElmSet, 
						      ElmArgsSHNonEmpty,
						      "\t -%c \t\tZero - don't enter ELM if no mail is pending\n\r"),
					      code);
		break;

	    case SHORTOPT_long_option:
	    case SHORTOPT_getopt_error:
		break;
	    }
	}

	if (have_arg) {
	    /* Skip argument */	    
	    x++;
	}
    }
    
    lib_error(FRM("\n\n"));
    
    for (x = 0; x < NUM_long_options; x++) {
	int l = strlen(long_options[x].opt_text);
	
	switch(long_options[x].code) {
	case OPTION_title_name:         
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHTitleName,
			      "\t --%sx %*s\tSet termimal's window title to 'x'\n\r"),
		      long_options[x].opt_text,
		      l > 19 ? 0 : 19-l,"");       
	    
	    break;
	case OPTION_icon_name:          
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHIconName,
			      "\t --%sx %*s\tSet terminal's icon name to 'x'\n\r"),
		      long_options[x].opt_text,
		      l > 19 ? 0 : 19-l,"");    
	    break;
	    
	case OPTION_with_title:         
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHWithTitle,
			      "\t --%sx %*s\tSet termimal's window title to 'x'\n\r"),
		      long_options[x].opt_text,
		      l > 19 ? 0 : 19-l,""); 
	    break;
	    
	case OPTION_with_title0:        
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHWithTitle0,
			      "\t --%s %*s\tEnables terminal's window title update\n\r"),
		      long_options[x].opt_text,
		      l > 20 ? 0 : 20-l,""); 
	    
	    break;
	    
	case OPTION_mailbox_title:      
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHMailboxTitle,
			      "\t --%sx %*s\tSet combined mailbox name to 'x'\n\r"),
		      long_options[x].opt_text,
		      l > 20 ? 0 : 20-l,""); 
	    break;
	    
	case OPTION_confirm_url:    
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHConfirmUrl,
			      "\t --%s %*s\tAsk confirmation for url\n\r"),
		      long_options[x].opt_text,      
		      l > 20 ? 0 : 20-l,""); 
	    break;
	    
	case OPTION_folder_selection:   
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHFolderSelection,
			      "\t --%s %*s\tAsk folder/mailbox name\n\r"),
		      long_options[x].opt_text,
		      l > 20 ? 0 : 20-l,""); 
	    break;
	    
	case OPTION_have_DW_characters: 
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsHDWcharacters,
			      "\t --%s %*s\tIndicate that terminal supports double wide characters.\n\r"),
		      long_options[x].opt_text,      
		      l > 20 ? 0 : 20-l,""); 
	    break;
	    
	case OPTION_mail_file:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsMailFile,
			      "\t --%sx %*s\tRead or attach mail from file 'x'.\n\r"),
		      long_options[x].opt_text,      
		      l > 19 ? 0 : 19-l,""); 
	    break;
	    
	case OPTION_mail_file_args:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsMailFile0,
			      "\t --%s %*s\tRead or attach mail from file(s) given as arguments.\n\r"),
		      long_options[x].opt_text,      
		      l > 20 ? 0 : 20-l,""); 
	    break;
	    
	case OPTION_messages:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsMessages,
			      "\t --%sx %*s\tLog some messages to file 'x'.\n\r"),
		      long_options[x].opt_text,      
		      l > 19 ? 0 : 19-l,""); 
	    break;
	    
	case OPTION_transaction:
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmArgsTransaction,
			      "\t --%sx %*s\tLog remote protocol transaction to file 'x'.\n\r\
\t    %*s\tWarning: A transaction (transcript) file will include passwords!\n\r"),
		      long_options[x].opt_text,      
		      l > 19 ? 0 : 19-l,"",
		      20,""
		      ); 
	    break;
	    
	case OPTION_bad:                               break;
	}
    }
        
    exit(1);
}

static void args_version(i)
     int i;
{
#ifndef BINARY_PACKAGE
        time_t    curr_time = time(NULL);
#endif
	char * value = NULL;

	/** print out version information **/


	printf("\nElm Version and Identification Information:\n\n");

	if (i == 1)
	    printf("\tElm Millennium Edition \n\n");

	printf("\tElm %s PL%s, of %s\n",VERSION,PATCHLEVEL,VERS_DATE);

#ifdef BINARY_PACKAGE
	if (i != 2) {
	    printf("\tCompiled for binary distribution.\n");
	    printf("\tSend bug reports to packager of binary distribution.\n");
	}
#else
	if (curr_time < LAST_REPORT_TIME && i != 2) {
	  printf("\tSend bug reports to %s\n",BUG_REPORT_ADDR);
	  printf("\n\tWARNING: Elm is not intended to be distributed in\n");
	  printf(  "\t         binary form. If that is done, then it is very\n");
	  printf(  "\t         likely that compile time configuration does not\n");
	  printf(  "\t         match to your system. This is NOT bug of ELM ME+\n");
	  printf(  "\t         and bug reports for that reason will be rejected.\n\n");
	}
#endif
	if (i == 1) {
	    printf("\n\tBased on Elm 2.4 PL24 - PL25\n");
	    printf("\tIncorporates some code from Elm 2.5 PL7\n\n");
	}

	if (i < 3) {
	  printf("\t(C) Copyright 1996-2025 Kari Hurtta\n");
	  printf("\tBased on Elm 2.5, (C) Copyright 1988-1999 USENET Community Trust\n");
	  printf("\tBased on Elm 2.4, (C) Copyright 1988-1992 USENET Community Trust\n");
	  printf("\tBased on Elm 2.0, (C) Copyright 1986,1987 Dave Taylor\n");
	}
	if ( i < 2 ) {
	  printf ("\n\tTo print configuration, use option: -vv\n");
	  exit(1);
	}
	if (i < 3) {
	  printf("\t----------------------------------\n");
	  printf("\tConfigured %s\n", CONFIGURE_DATE);
	  printf("\t----------------------------------\n");

	  if (have_MMDF)
	      printf("\tUse MMDF Mail Transport Agent/Mailbox Delimiters: MMDF\n");
	  else
	      printf("\tUse UNIX Mailbox Delimiters and Mail Transport Agent: not MMDF\n");
	
#ifdef MYDOMAIN  
          printf("\tCompiled in default host's domain name is %s\n",
		 MYDOMAIN);
#endif
#if defined(GETHOSTNAME) || defined(DOUNAME)
	  printf("\tHostname is available on runtime:");
#ifdef GETHOSTNAME
	  printf(" GETHOSTNAME");
#endif
#ifdef DOUNAME
	  printf(" DOUNAME");
#endif
	  printf("\n");
#else
	  printf("\tHostname is not available on runtime: no GETHOSTNAME nor DOUNAME\n");
#endif

#if defined(GETDOMAINNAME) || defined(I_NETDB)
	  printf("\tDomainname is available on runtime:");

#ifdef GETHOSTNAME
	  printf(" GETDOMAINNAME");
#endif
#ifdef I_NETDB
	  printf(" I_NETDB");
#endif
	  printf("\n");
#else
	  printf("\tDomainname is not available on runtime: no GETDOMAINNAME nor I_NETDB\n");
#endif

#if defined(COMPILE_FCNTL_LOCKING) || defined(COMPILE_FLOCK_LOCKING)
	  printf("\tFollowing syscall locking methods can be configured:");
#ifdef COMPILE_FLOCK_LOCKING
	  printf(" COMPILE_FLOCK_LOCKING");
#endif
#ifdef COMPILE_FCNTL_LOCKING
	  printf(" COMPILE_FCNTL_LOCKING");
#endif
	  printf("\n");
#else
	  printf("\tSyscall locking can not be configured.\n");
#endif

	  printf("\tFollowing mail spool locking protocols will be used (default):");
#ifdef USE_DOTLOCK_LOCKING
	  printf(" USE_DOTLOCK_LOCKING (.lock)");
#endif
#ifdef USE_FLOCK_LOCKING
	  printf(" USE_FLOCK_LOCKING");
#endif
#ifdef USE_FCNTL_LOCKING
	  printf(" USE_FCNTL_LOCKING");
#endif
	  printf("\n");
#ifdef SYSCALL_LOCKING
	  printf("\tFolder locking is available: SYSCALL_LOCKING\n");
#else
	  printf("\tFolder locking is not possible: not SYSCALL_LOCKING\n");
#endif
	  
#if 0
#ifdef DEBUG
	  printf("\tDebug options are available: DEBUG\n");
#else /* DEBUG */
	  printf("\tNo debug options are available: not DEBUG\n");
#endif /* DEBUG */
#endif
		
#ifdef CRYPT
	  printf("\tCrypt function enabled: CRYPT\n");
#else /* CRYPT */
	  printf("\tCrypt function disabled: not CRYPT\n");
#endif /* CRYPT */

	  if (ALLOW_mailbox_editing)
	      printf("\tMailbox editing included: ALLOW_MAILBOX_EDITING\n");
	  else
	      printf("\tMailbox editing not included: not ALLOW_MAILBOX_EDITING\n");

	  if (ALLOW_subshell)
	      printf("\tSubshell menu items included: ALLOW_SUBSHELL\n");
	  else
	      printf("\tSubshell menu items not included: not ALLOW_SUBSHELL\n");

	  if (have_ISPELL) {
	      printf("\tSpell checking feature enabled: ISPELL\n");
	      printf("\t\t(Default spelling checker is %s options '%s')\n", ISPELL_path, ISPELL_options);
	  } else
	      printf("\tSpell checking feature disabled: not ISPELL\n");

	  if (ENABLE_calendar) {
	      printf("\tCalendar file feature enabled: ENABLE_CALENDAR\n");
	      printf("\t\t(Default calendar file is %s)\n",dflt_calendar_file);
	  } else
	      printf("\tCalendar file feature disabled: not ENABLE_CALENDAR\n");

	  if (use_PGP) {
	      printf("\tPGP support enabled: USE_PGP\n");
	  } else {
	      printf("\tPGP support disabled: not USE_PGP\n");
	  }
	  
#ifdef ASCII_CTYPE
	  printf("\t\"ctype\" functions are ASCII -only: ASCII_CTYPE\n");
#else
	  printf("\t\"ctype\" functions are 8-bit clean: not ASCII_CTYPE\n");
#endif
#ifdef BROKE_CTYPE
          printf("\tUsing replacement toupper() and tolower() routines: BROKE_CTYPE\n");
#else
          printf("\tUsing standard \"ctype\" toupper() and tolower() routines: not BROKE_CTYPE\n");
#endif
#ifdef I_LOCALE
          printf("\tSystem support multiple character sets or languages: I_LOCALE\n");
#else
          printf("\tMultiple display character sets are not supported: not I_LOCALE\n");
#endif
#ifdef HAVE_CODESET
          printf("\tSystem supports nl_langinfo(CODESET) query: HAVE_CODESET\n");
	  if (ASCII_CODESET) {
	      char * S = ASCII_CODESET;
	      printf("\t   Codeset for C locale (US-ASCII) is %s\n", S);
	  }

#else
          printf("\tSystem does not support nl_langinfo(CODESET) query: not HAVE_CODESET\n");
#endif
#ifdef WCHAR
          printf("\tSystem have native wide character support: WCHAR\n");
#ifdef __STDC_ISO_10646__
          printf("\t   wchar_t is Unicode (the Universal Character Set): __STDC_ISO_10646__\n");
#endif
#ifdef WCWIDTH
          printf("\t   wcwidth() function is available: WCWIDTH\n");
#else
          printf("\t   Character width function is not available: not WCWIDTH\n");
#endif
#else
          printf("\tSystem do not support wide characters: not WCHAR\n");
#endif

#ifdef MSGCAT
	  printf("\tUses system's msgcat() implementation: MSGCAT\n");
#else
	  printf("\tUses own message catalog routines: not MSGCAT\n");
#endif

#ifdef REMOTE_MBX
          printf("\tSupports remote mailboxes (username@host): REMOTE_MBX\n");

#ifdef HAVE_IN6
	  printf("\t   IPv6 and IPv4 addresses are supported: HAVE_IN6\n");
#else
	  printf("\t   Only IPv4 addresses are used: not HAVE_IN6\n");
#endif

#ifdef HAVE_ADDRINFO
	  printf("\t   May use getaddrinfo() for address lookup: HAVE_ADDRINFO\n");
#else
	  printf("\t   May use gethostname() for address lookup: not HAVE_ADDRINFO\n");
#endif

#ifdef HAVE_IFADDRS
	  printf("\t   May use getifaddrs() for interface address listing: HAVE_IFADDRS\n");
#else
	  printf("\t   Does not use getifaddrs() forinterface address listing: not  HAVE_IFADDRS\n"); 
#endif

#ifdef USE_CLOCK_MONOTONIC
	  printf("\t   May use CLOCK_MONOTONIC with clock_gettime():  USE_CLOCK_MONOTONIC\n");
#else
	  printf("\t   Uses wall clock for scheduling: no USE_CLOCK_MONOTONIC\n");
#endif
	  
#ifdef USE_GETTIMEOFDAY
	  printf("\t   May use gettimeofday() for wall clock on scheduler: USE_GETTIMEOFDAY\n");	  
#else
	  printf("\t   May use time() for wall clock on scheduler: no USE_GETTIMEOFDAY\n");
#endif
#else
          printf("\tDoes not support remote mailboxes (username@host): not REMOTE_MBX\n");
#endif
#ifdef DIROPS
	  printf("\tSupports browsing of local directories: DIROPS %s%s\n",
		 DIROPS == USE_DIRENT ? "(USE_DIRENT)" : "",
		 DIROPS == USE_SYSDIR ? "(USE_SYSDIR)" : "");
#else
	  printf("\tDoes not support browsing of local directories: not DIROPS\n");
#endif
#ifdef GETOPT
	  printf("\tHave system's getopt routines: GETOPT  %s%s\n",
		 GETOPT == GETOPT_OK     ? "(GETOPT_OK)" : "",
		 GETOPT == GETOPT_BROKEN ? "(GETOPT_BROKEN)" : "");
#else
	  printf("\tUses own getopt routines: not GETOPT\n");
#endif

#ifdef MMAP
	printf("\tUnicode data is mapped to memory: MMAP\n");  
#else
	printf("\tUnicode data is read to memory: not MMAP\n");  
#endif
#ifdef USE_DLOPEN
	printf("\tDynamically loaded libraries are supported: USE_DLOPEN\n");
#else
	printf("\tAdditional libraries are not supported: not USE_DLOPEN\n");
#endif

	  printf("\n\n");

	  printf("\tTo read global initialization file %s, use 'elm -vvv'\n",
		 system_rc_file);
	  exit(1);
	}

	switch (i) {
	case 3:
	printf("\t------------------------------------------\n");
	printf("\tSystem RC file: %s\n",system_rc_file);
	printf("\t------------------------------------------\n\n");

	{
	    const int read_flags = READ_FLAG_GLOBAL_ONLY;
	    
	    user_init();
	    init_addrlib(read_flags);
	    init_mailerlib(read_flags);
	    init_mboxlib(read_flags);
	    init_misclib(read_flags);
	    init_defaults(read_flags);
	    post_init_check(read_flags);
	}
	    
	printf("\tHave Posix saved IDs:         %3s (egid %d)\n",
	       have_saved_ids ? "Yes" : "No",
	       mailgroupid);
	putchar('\n');
	
	printf("\tHostname:                     %s\n",hostname);
	printf("\tHost's domain:                %s\n",hostdomain);
	printf("\tQualified hostname:           %s\n",hostfullname);

	{
	    const char **mailname_list = give_dt_path_as_elems(&mailname,"mailname");
	    
	    if (mailname_list) {
		
		if (mailname_list[0]) {
		    int i;
		    printf("\tMailname:                     %s\n",mailname_list[0]);

		    for (i = 1; mailname_list[i]; i++) {
			printf("\t                              %s\n",mailname_list[i]);	
		    }
		} else {
		    printf("\tMailname:                     none\n");
		}
		
	    }	   
	}

	{
	    enum name_resolution tag;
	    int count = 0;

	    printf("\tName resolution:             ");
                      
	    for (tag = 0; tag < nr_COUNT; tag++) {
	
		if (have_name_resolution(tag)) {
		    const char * T = name_resolution_tag(tag);
		    
		    if ((count++) % 4 == 3) {
			printf("\n\t                              ");	
		    } else
			putchar(' ');
		    fputs(T,stdout);
		}
	    }

	    if (!count) {   /* puts outputs newline */
		puts("none");
	    } else
		putchar('\n');	

	    for (tag = 0; tag < nr_COUNT; tag++) {
		const char * T = name_resolution_tag(tag);
		const char * S = name_resolution_gives(tag);
		int E = name_resolution_errno(tag);

		if (S || E) {
		    count = printf("\t- %s gives:",T);
		    
		    while (count > 0 && count < 31) {
			putchar(' '); count++;
		    }
		    
		    if (S) {
			fputs(S,stdout);
		    } else {
			fputs("none",stdout);
		    }
		    
		    if (E) {
			printf("\t(error: %s)",strerror(E));
		    }
		    putchar('\n');
		}
	    }	    
	}


	{
	    const char * mailhome_val = give_dt_estr_as_str(&mailhome_dir_e,
							    "mailhome-dir",
							    NULL,NULL);
	    printf("\tMaihome (dir):                %s\n",
		   mailhome_val ? mailhome_val : "<no value>");

	}

	{
	    unsigned int defaultfile_keyword = 0;
	    unsigned int defaultfile_cmask   = 0;

	    const char * default_val = 
		give_dt_estr_as_str(&defaultfile_e,
				    "incoming-mailbox",
				     &defaultfile_keyword,
				    &defaultfile_cmask);

	    printf("\tMailbox:                      %s%s\n",
		   default_val ? default_val : "<no value>",
		   0 != (defaultfile_cmask & FOLDER_is_local_file) ?
		   " (local file)" : "");
	}

	{
	    enum mailbox_locking_v tag;
	    int count = 0;

	    printf("\tMailhome locking:            ");
 
	    for (tag = 0; tag < NUM_mailbox_locking_v; tag++) {
		if (dt_flag_is_set(& mailhome_locking,tag)) {
		    const char * T = dt_flag_tag(& mailhome_locking,tag);
		    
		    if ((count++) % 4 == 3) {
			printf("\n\t                              ");	
		    } else
			putchar(' ');
		    fputs(T,stdout);		
		}
	    }

	    if (!count) {   /* puts outputs newline */
		puts("none");
	    } else
		putchar('\n');	
	}

	if(mailerfunc(&value,0,0,NULL,READ_FLAG_GLOBAL_ONLY))
	    printf("\tMailer:                       %s\n",value);

	{
	    const char *MIME_name = get_charset_MIME_name(system_charset);

	    printf("\tSystem character-set:         %s\n",
		   MIME_name ? MIME_name : "<no MIME name>");
	}

	{ 
	    const char *MIME_name = get_charset_MIME_name(local_fs_charset);
	    
	    printf("\tLocal FS character-set:       %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,raw_local_fs_charset))
		printf("(%s)",raw_local_fs_charset);
	    putchar('\n');
	}

	{
	    const char *MIME_name = 
		get_charset_MIME_name(wanted_display_charset);

	    printf("\tWanted display character-set: %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,
					   raw_display_charset))
		printf("(%s)",raw_display_charset);
	    putchar('\n');
	}


	{
	    const char *MIME_name = get_charset_MIME_name(text_charset);

	    printf("\tSending character-set:        %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,raw_text_charset))
		printf("(%s)",raw_text_charset);
	    putchar('\n');
	}


	{
	    const char *MIME_name = 
		get_charset_MIME_name(default_nomime_charset);
	    printf("\tDef. non-MIME character-set:  %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name, 
					   raw_default_nomime_charset))
		printf("(%s)",raw_default_nomime_charset);
	    putchar('\n');
	}

	{
	    const char *MIME_name = 
		get_charset_MIME_name(default_mimetext_charset);

	    printf("\tDef. MIME text character-set: %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,
					   raw_default_mimetext_charset))
		printf("(%s)",raw_default_mimetext_charset);
	    putchar('\n');
	}


	printf("\n\tTo list configuration files, use 'elm -vvvv'\n");
	break;

	case 4:
	printf("\t------------------------------------------\n");
	printf("\tElm ME+ configuration files: \n");
	printf("\t------------------------------------------\n\n");
	user_init();

	printf("System configuration files:\n");
	printf("\tRC file:                  %s\n",system_rc_file);

	printf("\tAliases file:             %s\n",system_aliases_file);
	printf("\tOLD Aliases database:     %s\n",old_system_data_file);
	printf("\tOLD Aliases file:         %s\n",old_system_text_file);
	printf("\tMapping to content-type:  %s\n",system_mime_types);
	printf("\tMapping to charset:       %s\n",system_mime_charsets);
	printf("\tMapping of ISO 2022:      %s\n",system_iso2022_sets);
	printf("\tAdditional terminal info: %s\n",system_terminal_info);
	printf("\tMail services info:       %s\n",system_mail_services);
	printf("\tMailing lists info:       %s\n",system_mlist_file);
	printf("\tHash marks info:          %s\n",system_hash_marks);
	printf("\tTagfilter entities list:  %s\n",system_tagfilter_entfile);
	printf("\tDomain-name file:         %s\n",hostdomfile);
	printf("User configuration files:\n");
	printf("\tRC file:                  %s\n",user_rc_file);
	printf("\tAliases file:             %s\n",user_aliases_file);
	printf("\tOLD Aliases database:     %s\n",old_user_data_file);
	printf("\tOLD Aliases file:         %s\n",old_user_text_file);
	printf("\tMapping to content-type:  %s\n",user_mime_types);
	printf("\tMapping to charset:       %s\n",user_mime_charsets);
	printf("\tMapping of ISO 2022:      %s\n",user_iso2022_sets);
	printf("\tAdditional terminal info: %s\n",user_terminal_info);
	printf("\tMail services info:       %s\n",user_mail_services);
	printf("\tMailing lists info:       %s\n",user_mlist_file);
	printf("\tHash marks info:          %s\n",user_hash_marks);
	printf("\tTagfilter entities list:  %s\n",user_tagfilter_entfile);
	printf("\tAdditional mail-headers:  %s\n",user_mailheaders);
	printf("\n\tTo read user configuration, use 'elm -vvvvv'\n");
	break;

	case 5:

	    {
		const int read_flags = 0;
		
		user_init();
		init_addrlib(read_flags);
		init_mailerlib(read_flags);
		init_mboxlib(read_flags);
		init_misclib(read_flags);
		init_melib(read_flags);
		init_defaults(read_flags);
		
		printf("\t------------------------------------------\n");
		printf("\tUser RC file: %s\n",user_rc_file);
		printf("\t------------------------------------------\n\n");
		
		read_rc_file(read_flags);
	    }

	if (display_codeset[0]) {
	  printf("\tLocale (LC_CTYPE):            %s (codeset %s)\n",
		 display_locale,display_codeset);
	} else
	  printf("\tLocale (LC_CTYPE):            %s\n",display_locale);

	{
	    const char *MIME_name = get_charset_MIME_name(system_charset);

	    printf("\tSystem character-set:         %s\n",
		   MIME_name ? MIME_name : "<no MIME name>");
	}

	{
	    const char *MIME_name = 
		get_charset_MIME_name(wanted_display_charset);

	    printf("\tWanted display character-set: %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");

	    if (!MIME_name ||0 != istrcmp(MIME_name,
					  raw_display_charset))
		printf("(%s)",raw_display_charset);
	    putchar('\n');
	}

	{ 
	    const char *MIME_name = get_charset_MIME_name(local_fs_charset);

	    printf("\tLocal FS character-set:       %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,raw_local_fs_charset))
		printf("(%s)",raw_local_fs_charset);
	    putchar('\n');
	}

	{
	    const char *MIME_name = get_charset_MIME_name(text_charset);

	    printf("\tSending character-set:        %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name, raw_text_charset))
		printf("(%s)",raw_text_charset);
	    putchar('\n');
	}

	{
	    const char *MIME_name = 
		get_charset_MIME_name(default_nomime_charset);
	    printf("\tDef. non-MIME character-set:  %-18s",
		   MIME_name ? MIME_name : "<no MIME name>");
	    if (!MIME_name || 0 != istrcmp(MIME_name,
					   raw_default_nomime_charset))
		printf("(%s)",raw_default_nomime_charset);
	    putchar('\n');
	}

	{
	    const char * mailhome_val = give_dt_estr_as_str(&mailhome_dir_e,
							    "mailhome-dir",
							    NULL,NULL);

	     unsigned int defaultfile_keyword = 0;
	     unsigned int defaultfile_cmask   = 0;

	    const char * default_val = 
		give_dt_estr_as_str(&defaultfile_e,
				    "incoming-mailbox",
				    &defaultfile_keyword,
				    &defaultfile_cmask);
	    
	    printf("\tMailbox:                      %s%s",
		   default_val ? default_val : "<no value>",
		   0 != (defaultfile_cmask & FOLDER_is_local_file) ?
		   " (local file)" : "");
		    
	    if (default_val &&	
		(
		 /* Explicite disallow $MAIL to be interpreted as 
		    remote mailbox */
		 ( 
		  0 != (defaultfile_cmask & FOLDER_is_local_file) 
		  ||
		  ( NULL == strchr(default_val,'@') && '/' == default_val[0] )
		   ) 
		 )
		) {
		
		struct stat buf, *Xbuf = NULL;
		enum syscall_status  r = stat(default_val,&buf);

		switch (r) {
		case syscall_success /* 0 */: {
		    Xbuf = &buf;
		}
		    break;
		case syscall_error /* -1 */: {
		    int err = errno;
		    
		    printf("\t(error: %s)",strerror(err));
		}
		    break;
		}
		putchar('\n');

		if (mailhome_val &&
		    in_directory(Xbuf,default_val,mailhome_val)) {
		    enum mailbox_locking_v tag;
		    int count = 0;

		    printf("\t ... uses mailhome locking:  ");
		    
		    for (tag = 0; tag < NUM_mailbox_locking_v; tag++) {
			if (dt_flag_is_set(& mailhome_locking,tag)) {
			    const char * T = dt_flag_tag(& mailhome_locking,tag);
			    
			    if ((count++) % 4 == 3) {
				printf("\n\t                              ");	
			    } else
				putchar(' ');
			    fputs(T,stdout);		
			}
		    }
		    
		    if (!count) {   /* puts outputs newline */
			puts("none");
		    } else
			putchar('\n');			    
		}
	    } else
		putchar('\n');
	}
	
	{
	    enum mailbox_locking_v tag;
	    int count = 0;
	    
	    printf("\tMailbox locking:             ");
	            
	    for (tag = 0; tag < NUM_mailbox_locking_v; tag++) {
		if (dt_flag_is_set(& mailbox_locking,tag)) {
		    const char * T = dt_flag_tag(& mailbox_locking,tag);
		    
		    if ((count++) % 4 == 3) {
			printf("\n\t                              ");	
		    } else
			putchar(' ');
		    fputs(T,stdout);		
		}
	    }

	    if (!count) {   /* puts outputs newline */
		puts("none");
	    } else
		putchar('\n');	
	    
	}

	break;
	}
	exit(1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
