/* $Id: def_aliases.h,v 2.14 2021/07/14 07:19:22 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h" 
#include "mboxlib.h"
#include "me.h"
#include "elm_globals.h"


#define ALIASVIEW_record_magic  0xF608

struct aliasview_record {
    uint16            magic;           /* ALIASVIEW_record_magic */

    struct string         *alias_key;        
    const struct address_alias  *alias_value;      /* Shared */

    int               type;
    int               status;
};

#define ALIASVIEW_buffer_magic	0xF60B

/* Same but not instated   */
struct alias_buffer {
    uint16                   magic;      /* ALIASVIEW_buffer_magic */

    struct string         *alias_key;
    struct address_alias  *alias_value;
};



#if ANSI_C
struct aliasclass;
struct alias_rec;
#endif

#define ALIASVIEW_magic         0xF600

struct AliasView {
    unsigned short           magic;      /* ALIASVIEW_magic */
        
    int                      aliasclasscount;
    struct aliasclass      **aliasclass;      /* Array */
    
    struct alias_view      * view;
    int                      view_len;

    int                      normal_alias_len;

    /* Values set by caller */
    int        current;
    int        selected;

};


extern struct aliasclass * add_aliasclass P_((struct AliasView *x));

extern int at_update_astorage P_((struct aliasclass *c));

extern void set_astorage_alias P_((struct current_astorage *astorage,
				   int index,
				   struct alias_rec * rec));
extern struct alias_rec  * at_astorage_give_alias P_((struct aliasclass *c,
						      int index));

/* src/aliases/ */

extern void reset_astorage P_((struct current_astorage *astorage));

extern void realloc_aliases P_((struct current_astorage *astorage,
				int current_count));


/* src/aliases/aliases_map.c */

extern void am_free_aliasclass P_((struct aliasclass **map));
extern struct aliasclass * am_malloc_aliasclass P_((void));
extern int am_deleted_alias P_((struct aliasclass *map, int cindex));
extern struct aliasview_record *am_give_alias P_((struct aliasclass *map,
						  int cindex));
extern int am_count_aliases P_((struct aliasclass *map));
extern int am_update_aliases P_((struct aliasclass *map));

extern void am_add_to_alias_stack P_((struct alias_stack * stack,
				      struct aliasclass *map));

extern void am_delete_alias P_((struct aliasclass *map,
				int cindex));
extern int am_write_changed P_((struct aliasclass *map,
				int *rebuild_flag));
extern int am_file_changed P_((struct aliasclass *map));

extern const char * am_is_user_editable P_((struct aliasclass *map));
extern int am_reload_aliases P_((struct aliasclass *map));

extern void am_set_standard_aliasmap P_((struct aliasclass *map,int user));

enum compat_mode { compat_none = -1 , compat_system, compat_user };

/* am_set_compat_aliasmap moves am ownership to alias_class */
extern void am_set_compat_aliasmap P_((struct aliasclass  *map,
				       struct aliases_map *am,
				       enum compat_mode    mode));


/* XXX */
extern struct aliasview_record *am_lookup_alias P_((struct aliasclass *map,
						    const struct string *key,
						    int *cindex));
/* Removes old_index alias and adds new alias */
extern struct aliasview_record * am_set_alias P_((struct aliasclass        *map,
						  int old_index,   /* Remove old index */
						  const struct alias_buffer *buffer));

extern void am_add_alias  P_((struct aliasclass        *map,
			      struct aliasview_record  *rec));

extern int am_is_normal_target P_((struct aliasclass *map));
extern int am_is_compat_map    P_((struct aliasclass *map));

extern int give_aliases_filename P_((struct aliasclass       * map,
				     struct aliases_map     ** am,
				     char                   ** fn,
				     charset_t               * cs,
				     struct editor_propline ** pl,
				     int                     * have_propline,
				     struct file_changes    ** file_information));

/* src/aliases/record.c */

extern struct aliasview_record * malloc_aliasview_record P_((const struct string *key,
							     const struct address_alias *value,
							     int type,
							     int status));
extern void free_aliasview_record P_((struct aliasview_record **ptr));

extern void replace_aliasview_record P_((struct aliasview_record *rec,
					 const struct string *key,
					 const struct address_alias *value));


/* src/aliases/buffer.c */

extern struct alias_buffer * malloc_alias_buffer P_((const struct string *key,
						     const struct address_alias *value));


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
