static char rcsid[] = "@(#)$Id: a_sort.c,v 2.7 2022/07/14 14:16:01 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 src/a_sort.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Sort alias table by the field specified in the global
    variable "alias_sortby"...

**/

#include "def_elm.h"
#include "s_aliases.h"

DEBUG_VAR(Debug,__FILE__,"alias");

static void alias_old_current P_((struct alias_view * last_index, 
				  struct AliasView *aview));


static int s_compare_aliases P_((struct sort_data2 *s1,
				 struct sort_data2 *s2));
		       


void sort_aliases(entries,  show_message,aview)
     int entries;
     enum sort_aliases_mode show_message;
     struct AliasView *aview;
{
    /** Sort the header_table definitions... If 'visible', then
	put the status lines etc **/
    
    struct alias_view last_index;
    int alias_current = get_alias_current(aview);

    last_index.classnum = 0;
    last_index.index    = -1;

    DPRINT(Debug,2, (&Debug, "\n** sorting aliases by %s **\n\n", 
		     alias_sort_name(FULL)));
    
    /* Don't get last_index if no entries or no current. */
    /* There would be no current if we are sorting for the first time. */
    if (entries > 0 && alias_current > 0) {
	aliasview_give_index_number(aview,alias_current-1,&last_index);
    }


    switch (show_message) {
    case sa_silent_sort:
	DPRINT(Debug,10, (&Debug, "sort_aliases: silent mode\n"));
	break;
    case sa_visible_sort:
	if (entries > 30) {
	    lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesSort,
				  "Sorting aliases by %s..."), 
			  alias_sort_name(FULL));
	} else {
	    DPRINT(Debug,10, (&Debug, "sort_aliases: silent - %d entries\n",entries));
	}
	break;
    }

    if (entries > 1)
	sort_aview(aview, s_compare_aliases);
  
    if (last_index.index > -1)
	alias_old_current(&last_index,aview);
  
    switch (show_message) {
    case sa_silent_sort:
	break;
    case sa_visible_sort:
	clear_error();
	break;
    }
}

static int compare_names  P_((const struct string *first,
			      const struct string *second));
static int compare_names(first,second)
     const struct string *first;
     const struct string *second;
{
    int ret = 0;

    if (first && !second)
	ret = -1;
    else if (second && !first)
	ret = 1;
    else if (first && second)
	ret = string_cmp(first, second, 0);
    
    return ret;
}


static int name_compare P_((struct  aliasview_record  *first,
			    struct  aliasview_record  *second));
static int name_compare(first,second)
     struct  aliasview_record  *first;
     struct  aliasview_record  *second;
{
    int ret = 0;

    const struct address_alias * first_alias   = aliasview_address_alias(first);
    const struct address_alias * second_alias  = aliasview_address_alias(second);
    
    
    const struct string  *first_firstn       = NULL;
    const struct string  *first_lastn        = NULL;
    const struct address *first_address      = NULL;

    const struct string  *second_firstn      = NULL;
    const struct string  *second_lastn       = NULL;
    const struct address *second_address     = NULL;

    int first_r = 0, second_r = 0;

    if (first_alias)
	first_r  = address_alias_get_person(first_alias,
					    &first_firstn,&first_lastn,
					    &first_address);

    if (second_alias)
	second_r = address_alias_get_person(second_alias,
					    &second_firstn,&second_lastn,
					    &second_address);
    
    /* 1) Person alias */

    if (first_r && !second_r)
	ret = -1;
    else if (second && !first_r)
	ret = 1;
    else if (first_r && second_r) {
	ret = compare_names(first_lastn,second_lastn);

	/*
	 * If equal on last name then compare on first name
	 */
	if (ret == 0) 
	    ret = compare_names(first_firstn, second_firstn);
	
    }


    /*  2) Address list */
    if (ret == 0) {
	const struct addr_list *first_list = 
	    first_alias ? address_alias_get_list(first_alias) : NULL;
	const struct addr_list *second_list = 
	    second_alias ? address_alias_get_list(second_alias) : NULL;

	int first_gcount  = 0;
	int second_gcount =  0;

	if (first_list)
	    first_gcount  = addr_list_group_count(first_list);
	if (second_list)
	    second_gcount = addr_list_group_count(second_list);

	if (first_gcount && !second_gcount)
	    ret = -1;
	else if (second_gcount && !first_gcount)
	    ret = 1;
	else if (first_gcount > 0&& second_gcount > 0) {
	    const struct string *first_phrase =
		addr_list_get_group(first_list,0);	    
	    const struct string *second_phrase =
		addr_list_get_group(second_list,0);
	    
	    ret = string_cmp(first_phrase, second_phrase, 0);
	}
    }

    /* 3) group list */
    if (ret == 0) {
	const struct string       *first_phrase  = NULL;
	const struct alias_vector *first_vector  = NULL;

	const struct string       *second_phrase = NULL;
	const struct alias_vector *second_vector = NULL;

	first_r = 0;
	second_r = 0;

	if (first_alias)
	    first_r  = address_alias_get_group(first_alias,
					       &first_phrase,&first_vector);
	
	if (second_alias)
	    second_r = address_alias_get_group(second_alias,
					       &second_phrase,&second_vector);
	
	if (first_r && !second_r)
	    ret = -1;
	else if (second && !first_r)
	    ret = 1;
	else if (first_r && second_r) 
	    ret = compare_names(first_phrase,second_phrase);       
    }

    /* Fallback */

    if (ret == 0) {
	const struct string * first_comment = 
	    first_alias ? address_alias_get_comment(first_alias) : NULL;
	const struct string * second_comment = 
	    second_alias ? address_alias_get_comment(second_alias) : NULL;

	ret = compare_names(first_comment, second_comment);
    }

    return ret;
}

static int s_compare_aliases(s1,s2)
     struct sort_data2 *s1;
     struct sort_data2 *s2;
{
    struct  aliasview_record  *first = give_alias_s(s1); 
    struct  aliasview_record  *second = give_alias_s(s2);

    /** compare two aliases according to the sortby value.
	
	Both are simple strcmp()'s on the alias or last_name
	components of the alias.
    **/
    
    int ret;
    
    /* If (only) one of the compares is a duplicate we want it
     * to go to the end of the list regardless of the sorting
     * method.
     */

    if (( aliasview_get_type(first) ^ aliasview_get_type(second)) & DUPLICATE) {
	if (aliasview_have_type_mask(first,DUPLICATE))
	    ret = 1;
	else			/* It must be second... */
	    ret = -1;
	return ret;
    }
    
    switch (abs(give_dt_sort_as_int(&alias_sortby))) {

    case ALIAS_SORT: {
	const struct string   * first_key   = aliasview_key(first);
	const struct string   * second_key  = aliasview_key(second);

	ret = string_cmp(first_key, second_key,0);
	if (0 == ret)
	    goto textual;

    }
	break;

    case NAME_SORT: 
	ret = name_compare(first,second);
	if (0 == ret)
	    goto textual;
	
	break;

	
    case TEXT_SORT: {
	struct alias_view i1;
	struct alias_view i2;
	
    textual:

	aliasview_give_index_number_s(s1,&i1);
	aliasview_give_index_number_s(s2,&i2);

	ret = i1.classnum - i2.classnum;
	if (0 == ret)
	    ret = i1.index- i2.index;
    }
	break;
	
    default:
	/* never get this! */
	ret = 0;
	break;
    }

    if (give_dt_sort_as_int(&alias_sortby) < 0)
	ret = -ret;
    
    return ret;
}

char *alias_sort_name(type)
     int type;
{
    /** return the name of the current sort option...
	type can be "FULL", "SHORT" or "PAD"
    **/
    int pad, abr;
	
    pad = (type == PAD);
    abr = (type == SHORT);
    
    if (give_dt_sort_as_int(&alias_sortby) < 0) {
	switch (- give_dt_sort_as_int(&alias_sortby)) {
	case ALIAS_SORT   : return(
				   pad?     "Reverse Alias Name      " :
				   abr?     "Reverse-Alias" :
				   "Reverse Alias Name");
	case NAME_SORT    : return(
				   pad?     "Reverse Full (Real) Name" :
				   abr?     "Reverse-Name" :
				   "Reverse Full (Real) Name");
	    case TEXT_SORT    : return(
				       pad?     "Reverse Text File       " :
				       abr?     "Reverse-Text" :
				       "Reverse Text File");
	}
    }
    else {
	switch (give_dt_sort_as_int(&alias_sortby)) {
	case ALIAS_SORT   : return(
				   pad?     "Alias Name              " :
				   abr?     "Alias" :
				       "Alias Name");
	case NAME_SORT    : return(
				   pad?     "Full (Real) Name        " :
				   abr?     "Name" :
				   "Full (Real) Name");
	case TEXT_SORT    : return(
				   pad?     "Text File               " :
				   abr?     "Text" :
				   "Text File");
	}
    }
    
    return("*UNKNOWN-SORT-PARAMETER*");
}

static void alias_old_current(iindex, aview)
     struct alias_view * iindex;
     struct AliasView *aview;
{
    /** Set current to the message that has "index" as it's 
	index number.  This is to track the current message
	when we resync... **/

    int i;
    int ac = get_alias_count(aview);
    
    DPRINT(Debug,4,
	   (&Debug, 
	    "alias-old-current(%d/%d)\n", 
	    iindex->classnum,iindex->index));
    
    for (i = 0; i < ac; i++) {
	struct alias_view I;

	aliasview_give_index_number(aview,i,&I);

	
	if (I.classnum == iindex->classnum &&
	    I.index    == iindex->index) {
	    int current = i+1;

	    set_alias_current(aview,current);
	    DPRINT(Debug,4,
		   (&Debug, "\tset current to %d!\n", current));
	    return;
	}
    }

    DPRINT(Debug,4,
	   (&Debug,
	    "\tcouldn't find current index.  Current left as %d\n",
	    get_alias_current(aview)));
    return;		/* can't be found.  Leave it alone, then */
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
