static char rcsid[] = "@(#)$Id: remote.c,v 2.4 2020/06/05 13:43:17 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmtls.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


DEBUG_VAR(Debug,__FILE__,"tls");

#ifdef REMOTE_MBX

/* Returns 1 if success */

int ra_wrap_tls(ra,tls_stream,proto_string,phase)
     struct remote_account * ra;
     union stream_types      tls_stream;
     const char            * proto_string;
     enum CAPA_phase *phase /* may be NULL */;
{
    char * M = NULL;
    int ret = 1;

    /* Message ????? */
    lib_transient(CATGETS(elm_msg_cat, TlsSet,
			  TlsConnectTo,
			  "%s connect to %s ..."),
		  proto_string,ra->host);

    add_stream_to_head(ra->stream,tls_stream);

    /* We are head on stream */  
    
    /* Do handshake */
    while (tls_not_connected == 
	   ss_TLS_state(ra->stream,0)) {
	WaitStreamFor(ra->stream,
		      SS_setup_act);
	M =  RemoveStreamError(ra->stream);
	if (M)
	    goto error_jump;
    }

    switch(ss_TLS_state(ra->stream,0)) {
	struct string * errmsg;
	struct string * peer_name;
	
    default: error_jump:

	if (M) {
	    /* Error message ? */
	    lib_error(FRM("%s"),
		      M);
	    free(M);
	    M = NULL;
	} else {
	    /* Error message ? */
	    lib_error(CATGETS(elm_msg_cat, TlsSet,
			      TlsConnectToFail,
			      "%s connect to %s ... Fail"),
		      proto_string,ra->host);
	}

	
	/* We fail hard now if connection is not OK ... */
	ret = 0;
	goto fail;
	
    case tls_connected:
	
	/* Message ????? */

	errmsg     = NULL;
	peer_name = NULL;

	switch(ss_TLS_verify(ra->stream,0,
			     &errmsg,&peer_name)) {
	    
	default:
	    if (errmsg)
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneErr,
				  "%s connect to %s ... Done (%S)"),
			  proto_string,ra->host,
			  errmsg);
	    else
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDone,
				  "%s connect to %s ... Done"),
			  proto_string,ra->host);
	    break;
	    
	case tls_not_verified:
	    
	    if (errmsg)
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneNotVerErr,
				  "%s connect to %s ... Done (not verified; %S)"),
			  proto_string,ra->host,
			  errmsg);
	    else
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneNotVer,
				  "%s connect to %s ... Done (not verified)"),
			  proto_string,ra->host);
	    break;

	case tls_peer_verified:
	    if (peer_name)
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneVerAs,
				  "%s connect to %s ... Done (verified as %S)"),
			  proto_string,ra->host,
			  peer_name);
	    else
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneVer,
				  "%s connect to %s ... Done (verified)"),
			  proto_string,ra->host);
	    break;
	    
	case tls_verify_failed:
	    if (errmsg)
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneVerFailErr,
				  "%s connect to %s ... Done (verify failed: %S)"),
			  proto_string,ra->host,
			  errmsg);
	    else
		lib_error(CATGETS(elm_msg_cat, TlsSet,
				  TlsConnectToDoneVerFail,
				  "%s connect to %s ... Done (verify failed)"),
			  proto_string,ra->host);
	    break;
	}

	if (errmsg)
	    free_string(&errmsg);
	if (peer_name)
	    free_string(&peer_name);
    
	if (sleepmsg)
	    wait_for_timeout(sleepmsg);
	
	if (phase) {
	    /* POP:   Need retry CAPA command
	       SMTP:  Need retry EHLO command
	       IMAP:  Need retry CAPA command

	     */
	    if (capa_prelogin == *phase)
		*phase = capa_prelogin_again;
	}
    }

 fail:
    return ret;
}

#if ANSI_C
provides_initial_TLS_ra_f provides_initial_TLS_ra;
#endif
enum tls_ra_status provides_initial_TLS_ra(ra,proto_name,
					   service_config,
					   sc_size)
     struct remote_account * ra;
     const char            * proto_name; /* for messages */
     struct SE_option      * service_config;
     size_t                  sc_size; 
{
    union stream_types T;   
    int bits;
    enum tls_ra_status ret = tls_ra_unsupported;
    enum tls_version tls =
	give_dt_enumerate_as_int(&default_tls_version);
    const char * tls_config = "default-tls-version";
    char * proto_string = NULL;

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:provides_initial_TLS_ra: sizeof (struct struct SE_option) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	goto fail;
    }

    if (!remote_account_OK (sizeof (*ra))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:provides_initial_TLS_ra: sizeof (struct remote_account) mismatch\n"));
	goto fail;
    }

   if (!tls_init(NULL)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:provides_initial_TLS_ra: Initialization failed\n"));
	ret = tls_ra_unsupported;   /* can try another library */
	goto fail;
    }

   StreamInfo(ra->stream,SS_ssf,&bits,NULL,NULL);
   if (bits > 0) {
       DPRINT(Debug,4,(&Debug,			    
		       "tls:provides_initial_TLS_ra: Already %d 'bits' encryption -- TLS already active?\n",
		       bits));
       
       ret = tls_ra_none;    /* not failure */
       goto fail;
   }
   
    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"provides_initial_TLS_ra",
		  "Bad option storage",0);
	}

	if (0 != (service_config->value->flags & TLS_tls)) {
	    tls        = service_config->value->v_tls;
	    tls_config = "tls:tls-version";
	} else if (0 != (service_config->value->flags & TLS_starttls)) {
	    tls        = service_config->value->v_starttls;
	    tls_config = "tls:starttls-version";
	}

	if (tls_none == tls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:provides_initial_TLS_ra: tls disabled\n"));
	    ret = tls_ra_none;    /* not failure */
	    goto fail;
	}	       
    } else {
	DPRINT(Debug,10,(&Debug,			    
			"tls:provides_initial_TLS_ra: no mail services config\n"));
    }
	

    DPRINT(Debug,4,(&Debug,			    
		"tls:provides_initial_TLS_ra: version %d",tls));
    switch(tls) {
    case tls_none: DPRINT(Debug,4,(&Debug, " tls_none")); break;
    case v_ssl:    DPRINT(Debug,4,(&Debug, " v_ssl"));    break;
    case v_tls:    DPRINT(Debug,4,(&Debug, " v_tls"));    break;
    case v_tls1:   DPRINT(Debug,4,(&Debug, " v_tls1"));   break;
    case v_tls1_1: DPRINT(Debug,4,(&Debug, " v_tls1_1")); break;
    case v_tls1_2: DPRINT(Debug,4,(&Debug, " v_tls1_2")); break;
    case NUM_tls_version: DPRINT(Debug,4,(&Debug, " NUM_tls_version")); break;
    }
    DPRINT(Debug,4,(&Debug,"\n"));
    
    if (!tls_version_supported(tls_config,tls)) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:provides_initial_TLS_ra: tls version not supported\n"));
	ret = tls_ra_unsupported;   /* can try another library */
	goto fail;   
    }



    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = tls_ra_unsupported;   /* can try another library */
	goto fail;
    }

    if (tls >= 0 && tls < NUM_tls_version) {
	proto_string = elm_message(FRM("%s(%s)"),
				   proto_name,
				   TLS_VERSION[tls]);
    } else {
	proto_string = elm_message(FRM("%s(TLS?)"),
				   proto_name);
    }

    if (!ra_wrap_tls(ra,T,proto_string,NULL)) {
	ret = tls_ra_failed;
	goto fail;
    }

    ret = tls_ra_done;
    DPRINT(Debug,10,(&Debug,			    
		     "tls:provides_initial_TLS_ra: %s done\n",
		     proto_string));


 fail:
    if (proto_string) {
	free(proto_string);
	proto_string = NULL;
    }
    DPRINT(Debug,10,(&Debug,			    
		     "tls:provides_initial_TLS_ra=%d\n",
		     ret));
    return ret;
}


#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
