static char rcsid[] = "@(#)$Id: pop.c,v 2.13 2022/02/12 14:00:06 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.13 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmtls.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

DEBUG_VAR(Debug,__FILE__,"tls");

#ifdef REMOTE_MBX

S_(pop_capa_handler pop_STLS_handler)
static int pop_STLS_handler P_((struct folder_info *folder,
				char *capa,
				char *capa_args,
				size_t fi_size,
				struct pop_callbacks *commands,
				size_t cb_size,
				struct SE_option   *service_config,
				size_t sc_size,
				enum CAPA_phase *phase));
static int pop_STLS_handler(folder,capa,capa_args,fi_size,commands,cb_size,
			    service_config,sc_size,phase)
     struct folder_info *folder;
     char *capa;
     char *capa_args;
     size_t fi_size;
     struct pop_callbacks *commands;
     size_t cb_size;
     struct SE_option   *service_config;
     size_t sc_size;
     enum CAPA_phase *phase;
{
    union stream_types T;   
    int bits;
    char * proto_text = NULL;
    
    int ret = 1;
    enum tls_version tls =
	give_dt_enumerate_as_int(&default_tls_version);
    const char * tls_config = "default-tls-version";

    if (! StreamOK(sizeof (struct stream_type))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct stream_type) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (fi_size != sizeof (*folder)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct folder_info) = %d != %d\n",
			sizeof (*folder),fi_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (cb_size != sizeof (*commands)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct pop_callbacks) = %d != %d\n",
			sizeof (*commands),cb_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (sc_size != sizeof (*service_config)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct struct SE_option) = %d != %d\n",
			sizeof (*service_config),sc_size));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }


    if (folder->folder_type != &pop_mbx ||
	NULL == folder -> p) {
	DPRINT(Debug,1,(&Debug,			    
			 "tls:pop_STLS_handler: folder not pop mailbox?\n"));
	goto fail;
    }

    if (!remote_account_OK (sizeof (folder -> p->a.pop_mbx.C))) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: sizeof (struct remote_account) mismatch\n"));
	
	/* do nothing  
	   -- not need to return failure 
	   -- just disable ourself
	*/
	goto fail;
    }

    if (!tls_init(NULL)) {
	DPRINT(Debug,1,(&Debug,			    
			"tls:pop_STLS_handler: Initialization failed\n"));
	goto fail;
    }

    StreamInfo(folder -> p->a.pop_mbx.C.stream,SS_ssf,&bits,NULL,NULL);
    if (bits > 0) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:pop_STLS_handler: Already %d 'bits' encryption -- TLS already active?\n",
			bits));
	goto fail;
    }

    if (service_config) {
	if (service_config->type != &tls_options ||
	    !service_config->value) {
	    panic("TLS PANIC",__FILE__,__LINE__,"pop_STLS_handler",
		  "Bad option storage",0);
	}

	if (0 != (service_config->value->flags & TLS_starttls)) {
	    tls        = service_config->value->v_starttls;
	    tls_config = "tls:starttls-version";

	} else if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:pop_STLS_handler: starttls (STLS) disabled by use-tls\n"));
	    goto fail;
	    	    
	} else if (0 != (service_config->value->flags & TLS_tls)) {
	    tls        = service_config->value->v_tls;
	    tls_config = "tls:tls-version";
	}

	if (tls_none == tls) {
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:pop_STLS_handler: tls disabled\n"));
	    goto fail;
	}	    
    } else {
	DPRINT(Debug,10,(&Debug,			    
			 "tls:pop_STLS_handler: no mail services config\n"));

	if (! dt_flag_is_set(&use_tls,use_tls_starttls)) {
	    
	    DPRINT(Debug,4,(&Debug,			    
			    "tls:pop_STLS_handler: starttls (STLS) disabled by use-tls\n"));
	    goto fail;	    	    
	} 	
    }

    DPRINT(Debug,4,(&Debug,			    
		    "tls:pop_STLS_handler: version %d",tls));
    switch(tls) {
    case tls_none: DPRINT(Debug,4,(&Debug, " tls_none")); break;
    case v_ssl:    DPRINT(Debug,4,(&Debug, " v_ssl"));    break;
    case v_tls:    DPRINT(Debug,4,(&Debug, " v_tls"));    break;
    case v_tls1:   DPRINT(Debug,4,(&Debug, " v_tls1"));   break;
    case v_tls1_1: DPRINT(Debug,4,(&Debug, " v_tls1_1")); break;
    case v_tls1_2: DPRINT(Debug,4,(&Debug, " v_tls1_2")); break;
    case NUM_tls_version: DPRINT(Debug,4,(&Debug, " NUM_tls_version")); break;
    }
    DPRINT(Debug,4,(&Debug,"\n"));

    if (!tls_version_supported(tls_config,tls)) {
	DPRINT(Debug,4,(&Debug,			    
			"tls:pop_STLS_handler: tls version not supported\n"));
	goto fail;            /* Just fail ... */		
    }

    if (!commands->push_command(folder,"STLS",1)) {
	commands->clear_command(folder);
	goto fail;            /* Just fail ... */
    }
    if (!commands->command_ok(folder)) {
	commands->clear_command(folder);
	goto fail;            /* Just fail .... */
    }

    commands->clear_command(folder);

    /* After that we need need return failure if something
       goes wrong because connection is messed beyond repair
     */

    T = create_TLS_stream(tls);
    if (T.TYPE == NULL) {
	/* Error message ? */
	ret = 0;
	goto fail;
    }

    if (tls >= 0 && tls < NUM_tls_version) {
        proto_text = elm_message(FRM("POP/%s"),TLS_VERSION[tls]);
    } else {
	proto_text = safe_strdup("POP/TLS?");
    }

    
    if (!ra_wrap_tls(& (folder -> p->a.pop_mbx.C),
		     T,
		     proto_text,
		     phase)) {
	
	ret = 0;
	goto fail;
    }
		     
 fail:
    if (proto_text) {
	free(proto_text);
	proto_text = NULL;
    }

    DPRINT(Debug,10,(&Debug,			    
		     "tls:pop_STLS_handler=%d\n",
		     ret));
    
    return ret;
}

static struct provides_shared_POP_CAPA LIST[] = {
    { "STLS",  1,  pop_STLS_handler },

};

#ifdef ANSI_C
provides_shared_POP_CAPA_f provides_shared_POP_CAPA;
#endif
struct provides_shared_POP_CAPA * provides_shared_POP_CAPA(count,s_size)
     int *count; 
     size_t *s_size;
{
    *s_size = sizeof (LIST[0]);

    *count = (sizeof LIST) / *s_size;

    return &(LIST[0]);
}

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
