static char rcsid[] = "@(#)$Id: shared_smtp.c,v 2.6 2018/12/01 08:19:45 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmsmtp.h"
#include "shared_imp.h"

DEBUG_VAR(Debug,__FILE__,"dl");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

static struct shared_SMTP_EXT {
    char                * ext;
    int                   priority;
    struct ImpInfo *      imp_idx;

    smtp_ext_handler    * ext_handler;

} * shared_smtp_exts                UNUSED_VAROK = NULL;
static int shared_smtp_ext_count    UNUSED_VAROK = 0;

#define SHARED_SMTP_magic	0xF204

struct sl_smtp_data {
    uint16        magic;
};

S_(sl_reg_functions sl_reg_smtp)
static int sl_reg_smtp P_((struct ImpInfo *i,
			      int reg_idx));
static int sl_reg_smtp(i,reg_idx)
     struct ImpInfo *i;
     int reg_idx;
{
    /* union hack to avoid warnings about casting
     * between pointer-to-object and pointer-to-function
     */
    
    int res = 0;

     union F1 {
	 void                        * ptr;
	 provides_shared_SMTP_EXT_f * f1;
     } f1;

     f1.ptr = dlsym(i->handle, "provides_shared_SMTP_EXT");

     if (!f1.f1) {
	 DPRINT(Debug,7,(&Debug, " ... NO provides_shared_SMTP_EXT\n"));
     }

#ifdef REMOTE_MBX
     if (f1.f1) {
	 int count,x;
	 size_t   s_res1;

	 struct provides_shared_SMTP_EXT * res1 = f1.f1(&count, &s_res1);
							 
	 if (s_res1 != sizeof (*res1)) {
	     DPRINT(Debug,1,(&Debug,
			     "... struct provides_shared_SMTP_EXT mismatch: %d should be %d\n",
			     s_res1,sizeof (*res1)));
	 } else {
	     shared_smtp_exts =
		 safe_array_realloc(shared_smtp_exts,
				    (shared_smtp_ext_count + count),
				    sizeof (shared_smtp_exts[0]));

	     DPRINT(Debug,7,(&Debug," ... provides_shared_SMTP_EXT:  (shared_smtp_exts) count %d\n",
			     count));

	     res = 1;

	    for (x = 0; x < count; x++) {
		shared_smtp_exts[shared_smtp_ext_count
				 +x].ext = res1[x].ext;
		shared_smtp_exts[shared_smtp_ext_count
				 +x].priority = res1[x].priority;
		shared_smtp_exts[shared_smtp_ext_count
				 +x].ext_handler = res1[x].ext_handler;
		shared_smtp_exts[shared_smtp_ext_count
				 +x].imp_idx = i;
		DPRINT(Debug,8,(&Debug,
				"library %s provides SMTP %s\n", 
				i->shname,
				res1[x].ext));
	    }
	    shared_smtp_ext_count += count;
	 }
     }
#endif


    i->regs[reg_idx].valid   = res;
    
    DPRINT(Debug,7,(&Debug, 
		    " sl_reg_smtp:  [%p]->regs[%d].valid = %d\n",
		    i,reg_idx,res));

    return res;
}

S_(sl_zero_reg_list sl_zero_smtp)
static void sl_zero_smtp P_((struct dt_shared_info *var,
				struct reg_list *r));
static void sl_zero_smtp(var,r)
     struct dt_shared_info *var;
     struct reg_list *r;
{
    r->var     = var;
    r->valid   = 0;
    r->r.smtp  = safe_malloc(sizeof (*r->r.smtp));   /* never freed ... */
    r->r.smtp->magic = SHARED_SMTP_magic;
}

S_(sl_unreg_functions sl_unreg_smtp)
static void sl_unreg_smtp P_((struct ImpInfo *i, int reg_idx));
static void sl_unreg_smtp(i,reg_idx)
     struct ImpInfo *i; 
     int reg_idx;
{
    struct reg_list *r = & (i->regs[reg_idx] );
    r->valid   = 0;

}

static struct shared_loader smtp_loader = {
    SHARED_LOADER_magic,
    sl_reg_smtp,
    sl_zero_smtp,
    sl_unreg_smtp
};

#include "save_opts.h"

struct dt_shared_info use_shared_smtp = {
    &smtp_loader            /* loader */,
    0,                       
    NULL, 0,

    NULL
};

/* Hooking */
#if ANSI_C
init_library_REG_f init_library_REG;
#endif
void init_library_REG() {

    static int init_done       = 0; 

    if (init_done) {
	DPRINT(Debug,7,(&Debug,"init_library_REG: (smtp) Already done\n"));
	return;
    }

    init_done       = 1;

    /* Just hidded hook */

    register_hidden_library(&use_shared_connect,&use_shared_smtp);
    register_list(&use_shared_smtp);

    DPRINT(Debug,7,(&Debug,"init_library_REG: (smtp) Done\n"));

}

#ifdef REMOTE_MBX


struct SMTP_ext_libs {
    char                 * ext;
    char                 * ext_args;
    struct ImpInfo       * imp_idx;
    int                    priority;
    smtp_ext_handler     * ext_handler;
};

void probe_smtp_ext_lib(smtp_ext_libs,smtp_ext_libcount,ext,ext_args)
     struct SMTP_ext_libs ** smtp_ext_libs;
     int                   * smtp_ext_libcount;
     const char *ext;
     const char *ext_args;
{
    int i;

    load_shared_libs1(&use_shared_smtp);  

    for (i = 0; i < shared_smtp_ext_count; i++) {
	/* Case insensitive? */

	/* Also check that library is currently loaded ... */
	if (!verify_shared_index(shared_smtp_exts[i].imp_idx)) {
	    DPRINT(Debug,8,(&Debug,"shared_smtp_exts[%d] (%s) unloaded?\n",
			    i,
			    shared_smtp_exts[i].ext ? 
			    shared_smtp_exts[i].ext : "n/a"));
	    continue;
	}

	if ( 0 == istrcmp(shared_smtp_exts[i].ext, ext))
	    break;	
    }
    if (i >= shared_smtp_ext_count)
	return;          /* Not found */
	
    DPRINT(Debug,8,(&Debug,"shared_smtp_exts[%d] is %s\n",i,ext));

    *smtp_ext_libs = safe_array_realloc(*smtp_ext_libs,
					(*smtp_ext_libcount +1),
					sizeof ((*smtp_ext_libs)[0]));
    
    (*smtp_ext_libs)[*smtp_ext_libcount].ext       = safe_strdup(ext);
    
    (*smtp_ext_libs)[*smtp_ext_libcount].ext_args =
	ext_args ? safe_strdup(ext_args) : NULL;

    (*smtp_ext_libs)[*smtp_ext_libcount].imp_idx   = 
	shared_smtp_exts[i].imp_idx;
    (*smtp_ext_libs)[*smtp_ext_libcount].priority  = 
	shared_smtp_exts[i].priority;
    (*smtp_ext_libs)[*smtp_ext_libcount].ext_handler =
	shared_smtp_exts[i].ext_handler;
    
    DPRINT(Debug,7,(&Debug,
		    "** Using %s library for SMTP extension %s\n",
		    shared_smtp_exts[*smtp_ext_libcount].imp_idx->tag,
		    (*smtp_ext_libs)[*smtp_ext_libcount].ext));

    (*smtp_ext_libcount)++;		  
}    

static void free_only_smtp_ext_libs P_((struct SMTP_ext_libs * *smtp_ext_libs,
					int                  * smtp_ext_libcount));

static void free_only_smtp_ext_libs(smtp_ext_libs,smtp_ext_libcount)
     struct SMTP_ext_libs * *smtp_ext_libs;
     int                  * smtp_ext_libcount;
{
    if (*smtp_ext_libs) {
	int i;

	for (i = 0; i < *smtp_ext_libcount; i++) {
	    if ((*smtp_ext_libs)[i].ext) {
		free((*smtp_ext_libs)[i].ext);
		(*smtp_ext_libs)[i].ext = NULL;
	    }
	}
	free(*smtp_ext_libs);
	*smtp_ext_libs     = NULL;
	*smtp_ext_libcount = 0;
    }
}

static int smtp_ext_compare P_((const void *A, const void *B));
static int smtp_ext_compare(A,B)
     const void *A; 
     const void *B;
{
    const struct SMTP_ext_libs *A1 = A;
    const struct SMTP_ext_libs *B1 = B;

    if (A1->priority < B1->priority)
	return -1;
    if (A1->priority > B1->priority)
	return 1;
    return 0;
}

static enum CAPA_phase pri_to_phase P_((int pri));
static enum CAPA_phase pri_to_phase(pri)
     int pri;
{
    
    if (pri < 10)
	return capa_prelogin;
    if (pri < 20)
	return capa_do_login;
    return capa_logged;
}

int handle_smtp_ext_libs(mailer_info,smtp_ext_libs,smtp_ext_libcount,phase,
			 commands)
     struct smtp_info *mailer_info;
     struct SMTP_ext_libs * *smtp_ext_libs;
     int                  * smtp_ext_libcount;
     enum CAPA_phase      *  phase;
     struct smtp_callbacks *commands;
{
    int ret = 1;
    struct remote_account * A;
    enum CAPA_phase  old_phase = *phase;

    if (SMTP_mailer_info_magic != mailer_info->magic)
	panic("MAILER PANIC",__FILE__,__LINE__,"handle_smtp_ext_libs",
	      "Bad magic number (mailer_info)",0);

    A = &(mailer_info->RA);

    if (REMOTE_ACCOUNT_magic != A->magic) {
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "handle_smtp_ext_libs",
	      "Bad magic (remote_account)",0);
    }

    if (smtp_ext_libs) {
	int i;

	qsort(*smtp_ext_libs,*smtp_ext_libcount,
	      sizeof ((*smtp_ext_libs)[0]),
	      smtp_ext_compare);

	for (i = 0; i < *smtp_ext_libcount; i++) {
	    int j;
	    struct SE_option       *config = NULL;  
	    struct SE_option_type  *T      = NULL;  

	    if (*phase != pri_to_phase((*smtp_ext_libs)[i].priority))
		continue;

	    DPRINT(Debug,8,(&Debug,
			    "[%d] handling %s with %s library\n",
			    i,(*smtp_ext_libs)[i].ext,
			    shared_smtp_exts[i].imp_idx->tag));

	    for (j = 0; j < shared_SE_option_type_count; j++) {
		if (shared_SE_option_types[j].imp_idx ==
		    shared_smtp_exts[i].imp_idx) {
		    T = shared_SE_option_types[j].T;
		    DPRINT(Debug,8,(&Debug,
				    "  ... have service option type %p\n",
				    T));

		    if (SE_option_t_magic != T->magic) 
			panic("CONNECTION PANIC",__FILE__,__LINE__,
			      "handle_smtp_ext_libs",
			      "Bad magic (SE_option_type)",0);
		    
		}
	    }
	    
	    if (A->service) {
		if (SERVICE_ENTRY_magic != A->service->magic)
		    panic("CONNECTION PANIC",__FILE__,__LINE__,
			  "handle_smtp_ext_libs",
			  "Bad magic (service_entry)",0);

		if (T) {   
  
		    for (j = 0; j < A->service->option_count; j++) {
			if (A->service->option_list[j].type == T) {
			    config = & (A->service->option_list[j]);

			    DPRINT(Debug,8,(&Debug,
					    "  ... have service config %p (%s)\n",
					    config,
					    config->prefix ? config->prefix : "NONE"));
			}
		    }		
		}
	    }

	    if (!(*smtp_ext_libs)[i].
		ext_handler(mailer_info,
			    (*smtp_ext_libs)[i].ext,
			    (*smtp_ext_libs)[i].ext_args,
			    sizeof (*mailer_info),
			    commands,
			    sizeof (*commands),
			    config,
			    sizeof (*config),
			    phase)) {
		ret = 0;
		goto fail;		    
	    }

	    if (*phase != old_phase) {
		DPRINT(Debug,8,(&Debug," ... done (phase changed)\n"));
		break;
	    }
	}

	
    fail:
	free_only_smtp_ext_libs(smtp_ext_libs,smtp_ext_libcount);
    }

    return ret;
}


#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
