case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    regarg=
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    regarg="-A \"$source_dir/$subdir/\""
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

# libelmme-smtp.so my be loaded with program, which do not have
# linked with libelmme-mailer.so or libelmme-addr.so. On that case 
# loading failed with unresolved symbols. Therefore we link 
# libelmme-smtp.so with libelmme-mailer.so and libelmme-addr.so. If loading 
# program is linked with libelmme-smtp.so, that do not cause that 
# libelmme-mailer.so is linked twice on run time.
#
libxs="../../shlib/libelmme-mailer.so ../../shlib/libelmme-addr.so"

# If it is not possible to resolve mail program symbols from
# dynamic library, link libelmme-smtp.so with libelmme-base.so

if $test $d_dynamic_main = "$define" ; then
	   : 
else
	libxs="$libxs ../../shlib/libelmme-base.so"
fi

echo "Extracting shared_libs/smtp/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.13 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
#       or Kari Hurtta <elm@elmme-mailer.org>
#
#
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-smtp.so$d_shared_rev
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
LIB		=	\$(ELM_ROOT)//$lib
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
LIBXS           =       $libxs
$vpathdef
REGARG		=	$regarg
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

A=
if $test "$soname_include_path" = y ; then
	A="$shlib/"
fi

cat >>Makefile <<SUBSTITUTE
SONAME          = ${soname_opt}${A}libelmme-smtp.so$d_shared_rev
SUBSTITUTE

$cat >>Makefile <<'!NO!SUBS!'
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) -I$(IHDR2) \
 -I$(INCLDIR2) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/shared_libs/include
INCLDIR2	=	$(SRCROOT)/hdrs
IHDR		=	../include
IHDR2		=	../../hdrs
OBJS            =       smtp.o shared_smtp.o
REG             =       ../../bin/elmregister -M smtp  $(REGARG)

all:	Makefile libsmtp.a ../../shlib/libelmme-smtp.so 
install_s: all $(INSTLIB) $(LIB)/elmrc-smtp-info

uninstall_s:
	$(REG) rm $(INSTLIB) $(LIB)/elmrc-smtp-info
	
clean: 
	rm -f $(OBJS) ../../shlib/libelmme-smtp.so libsmtp.a

.PRECIOUS: $(IHDR)/elmshared.h $(IHDR2)/elm_defs.h $(IHDR2)/defs_major.h

$(IHDR)/elmshared.h: $(IHDR2)/elm_defs.h $(INCLDIR2)/patchlevel.h \
 $(INCLDIR)/shared.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/elm_defs.h: $(IHDR2)/defs_major.h $(INCLDIR2)/elm_nl_types.h \
 $(INCLDIR2)/hdrs/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR2)/defs_major.h: ../../config.h $(IHDR2)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

Makefile: Makefile.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

../../config.sh config.res:
	@echo "You must run 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

elmsmtp.h: $(INCLDIR)/elmshared.h  $(INCLDIR2)/mailer_imp.h \
 $(INCLDIR2)/connection_imp.h $(INCLDIR2)/ss_imp.h $(INCLDIR2)/mime.h \
 $(INCLDIR2)/mailer_imp.h  $(INCLDIR2)/addrlib.h $(INCLDIR)/shared_smtp.h \
  $(INCLDIR2)/s_smtp.h $(INCLDIR2)/schedule_time.h
	cmp $(SRC)/$@ $@ 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

smtp.o: elmsmtp.h $(INCLDIR2)/rc_imp.h $(INCLDIR2)/save_opts.h \
 $(INCLDIR2)/s_elm.h

sharedsmtp.o: elmsmtp.h $(INCLDIR2)/shared_imp.h $(INCLDIR2)/save_opts.h

libsmtp.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

../../shlib/libelmme-smtp.so: $(OBJS) $(LIBXS)
	$(CC) $(LFLAGS) $(SONAME) -o $@ $(OBJS) $(LIBXS)

$(INSTLIB): ../../shlib/libelmme-smtp.so
	$(REG) copy -m 644 $? $@

$(LIB)/elmrc-smtp-info: elmrc-smtp-info
	$(REG) copy -m 444 $? $@

!NO!SUBS!


	for i in $libxs
	do
		y="`echo $i|$sed 's%^../../%%'`"
cat >>Makefile <<!SUBS!
$i:
	cd ../..; \$(MAKE) \$(MJ) \$(MFLAGS) $y
!SUBS!
	done
