/* $Id: elmresolv.h,v 1.8 2018/12/21 11:21:42 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.8 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elmshared.h"
#include "s_resolv.h"

#include "schedule_time.h"
#include "connection_imp.h"

#include "resolvconf.h"

#ifdef I_NETINET_IN
#include <netinet/in.h>
#endif

#ifdef I_ARPA_INET
#include <arpa/inet.h>
#endif

#include <arpa/nameser.h>
#include <resolv.h>

#ifndef _res
extern struct state _res;
#endif

#ifdef I_NETDB
#include <netdb.h>
#endif
#ifndef h_errno
extern int h_errno;
#endif

/* NS_PACKETSZ is 512 -- default UDP packet size */

#define RESOLV_BUFSIZE  1024
extern const size_t MAX_resolv_bufsize;


enum looking_up {
    l_up_none = 0,
    l_up_printed,
    l_up_error,
    l_up_truncated_retry,
    l_up_stalled   /* timeout */
};

typedef int have_qm_f P_((void));
typedef struct resolv_cache * lookup_resolv_cache_qm_f
   P_((struct resolv_cache             * record,
       const char                      * name,
       const struct schedule_timelimit * now,
       const ns_type                     q_type,
       const int                         is_search,
       enum looking_up                 * looking_up,
       char                           ** search_name,
       int                             * have_error,
       int                             * other,
       struct cancel_data             ** cancel_p));

extern enum query_mode_val {
    qm_blocking, qm_non_blocking,
    NUM_query_mode
} query_mode;



#define RESOLV_QUERY_MODE_magic		0xF91D

extern struct resolv_query_mode {
    unsigned short magic;                /* RESOLV_QUERY_MODE_magic */

    have_qm_f                 * have_query_mode;
    lookup_resolv_cache_qm_f  * lookup_resolv_cache;
} blocked_query_mode;

extern const struct resolv_query_mode * query_modes [NUM_query_mode];

extern void free_non_blocking_qm P_((void));
extern void free_resolv_config P_((void));

extern const char * QUERY_MODE[NUM_query_mode];

E_(option_func query_mode_func)
extern int query_mode_func P_((char **value, int enter,
			       int lineno, const char *filename,
			       int read_flags /* READ_FLAG_IGNORE_MISSING */
			       ));


#ifdef ANSI_C
struct resolv_cache ;            /* Needed for prototype */
#endif


/* Returns real cache entry, increments refcount */
extern struct resolv_cache * fill_resolv_cache P_((struct resolv_cache             * answer,
						   ns_msg                          * parsed_answer,
						   const struct schedule_timelimit * now,
						   char                           ** search_name,
						   enum looking_up                 * looking_up,
						   int                             * have_error));

/* Decrements refcount */
extern void free_resolv_cache P_((struct resolv_cache **ptr));

/* Increments refcount */
extern void inc_resolv_cache_refcount P_((struct resolv_cache *cache));

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
