/* $Id: shared.h,v 2.19 2021/04/14 17:57:44 hurtta Exp $ */

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.19 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *       or Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#ifndef SHARED_H
#define SHARED_H 1

/* This is included on both elmshared.h and shared_imp.h */

/* --------------------------------------------------------------- */

#include <dlfcn.h>

#ifdef ANSI_C
struct SE_option;
struct  map_info;
struct  charset_type;
struct smtp_info;
struct smtp_callbacks;
struct remote_account;
struct rc_save_info_rec;
struct service_type;
struct service_entry_addr;
struct service_entry_name;
struct schedule_timelimit;
#endif

typedef int pop_capa_handler P_((struct folder_info *folder,
				 char *capa,
				 char *capa_args,
				 size_t fi_size,
				 struct pop_callbacks *commands,
				 size_t cb_size,
				 struct SE_option   *service_config,
				 size_t sc_size,
				 enum CAPA_phase *phase));

typedef int imap_capa_handler P_((struct connection_cache *con,
				  char *capa,
				  size_t con_size,
				  struct imap_callbacks *commands,
				  size_t cb_size,
				  struct SE_option   *service_config,
				  size_t sc_size,
				  enum CAPA_phase *phase));

typedef int smtp_ext_handler P_((struct smtp_info *mailer_info,
				  char * ext,
				 char * ext_args,
				  size_t mailer_info_size,
				  struct smtp_callbacks *cb, 
				  size_t cb_size,
				  struct SE_option   *service_config,
				  size_t sc_size,
				  enum CAPA_phase *phase));
				  
typedef struct folder_type ** 
provides_shared_FT_f P_((int *count, size_t *s_size));

typedef struct provides_shared_POP_CAPA {
    char                * capa;
    int                   priority;
    pop_capa_handler     *capa_handler;
}  *  provides_shared_POP_CAPA_f P_((int *count, size_t *s_size));

typedef struct provides_shared_IMAP_CAPA {
    char                * capa;
    int                   priority;
    imap_capa_handler     *capa_handler;
}  *  provides_shared_IMAP_CAPA_f P_((int *count, size_t *s_size));

typedef struct provides_shared_SMTP_EXT {
    char                * ext;
    int                   priority;
    smtp_ext_handler    * ext_handler;	
} *  provides_shared_SMTP_EXT_f P_((int *count, size_t *s_size));

typedef struct SE_option_type ** 
provides_shared_SEOT_f  P_((int *count, size_t *s_size));

typedef struct rc_save_info_rec
* provides_RC_options_f P_((size_t *count, size_t *s_size));

typedef void RC_post_init_f P_((int *errors, int flag,
				const char * tag));

typedef void RC_change_config_f  P_((int *errors, int flag,
				     const char * tag,
				     struct rc_save_info_rec * rc_options,
				     size_t  rc_option_count,
				     size_t rec_size,
				     const char * shared_tag));

typedef struct dt_enum_shared * RC_fill_enum_values_f
   P_((struct dt_enumerate_info *ptr,
       const char *tag,
       int used_start_value,
       size_t dt_enumerate_info_size,
       size_t dt_enum_shared_size));

typedef enum verify_domain_status {
    vd_status_no_routine = -3   /* no verify domain routine     */,
    vd_status_fallback   = -2   /* call default routine instead */,
    vd_status_failure    = -1   /* can't verify                 */,
    vd_status_not_found  = 0    /* domain not found             */,
    vd_status_verified   = 1    /* domain found                 */,
    vd_domain_no_mail    = 2    /* domain accept no mail        */,
    vd_domain_bad_syntax = 3    /* domain have bad syntax       */
} verify_mail_domain_f P_((const char *domain,char **rewrite,
			   int translated_value  /* -1 if not share specific */,
			   const struct dt_enum_shared * is_shared_value,
			   size_t dt_enum_shared_size,
			   const struct schedule_timelimit * now,
			   size_t                            schedule_timelimit_size,
			   struct schedule_timelimit       * valid_until,
			   struct cancel_data             ** cancel_p 
			   ));
			
typedef enum address_lookup_status {
    al_status_no_routine = -3   /* no lookup name routine       */, 
    al_status_fallback   = -2   /* call default routine instead */,
    al_status_failed     = -1   /* can't lookup                 */,
    al_status_not_found  = 0    /* name not found               */,  
    al_status_done       = 1    /* name found                   */,
    al_status_bad_syntax = 3    /* name have bad syntax         */
} lookup_service_addresses_f P_((const char                      * hostname,
				 char                           ** rewrite,
				 int                               translated_value  
				 /* -1 if not share specific */,
				 const struct dt_enum_shared     * is_shared_value,
				 size_t                            dt_enum_shared_size,
				 struct service_entry_addr      ** addr_list,
				 int                             * addr_count,
				 size_t                            service_entry_addr_size,
				 struct service_entry_name      ** aliases_list,
				 int                             * aliases_count,
				 size_t                            service_entry_name_size,
				 const struct service_type       * service,
				 const struct schedule_timelimit * now,
				 size_t                            schedule_timelimit_size,
				 const struct schedule_timelimit * default_valid_until /* for static hosts lookup */,
				 int                             * was_error_p,
				 struct cancel_data             ** cancel_p 
				 ));

typedef enum domname_check_status {
    dc_status_no_routine = -3   /* no lookup name routine       */,
    dc_status_query_blacklisted = -2  /* lookup blacklisted, not dns name */,
    dc_status_failure    = -1   /* can't lookup                 */,
    dc_status_not_found  = 0    /* name not found               */,  
    dc_status_have_name  = 1    /* name found                   */,
    dc_status_bad_syntax = 3    /* name have bad syntax         */
} check_domain_name_f P_((const char                      * domainname,
			  char                           ** rewrite,
			  const struct schedule_timelimit * now,
			  size_t                            schedule_timelimit_size,
			  const struct schedule_timelimit * default_valid_until
			  /* for other data */,
			  struct schedule_timelimit       * valid_until,
			  int                             * was_error_p,
			  struct cancel_data             ** cancel_p));

typedef void wants_rand_bits_f P_((const char *buf, int size, 
				   int entropy_bits));

typedef enum tls_ra_status {
    tls_ra_unsupported = -2 /* initial tls unsupported */,
    tls_ra_failed = -1    /* initial tls negation failed */,
    tls_ra_none   = 0     /* initial tls disabled        */,
    tls_ra_done   = 1     /* initial tls done            */
} provides_initial_TLS_ra_f P_((struct remote_account * ra,
				const char            * proto_name, /* for messages */
				struct SE_option      * service_config,
				size_t                  sc_size         ));

typedef int CS_auto_charset_f P_((const char *name,
				  struct  charset_type **type,
				  struct  map_info **map));
typedef struct charset_type  * CS_charset_type_f P_((const char *name));


typedef struct mailer_config *
provides_shared_MCF_f P_((int *count, size_t *s_size, size_t *opt_size,
			  size_t *s_send_state_size, size_t *s_cancel_size,
			  size_t *s_mailer_info_size, 
			  size_t *s_env_from_size));

typedef void init_library_REG_f P_((void));
typedef void free_shared_cache_f P_((void));

/* Notify interface change */
typedef void notify_if_change_f P_((void));  

#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
