case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH	= "
    regarg=
    XXsrc="."
    XXsrcroot="../../"
    ;;
*)
    vpathdef="VPATH	=	$source_dir/$subdir"
    regarg="-A \"$source_dir/$subdir/\""
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

echo "Extracting shared_libs/iconv/Makefile (with variable substitutions)"
$cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.11 2018/08/01 09:36:26 hurtta Exp $
#
#  Makefile for the ELM (ME+) mail program.
#
#  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
#  	   	   (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
#       or Kari Hurtta <elm@elmme-mailer.org>
#
#
INSTLIB		= \$(ELM_ROOT)//$shlib/libelmme-iconv.so$d_shared_rev
AR		=	$ar
CC		=	$cc
CCFLAGS		=	$ccflags $picflag $xencf
LFLAGS		=	$ldflags $backtrace_opt $xenlf
CP		=	$cp
RM              =       $rm -f
MV              =       $mv
LIB		=	\$(ELM_ROOT)//$lib
OPTIMIZE	=	$optimize
RANLIB		=	$ranlib
TOUCH           =       $touch
CHMOD           =       $chmod
$vpathdef
REGARG		=	$regarg
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot
!GROK!THIS!

A=
if $test "$soname_include_path" = y ; then
	A="$shlib/"
fi

cat >>Makefile <<SUBSTITUTE
SONAME          = ${soname_opt}${A}libelmme-iconv.so$d_shared_rev
SUBSTITUTE

if $test "$iconv_lib_dir" != ""; then
    $cat >>Makefile <<EOS
LIBDIRLIST      =  -L$iconv_lib_dir $rpath_opt$iconv_lib_dir
EOS
else
    cat >>Makefile <<'EOX'
LIBDIRLIST      =
EOX
fi

if $test "$iconv_include_dir" != "" ; then
    $cat >>Makefile <<EOS
INCDIRLIST      = -I$iconv_include_dir
EOS
else
    $cat >>Makefile <<'EOX'
INCDIRLIST      =
EOX
fi

if $test "$iconv_link" != "" ; then
    $cat >>Makefile <<EOS
ICONV_LINK	= 	-l$iconv_link
EOS
else
    $cat >>Makefile <<'EOX'
ICONV_LINK	=
EOX
fi

$cat >>Makefile <<'!NO!SUBS!'
CFLAGS		=	-I$(IHDR) -I$(INCLDIR) -I$(IHDR2) -I$(INCLDIR2) \
 $(INCDIRLIST) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	$(SRCROOT)/shared_libs/include
INCLDIR2	=	$(SRCROOT)/hdrs
IHDR		=	../include
IHDR2		=	../../hdrs
OBJS            =       iconv.o
REG             =       ../../bin/elmregister -M iconv $(REGARG)

all:	Makefile libiconv.a ../../shlib/libelmme-iconv.so
install_s: all $(INSTLIB) $(LIB)/elmrc-iconv-info

uninstall_s:
	$(REG) rm $(INSTLIB) $(LIB)/elmrc-iconv-info

clean: 
	rm -f $(OBJS) ../../shlib/libelmme-iconv.so libiconv.a

.PRECIOUS: $(IHDR)/elmshared.h $(IHDR2)/elm_defs.h \
 $(IHDR2)/defs_major.h elmiconv.h

$(IHDR)/elmshared.h: $(IHDR2)/elm_defs.h $(INCLDIR2)/patchlevel.h \
 $(INCLDIR)/shared.h 
	-$(CHMOD) -f u+w $@
	$(TOUCH) $@

$(IHDR2)/elm_defs.h: $(IHDR2)/defs_major.h $(INCLDIR2)/elm_nl_types.h \
 $(INCLDIR2)/hdrs/elmlib.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@

$(IHDR2)/defs_major.h: ../../config.h $(IHDR2)/sysdefs.h 
			-$(CHMOD) -f u+w $@
			$(TOUCH) $@


Makefile: Makefile.SH ../../config.sh config.res
	@echo "You must run 'sh Configure -S' or 'sh Configure'"
	exit 1

../../config.sh config.res:
	@echo "You must run 'sh Configure'"
	exit 1

lint:		

tags:

clean:		

elmiconv.h: $(INCLDIR)/elmshared.h  $(INCLDIR2)/cs_imp.h \
 $(INCLDIR2)/s_iconv.h
	cmp $(SRC)/$@ elmiconv.h 2>/dev/null || $(CP) $(SRC)/$@ $@
	$(CHMOD) u+w $@
	$(TOUCH) $@

iconv.o: elmiconv.h $(INCLDIR2)/rc_imp.h $(INCLDIR2)/save_opts.h

libiconv.a: $(OBJS)
	$(AR) r $@ $?
	$(RANLIB) $@

../../shlib/libelmme-iconv.so: $(OBJS)
	$(CC) $(LFLAGS) $(LIBDIRLIST) $(SONAME) -o $@ $(OBJS) $(ICONV_LINK)

$(INSTLIB): ../../shlib/libelmme-iconv.so
	$(REG) copy -m 644 $? $@

$(LIB)/elmrc-iconv-info: elmrc-iconv-info
	$(REG) copy -m 444 $? $@

!NO!SUBS!

