case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh

    ;;
esac

case "$subdir" in
'')
    case "$0" in
    */*) cd `expr X$0 : 'X\(.*\)/'` ;;
    esac	    

    vpathdef="#VPATH = "
    XXsrc="."
    XXsrcroot="../"
    ;;
*)
    vpathdef="VPATH = $source_dir/$subdir"
    XXsrc="$source_dir/$subdir"
    XXsrcroot="$source_dir"
    ;;
esac

case "$d_msgcat" in
define) installgencat="$gencat" ;;
*)      installgencat="gencat/gencat"
	;;
esac

echo "Extracting nls/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!
#!$make
#
# $Id: Makefile.SH,v 2.10 2016/04/17 18:13:38 hurtta Exp $
#
CP		=	$cp

LANGFILE=LANGS
CATNAME=elmme+2.5
GGENCAT=gencat/gencat
IGENCAT=$installgencat

$vpathdef
SRC		=	$XXsrc
SRCROOT		=	$XXsrcroot

!GROK!THIS!

cat >>Makefile <<'!NO!SUBS!'
HDIR=	../hdrs
SDIR=	$(SRC)/C/C/C
MSGCAT=	$(CATNAME).cat
HFILES=	$(HDIR)/s_aliases.h \
	$(HDIR)/s_elm.h \
	$(HDIR)/s_me.h \
	$(HDIR)/s_elmalias.h \
	$(HDIR)/s_elmrc.h \
	$(HDIR)/s_error.h \
	$(HDIR)/s_fastmail.h \
	$(HDIR)/s_from.h \
	$(HDIR)/s_newalias.h \
	$(HDIR)/s_newmail.h \
	$(HDIR)/s_readmsg.h \
	$(HDIR)/s_fbrowser.h \
	$(HDIR)/s_command.h \
	$(HDIR)/s_resolv.h \
	$(HDIR)/s_iconv.h \
	$(HDIR)/s_smtp.h \
	$(HDIR)/s_tls.h

MFILES=	$(SDIR)/s_aliases.m \
	$(SDIR)/s_elm.m \
	$(SDIR)/s_me.m \
	$(SDIR)/s_elmalias.m \
	$(SDIR)/s_elmrc.m \
	$(SDIR)/s_error.m \
	$(SDIR)/s_fastmail.m \
	$(SDIR)/s_from.m \
	$(SDIR)/s_newalias.m \
	$(SDIR)/s_newmail.m \
	$(SDIR)/s_readmsg.m \
        $(SDIR)/s_fbrowser.m \
	$(SDIR)/s_command.m \
	$(SDIR)/s_resolv.m \
	$(SDIR)/s_iconv.m \
	$(SDIR)/s_smtp.m \
	$(SDIR)/s_tls.m

nls-headers: clean $(HFILES)

# Nothing to do here.  The message catalogs all have the
# same basename, so wait until install to put them somewhere.
all:

install:
	./Install $(LANGFILE) $(IGENCAT) $(CATNAME)

$(HFILES): $(MFILES) $(GGENCAT)
	$(GGENCAT) $(MSGCAT) "$(SDIR)/`basename $@ .h`".m -h $@

copy-to-source: $(HFILES)
	$(CP) -uv $? $(SRCROOT)/hdrs/

clean: FRC
	/bin/rm -f $(MSGCAT)

FRC:

gencat/gencat:
	( cd gencat; make )
!NO!SUBS!
