static char rcsid[] = "@(#)$Id: mpar_leaf.c,v 2.6 2020/12/02 07:16:30 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "mpar_imp.h"

DEBUG_VAR(Debug,__FILE__,"mime");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

S_(mpar_alloc mpar_leaf_alloc)
static void mpar_leaf_alloc(D)
     struct mime_parser_data *D;
{
    D->p.any = NULL;
}

S_(mpar_free mpar_leaf_free)
static void mpar_leaf_free(D)
     struct mime_parser_data *D;
{
   D->p.any = NULL;
}

S_(mpar_parse mpar_leaf_parse)
static int mpar_leaf_parse P_((struct mime_parser_data *D,
			       struct mimeinfo *s,
			       charset_t defcharset,
			       FILE *fp,
			       struct header_errors **header_error,
			       int header_status,
			       struct header_rec * hdr));
static int mpar_leaf_parse(D,s,defcharset,fp,header_error,header_status,hdr)
     struct mime_parser_data *D;
     struct mimeinfo *s;
     charset_t defcharset;
     FILE *fp;
     struct header_errors **header_error;
     int header_status;
     struct header_rec * hdr;

{
    int ret = 1;         /* Always succeed ... */
    
    return ret;
}

S_(mpar_subparts mpar_leaf_subparts)
static int mpar_leaf_subparts(D)
     struct mime_parser_data *D;
{
     return 0;
}

S_(mpar_index mpar_leaf_index)
static struct mimeinfo *mpar_leaf_index(P,idx)
     struct mime_parser_data *P;
     int idx;
{

  panic("MIME PARSER PANIC",__FILE__,__LINE__,"mpar_leaf_index",
	"Index out of range",0);

  return NULL;
}

S_(mpar_copy mpar_leaf_copy)
static void mpar_leaf_copy(T,S)
     struct mime_parser_data *T;
     struct mime_parser_data *S;
{
    /* nothing */
}

static struct mime_parser leaf_PARSER = {
    mpar_leaf_alloc,
    mpar_leaf_free,
    mpar_leaf_parse,
    mpar_leaf_subparts,
    mpar_leaf_index,
    mpar_leaf_copy
};

#if __GNUC__ 
#define MTH        struct media_type_handle          
#define PARSER(A)   handle_mime_parser, { parser_code: & A }
#define CAST1       
#else
#define MTH        struct COMPAT_media_type_handle
#define PARSER(A)   handle_mime_parser, (void *) & A
#define CAST1       ( struct media_type_handle *)
#endif

static MTH  leaf_parser_1 = { PARSER(leaf_PARSER) };

void register_leaf_parser() {
   /* All except multipart */

     register_mt_defhandler(MIME_TYPE_LEAF, CAST1 &leaf_parser_1);

     /* for message/rfc822 there is own parser, it should apply
	before default parser...
     */
     register_mt_defhandler(MIME_TYPE_MESSAGE, CAST1 &leaf_parser_1);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
