static char rcsid[] = "@(#)$Id: mimewalk.c,v 2.10 2015/11/01 18:23:37 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.10 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI) 
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");

struct walk_handler * malloc_walk_handler(t)
     struct handler_type *t;
{

    struct walk_handler *ret;

    if (t->magic != WALKTYPE_magic) 
	panic("MALLOC PANIC",__FILE__,__LINE__,"malloc_walk_handler",
	      "Bad type magic number",0);
    
    ret = safe_malloc(sizeof(*ret));

    /* bzero is defined hdrs/elm_defs.h */
    bzero((void *)ret,sizeof (*ret));

    ret->magic        = WALKHANDLER_magic;
    ret->handler_type = t;
    ret->u.dummy  = NULL;

    ret->handler_type->mw_init(ret);

    return ret;
}

void free_walk_handler(ptr)
     struct walk_handler **ptr;
{
    if ((*ptr)->magic != WALKHANDLER_magic) 
	panic("MIME PANIC",__FILE__,__LINE__,"free_walk_handler",
	      "Bad magic number",0);
	
    if ((*ptr)->handler_type->magic != WALKTYPE_magic) 
	panic("MIME PANIC",__FILE__,__LINE__,"free_walk_handler",
	      "Bad type magic number",0);

    
    (*ptr)->handler_type->mw_free(*ptr);

    if ((*ptr)->u.dummy) 
	panic("MALLOC PANIC",__FILE__,__LINE__,"free_walk_handler",
	      "Data not free'ed",0);

    free(*ptr);
    *ptr = NULL;
}

void simple_mime_walk(ptr,handler,state_in,state_out,decode_opt,buffer_decoded)
     mime_t *ptr; 
     struct walk_handler *handler;
     struct in_state *state_in;
     struct out_state * state_out;   /* May be NULL */
     const struct decode_opts *decode_opt;
     enum mime_walk_buffer buffer_decoded;   
{
    int count;

    if (handler->magic != WALKHANDLER_magic) 
	panic("MIME PANIC",__FILE__,__LINE__,"simple_mime_walk",
	      "Bad magic number",0);
	
    if (handler->handler_type->magic != WALKTYPE_magic) 
	panic("MIME PANIC",__FILE__,__LINE__,"simple_mime_walk",
	      "Bad type magic number",0);

    if (ptr->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"simple_mime_walk",
		   "Bad mime magic number");
    
    if (!ptr->parser_data) 
	return;                     /* DATA not parsed */


    count = mime_parser_subparts(ptr->parser_data);
    
    /* Non leaf data is handled recursively */
    
    if (count > 0) {
	int i;

	for (i = 0; i < count; i++) {
	    mime_t *att        = mime_parser_index(ptr->parser_data,i);

	    simple_mime_walk(att,handler,state_in,state_out, decode_opt,buffer_decoded);
	}

	return;
    }

    DPRINT(Debug,11,(&Debug, 
		     "simple_mime_walk -> state: offset=%ld, length=%ld -- \n",
		     (long) ptr -> offset, (long) ptr -> length));


    if (state_in) {
	/* DECODE Content first */

	struct in_state * newstate2 = new_in_state(STATE_in_decode);
	int flags = 0;
	int errors = 0;

	if (buffer_decoded)
	    flags |= STATE_DECODE_buffer;   /* seek is used ? */
	
	if (!in_state_seekable(state_in)) {
	    mime_panic(__FILE__,__LINE__,"simple_mime_walk",
		       "unsupported input state");
	}


	if (in_state_fseek(state_in,ptr->offset) != 0) {
	    /* state_nlputs or state_printf is needed for EOLN_is_CRLF
	       conversions */

	    if (state_out) {
		struct pager_range *title_range = 
		    state_add_simple_pager_range(state_out,NULL,PR_MAX_WIDTH,0,
						 0);
		

		/* \n resets this */
		set_out_state_line_mode(state_out,pg_BOLD,title_range,1 /* Newline */); 
		state_puts("[ ",state_out);
		state_printf(state_out,
			     CATGETS(elm_msg_cat, MeSet, MeXSeekFailed,
				     "%s: seek failed"),
			     "simple_mime_walk");
		state_nlputs(" ]\n",state_out);

		free_pager_range(&title_range);
	       
	    }
	    lib_error(CATGETS(elm_msg_cat, MeSet, MeXSeekFailed,
			      "%s: seek failed"),
		      "simple_mime_walk");
	    
	    goto FAIL;
	}

	/* If state_out is NULL, or
	   state_out->filter == NULL then charset is not converted

	   state_out->filter tells input charset (ie. charset of 
	   mime type ....   messy??? )
	*/

	if (state_out)
	    set_out_state_filter(state_out,NULL); /* FORCE no conversion */

	if (set_in_state_decode_helper(ptr,state_in,newstate2,
				       flags,NULL)) {

	    FILE * fp = NULL;

	    if (buffer_decoded == mime_walk_need_fp) {
		/* Opens new handle FILE *, original handle is dup()ed, caller must fclose() */
		fp = file_handle_from_state_decode(newstate2);

		if (!fp)
		    goto FAIL;
	    }

	    errors = print_in_errors(state_in,state_out,decode_opt);
	    
	    handler->handler_type->mw_action(handler,ptr,
					     newstate2,fp,state_out);
	    
	    if (fp)
		fclose(fp); 
	}
	
    FAIL:

	errors += print_in_errors(state_in,state_out,decode_opt);

	DPRINT(Debug,11,(&Debug, 
			 "simple_mime_walk -> state: %d errors\n", errors));
 
	free_in_state(&newstate2);
  		
    } else
	handler->handler_type->mw_action(handler,ptr,NULL,NULL,state_out);
	    
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
