static char rcsid[] = "@(#)$Id: mime.c,v 2.6 2022/08/06 08:01:51 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.6 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI>
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "def_melib.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"mime");

#include <errno.h>

/* Notice that ENCODING_ILLEGAL is -1 
 */

char *mime_encode_names[ENCODING_count] = {
    "none", /* Not used. */
    "7bit",
    "8bit",
    "binary",
    "quoted-printable",
    "base64",
    "X-???",         /* ENCODING_EXPERIMENTAL */

    "x-uuencoded"
};


/* For debug */
char * mime_disposition_names[DISP_count] = {
    "inline",
    "attachment",

    "<auto attachment>"
};


void mime_panic(f,ln,pr,ms) 
     char * f;
     int ln;
     char *pr;
     char *ms;
{
    panic("MIME PANIC",f,ln,pr,ms,0);
}


int check_encoding(Encoding)
     char *Encoding;
{
    char *c, *d, tmp[VERY_LONG_STRING];
    int result =  ENCODING_ILLEGAL;
    
    DPRINT(Debug,9,(&Debug, 
		    "check_encoding(): Encoding=\"%s\"\n", Encoding));
    
    /* Don't harm "str" */
    strfcpy (tmp, Encoding, sizeof(tmp));
    
    rfc822_reap_comments (tmp, NULL, 0);
    c = tmp;
    d = tmp + strlen(tmp);
    
    while (d > tmp && whitespace(*(d-1)))
	d--;
    *d = '\0';
    while (*c && whitespace(*c))
	c++;
    
    if ('\0' == *c)
	result = ENCODING_7BIT;
    else if (strincmp(c, "x-", 2) == 0) { 
	result = ENCODING_EXPERIMENTAL;

	if (strincmp(c,"x-uue",5) == 0)
	    result = ENCODING_UUENCODED;

    } else {
	int i;
	for (i = ENCODING_7BIT; i < ENCODING_EXPERIMENTAL; i++) {
	    if (istrcmp(c, mime_encode_names[i]) == 0) {
		result = i;
		break;
	    }
	}
    }

    DPRINT(Debug,9,(&Debug, 
		    "check_encoding()=%s (%d)\n",
		    ENCODING(result),result));
    return(result);
}


/* Is mime type multipart/report; report-type=delivery-status; ? */

int mime_type_is_dsn(p)
     mime_t *p;
{
    if (p->magic != MIME_magic)
	mime_panic(__FILE__,__LINE__,"mime_type_is_dsn",
		   "Bad magic number");

    if (p->TYPE) {
	int Flags = get_type_flags(p->TYPE);

	DPRINT(Debug,13,(&Debug,
			 "mime_type_is_dsn(%p) << type: %p=%s/%s\n",
			 p,
			 p->TYPE,
			 get_major_type_name(p->TYPE),
			 get_subtype_name(p->TYPE)));

	if (Flags) {
	    DPRINT(Debug,13,(&Debug, "       Flags: %s%s%s%s%s%s%s\n",
			     (Flags & MIME_RFC822) ? " MIME_RFC822" : "",
			     (Flags & MIME_MIXED)  ? " MIME_MIXED" : "",
			     (Flags & MIME_DIGEST) ? " MIME_DIGEST" : "",
			     (Flags & MIME_ALTERNATIVE) ? " MIME_ALTERNATIVE" : "",
			     (Flags & MIME_SIGNED) ? " MIME_SIGNED" : "",
			     (Flags & MIME_ENCRYPTED) ? " MIME_ENCRYPTED" : "",
			     (Flags & MIME_REPORT)    ? " MIME_REPORT" : ""
			     ));
	}

	if (0 != (Flags & MIME_REPORT)) {

	    if (p->TYPE_opts) {
	    
		const char * pv = get_mime_param_compat(p->TYPE_opts,"report-type");

		if (pv) {
		    DPRINT(Debug,13,(&Debug, "       report-type: %s\n",pv));
		    
		    /* Is this case sensitive */
		    if (0 == istrcmp(pv,"delivery-status")) {
			
			DPRINT(Debug,13,(&Debug,
					 "mime_type_is_dsn(%p) = 1\n",
					 p));
			
			return 1;
		    }
		} else {
		    DPRINT(Debug,13,(&Debug, "       No report-type\n"));
		}
	    } else {
		DPRINT(Debug,13,(&Debug, "       No paramaters on type\n"));
	    }
	}	    
    }

    DPRINT(Debug,13,(&Debug,
		     "mime_type_is_dsn(%p) = 0\n",
		     p));
    
    return 0;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
