static char rcsid[] = "@(#)$Id: state_out_buffer.c,v 2.8 2023/12/13 16:55:32 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.8 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *
 *  
 *  Some code copied from lib/state.c. It have following note:
 *
 *     Initially written by: Michael Elkins <elkins@aero.org>, 1995
 *****************************************************************************/

#include "elm_defs.h"
#include "state_imp.h"
#include "pg_range_imp.h"

DEBUG_VAR(DebugIO,__FILE__,"stateio");

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif


S_(init_so_func init_so_buffer)
static void init_so_buffer P_((struct out_state *)); /* Prototype */
static void init_so_buffer(s)
     struct out_state *s;
{
    s->u.buffer             = NULL;
}

S_(dest_so_func dest_so_buffer)
static void dest_so_buffer P_((struct out_state *)); /* Prototype */
static void dest_so_buffer(s)
     struct out_state *s;
{
    s->u.buffer            = NULL;
}

void set_out_state_sbuffer(buffer,s)
     struct stringbuffer *buffer;
     struct out_state *s;  
{

    if (STATE_out_magic != s->magic)
	state_panic(__FILE__,__LINE__,"set_out_state_sbuffer","Bad magic number");

    if (STATE_out_buffer != s->state_type)
	state_panic(__FILE__,__LINE__,"set_out_state_sbuffer","Bad type");
    
    if (s->u.buffer       != NULL)
	state_panic(__FILE__,__LINE__,"set_out_state_sbuffer",
		    "Already called");

    s->u.buffer         = buffer;
}

S_(seekable_so_func seekable_so_buffer)
static int seekable_so_buffer P_((struct out_state *s));
static int seekable_so_buffer(s)
     struct out_state *s;
{
    return 0;
}

S_(FILE_so_func FILE_so_buffer)
FILE * FILE_so_buffer P_((struct out_state *s));
FILE * FILE_so_buffer(s)
     struct out_state *s;
{
    return NULL;
}

S_(seek_so_func seek_so_buffer)
static int seek_so_buffer P_((struct out_state *s, long pos));
static int seek_so_buffer(s,pos)
     struct out_state *s; 
     long pos;
{
    state_panic(__FILE__,__LINE__,"seek_so_file","seek_so_buffer called");

    return -1;
}

S_(ftell_so_func ftell_so_buffer)
static long ftell_so_buffer P_((struct out_state *s));
static long ftell_so_buffer(s) 
     struct out_state *s;
{
    state_panic(__FILE__,__LINE__,"ftell_so_file","ftell_so_buffer called");

    return -1;
}

S_(flush_filter_so_func flush_filter_so_buffer)
static void flush_filter_so_buffer P_((struct out_state *s, int munge_eoln,
				       int pg_flags, struct pager_range *range,
				       int force_eoln));
static void flush_filter_so_buffer(s,munge_eoln,pg_flags,range,force_eoln)
     struct out_state *s; 
     int munge_eoln;
     int pg_flags;
     struct pager_range *range;
     int force_eoln;
{
    int len = string_len(s->filter_line);
    int eoln = 0;
    
    if (len > 0) {   /* Remove LF from end */
	uint16 c = give_unicode_from_string(s->filter_line,len-1);
	struct string * t;
	int X = 0;

	if (0x000A == c) {
	    len--;
	    if (len > 0) {     /* And CR (ie. CRLF) from end */
		uint16 c = give_unicode_from_string(s->filter_line,len-1);
		if (0x000D == c)
		    len--;
	    }

	    eoln = 1;
	}
	t = clip_from_string(s->filter_line,&X,len);
	add_line_to_stringbuffer(s->u.buffer,t,pg_flags,range,eoln || force_eoln);
	free_string(&t);
    } else
	add_line_to_stringbuffer(s->u.buffer,s->filter_line,pg_flags,range,force_eoln);
    
    if (force_eoln)
	s->filter_on_BOL = force_eoln;
    else if (len > 0)
	s->filter_on_BOL = eoln;	
}

S_(policy_so_func policy_so_buffer)
static int policy_so_buffer P_((struct out_state *s, 
				enum state_policy question));

static int policy_so_buffer(s,question)
     struct out_state *s;
     enum state_policy question;
{
    switch(question) {
    case state_policy_putc_use_filter:  return 1;
    case state_policy_flush_via_put:    return 0;
    case state_policy_support_pg_flags: return 1;
    case state_policy_convert_entity:
	return 0;
	
    default:
	panic("STATE PANIC",__FILE__,__LINE__,"policy_so_buffer",
	      "Bad question",0);

    }

    return 0;
}

S_(putc_so_func putc_so_buffer)
static int putc_so_buffer P_((struct out_state *s, int ch));
static int putc_so_buffer(s,ch)
     struct out_state *s; 
     int ch;
{
    state_panic(__FILE__,__LINE__,"putc_so_file","putc_so_file called");

    return EOF;
    
}

S_(put_so_func put_so_buffer)
static int put_so_buffer P_((struct out_state *s, const char *string, int len));
static int put_so_buffer(s,string,len)
     struct out_state *s;
     const char *string; 
     int len;
{
    state_panic(__FILE__,__LINE__,"put_so_buffer","put_so_buffer called");

    return EOF;
}

S_(ferror_so_func  ferror_so_buffer)
static int ferror_so_buffer P_((struct out_state *s));
static int ferror_so_buffer(s)
     struct out_state *s;
{

    /* Not implemented */

    return 0;
}

S_(add_pager_range_func add_pager_range_buffer)
static void add_pager_range_buffer P_((struct out_state *s, 
				     struct pager_range *range));
static void add_pager_range_buffer(s,range) 
     struct out_state *s;
     struct pager_range *range;
{
    stringbuffer_add_pager_range(s->u.buffer,range);
}

S_(putentity_so_func putentity_so_buffer)
static enum sout_entity_result putentity_so_buffer P_((struct out_state *s,
						     struct out_entity *oe));
static enum sout_entity_result putentity_so_buffer(s,oe)
     struct out_state *s;
     struct out_entity *oe;
{
    enum sout_entity_result ret = sout_entity_fallback;

    /* Called if policy_so_buffer returns 0 for state_policy_convert_entity */
    
    enum stringbuffer_entity_result r;

    if (STATE_out_magic != s->magic)
	state_panic(__FILE__,__LINE__,"putentity_so_buffer",
		    "Bad magic number (out_state)");
   
    r = stringbuffer_add_entity(s->u.buffer,oe,
				s->pg_flags,
				s->pager_range);
					 
    switch (r) {
    case sb_entity_reference_key:  ret = sout_entity_reference_key; break;
    case sb_entity_fallback:       ret = sout_entity_fallback;      break;
    case sb_entity_failed:         ret = sout_entity_failed;        break;
    case sb_entity_succeed:        ret = sout_entity_succeed;       break;
    }

    return ret;
}

S_(add_pager_param_func add_pager_param_buffer)
static void add_pager_param_buffer P_((struct out_state *s, struct pager_range *range,
				     enum pager_param_opcode opcode,
				     struct pager_param_value * param_value));
static void add_pager_param_buffer(s,range,opcode,param_value)
     struct out_state *s;
     struct pager_range *range;
     enum pager_param_opcode opcode;
     struct pager_param_value * param_value;
{
    if (STATE_out_magic != s->magic)
	state_panic(__FILE__,__LINE__,"add_pager_param_buffer",
		    "Bad magic number (out_state)");

    stringbuffer_add_pager_param(s->u.buffer,range,opcode,param_value); 
    
}



struct out_state_type STATE_out_buffer_type = {
    OUT_STATE_type_magic,

    init_so_buffer,
    dest_so_buffer,
    seekable_so_buffer,
    FILE_so_buffer,
    seek_so_buffer,
    ftell_so_buffer,
    flush_filter_so_buffer,
    policy_so_buffer,
    putc_so_buffer,
    put_so_buffer,
    ferror_so_buffer,
    add_pager_range_buffer,
    putentity_so_buffer,
    add_pager_param_buffer
};

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
