static char rcsid[] = "@(#)$Id: shiftlower.c,v 2.4 2014/07/14 15:07:27 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 ******************************************************************************
 *  Based on Elm 2.4 lib/shiftlower.c. That code was following copyright:
 *
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"mem");

char *shift_lower(string)
     const char *string;
{
    /** return 'string' shifted to lower case.  Do NOT touch the
	actual string handed to us! **/
    
    static char buffer[VERY_LONG_STRING];
    char *bufptr = buffer;
    const char *src0 UNUSED_VAROK = string;
    
    if (string == NULL) {
	buffer[0] = 0;
	return( (char *) buffer);
    }

    for (; *string && bufptr - buffer < sizeof buffer; 
	 string++, bufptr++)
#ifdef ASCII_CTYPE
	if (isascii(string[i]))
#endif
	    *bufptr = tolower((unsigned char)*string);
    
    *bufptr = 0;
    
    if (*string != '\0') {
	DPRINT(Debug,1,(&Debug,
			"shift_lower: --- too long string (max=%d): %.30s...\n",
			sizeof buffer -1,src0));
    }
    
    
    return( (char *) buffer);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
