static char rcsid[] = "@(#)$Id: shared_connect.c,v 2.14 2022/11/02 16:26:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.14 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> (was hurtta+elm@posti.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

/*
 * This file is compiled only if dlopen() is available, so
 * that file does not need to be guarded with #ifdef 
 */

#include "elm_defs.h"

DEBUG_VAR(Debug,__FILE__,"dl");

#include "shared_imp.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "cs_imp.h"
#include "schedule_time.h"
#include "connection_imp.h"
#include "ss_imp.h"

#if ANSI_C
#define S_(x) static x;
#else
#define S_(x)
#endif

#define SHARED_CONNECT_magic	0xF901

S_(provides_initial_TLS_ra_f no_initial_TLS_ra)
static enum tls_ra_status no_initial_TLS_ra(ra,proto_name,
					    service_config,
					    sc_size)
    struct remote_account * ra;
    const char            * proto_name; /* for messages */
    struct SE_option      * service_config;
     size_t                  sc_size; 
{

    return tls_ra_unsupported;
}

S_(lookup_service_addresses_f no_lookup_service_addresses)
static enum address_lookup_status no_lookup_service_addresses 
    P_((const char                      * hostname,
	char                           ** rewrite,
	int                               translated_value
	/* -1 if not share specific */,
	const struct dt_enum_shared     * is_shared_value,
	size_t                            dt_enum_shared_size,
	struct service_entry_addr      ** addr_list,
	int                             * addr_count,
	size_t                            service_entry_addr_size,
	struct service_entry_name      ** aliases_list,
	int                             * aliases_count,
	size_t                            service_entry_name_size,
	const struct service_type       * service,
	const struct schedule_timelimit * now,
	size_t                            schedule_timelimit_size,
	const struct schedule_timelimit * default_valid_until /* for static hosts lookup */,
	int                             * was_error_p,
	struct cancel_data             ** cancel_p ));
static enum address_lookup_status no_lookup_service_addresses
   (hostname,rewrite,translated_value,is_shared_value,
    dt_enum_shared_size, addr_list,addr_count,
    service_entry_addr_size,aliases_list,aliases_count,
    service_entry_name_size,service,now,
    schedule_timelimit_size,default_valid_until,
    was_error_p,cancel_p
    )
     const char                     * hostname; 
     char                          ** rewrite;
     int                              translated_value  
     /* -1 if not share specific */;
     const struct dt_enum_shared    * is_shared_value;
     size_t                           dt_enum_shared_size;
     struct service_entry_addr     ** addr_list;
     int                            * addr_count;
     size_t                           service_entry_addr_size;
     struct service_entry_name     ** aliases_list;
     int                            * aliases_count;
     size_t                           service_entry_name_size;
     const struct service_type      * service;
     const struct schedule_timelimit * now;
     size_t                            schedule_timelimit_size;
     const struct schedule_timelimit * default_valid_until /* for static hosts lookup */;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p;
{
    return al_status_no_routine; /* no lookup name routine */
}


S_(notify_if_change_f no_notify_if_change)
static void no_notify_if_change P_((void));
static void no_notify_if_change() 
{
    /* No interface change notify routine */
}

struct sl_connect_data {
    uint16            magic;      

    provides_initial_TLS_ra_f  * initial_TLS_ra;
    lookup_service_addresses_f * lookup_service_addresses_p;
    notify_if_change_f         * notify_if_change_p; 

};


S_(sl_reg_functions sl_reg_connect)
static int sl_reg_connect P_((struct ImpInfo *i,
			      int reg_idx));
static int sl_reg_connect(i,reg_idx)
     struct ImpInfo *i;
     int reg_idx;
{
    /* union hack to avoid warnings about casting
     * between pointer-to-object and pointer-to-function
     */

    int res = 0;

    
    union F6 {
	void *                       ptr;
	provides_shared_SEOT_f     * f6;
    } f6;

    union F15 {
	void                      * ptr;
	provides_initial_TLS_ra_f * f15; 
    } f15;

    union F20 {
	void *                       ptr;
	lookup_service_addresses_f * f20;
    } f20;

    union F22 {
	void *                       ptr;
	notify_if_change_f         * f22;
    } f22;   
    
    struct reg_list *r = & (i->regs[reg_idx]);

    if (&use_shared_connect != r->var)
	panic("SHARED PANIC",__FILE__,__LINE__,
	      "sl_reg_connect",
	      "Wrong variable",0);
    
    if (r->r.connect->magic != SHARED_CONNECT_magic)
	panic("SHARED PANIC",__FILE__,__LINE__,
	      "sl_reg_connect",
	      "Bad magic bumber",0);

    f6.ptr  = dlsym(i->handle,  "provides_shared_SEOT");
    f15.ptr = dlsym(i->handle,  "provides_initial_TLS_ra");
    f20.ptr = dlsym(i->handle,  "lookup_service_addresses2");
    f22.ptr = dlsym(i->handle,  "notify_if_change");

    if (!f6.f6) {
	DPRINT(Debug,7,(&Debug, " ... NO provides_shared_SEOT\n"));
    }

    if (!f15.f15) {
	DPRINT(Debug,7,(&Debug, " ... NO provides_initial_TLS_ra\n"));
    }

    if (!f20.f20) {
	DPRINT(Debug,7,(&Debug, " ... NO lookup_service_addresses2\n"));
    }

    if (! f22.f22) {
	DPRINT(Debug,7,(&Debug, " ... NO notify_if_change\n"));
    }
    
#ifdef REMOTE_MBX

    if (f6.f6) {
	    int count,x;
	    size_t   s_res6;
	    struct SE_option_type ** res6 = f6.f6(&count, &s_res6);

	    if (s_res6 != sizeof (**res6)) {
		DPRINT(Debug,1,(&Debug,"... struct SE_option_type mismatch: %d should be %d\n",
				s_res6,sizeof (**res6)));
	    } else {
		shared_SE_option_types = 
		    safe_array_realloc(shared_SE_option_types,
				       (shared_SE_option_type_count + count),
				       sizeof (shared_SE_option_types[0]));

		DPRINT(Debug,7,(&Debug," ... provides_shared_SEOT:  (shared_SE_option_types) count %d\n",
				count));
		res = 1;
		
		for (x = 0; x < count; x++) {

		    if (res6[x]->magic != SE_option_t_magic) 
			panic("SHARED PANIC",__FILE__,__LINE__,
			      "sl_reg_connect",
			      "bad magic number on provides_shared_SEOT",0);


		    shared_SE_option_types[shared_SE_option_type_count
					  +x].T = res6[x];
		    shared_SE_option_types[shared_SE_option_type_count
					  +x].imp_idx = i;
		}
		shared_SE_option_type_count += count;
	    }
    }

    if (f15.f15) {
	r->r.connect->initial_TLS_ra = f15.f15;
	DPRINT(Debug,7,(&Debug, " ... provides_initial_TLS_ra\n"));
	res = 1;
    }

    if (f20.f20) {
	r->r.connect->lookup_service_addresses_p = f20.f20;
	
	res = 1;

	DPRINT(Debug,7,(&Debug," ... lookup_service_addresses2\n"));
    }

    if (f22.f22) {
	r->r.connect->notify_if_change_p = f22.f22;

	res = 1;

	DPRINT(Debug,7,(&Debug," ... notify_if_change\n"));
    }
    
#endif
	

    i->regs[reg_idx].valid   = res;
    
    DPRINT(Debug,7,(&Debug, 
		    "sl_reg_connect:  [%p]->regs[%d].valid = %d\n",
		    i,reg_idx,res));

   return res;
}

S_(sl_zero_reg_list sl_zero_connect)
static void sl_zero_connect P_((struct dt_shared_info *var,
				struct reg_list *r));
static void sl_zero_connect(var,r)
     struct dt_shared_info *var;
     struct reg_list *r;
{
    r->var     = var;
    r->valid   = 0;
    r->r.connect  = safe_malloc(sizeof (*r->r.connect));   /* never freed ... */
    r->r.connect->magic = SHARED_CONNECT_magic;
    r->r.connect->initial_TLS_ra = no_initial_TLS_ra;
    r->r.connect->lookup_service_addresses_p = no_lookup_service_addresses;
    r->r.connect->notify_if_change_p = no_notify_if_change;
}

S_(sl_unreg_functions sl_unreg_connect)
static void sl_unreg_connect P_((struct ImpInfo *i, int reg_idx));
static void sl_unreg_connect(i,reg_idx)
     struct ImpInfo *i; 
     int reg_idx;
{
    struct reg_list *r = & (i->regs[reg_idx] );
    r->valid   = 0;

}

static struct shared_loader connect_loader = {
    SHARED_LOADER_magic,
    sl_reg_connect,
    sl_zero_connect,
    sl_unreg_connect
};

SHAREDLIB use_shared_connect = {
    &connect_loader            /* loader */,
    0,                       
    NULL, 0,

    NULL
};

#ifdef REMOTE_MBX

enum itls_status initial_TLS_ra(ra,proto_name)
     struct remote_account * ra;
     const char            * proto_name; /* for messages */
{
    enum tls_ra_status ret = tls_ra_unsupported;
    enum tls_ra_status sticky_ret = tls_ra_unsupported;
    int i;

    if (REMOTE_ACCOUNT_magic != ra->magic) {
	panic("CONNECTION PANIC",__FILE__,__LINE__,
	      "initial_TLS_ra",
	      "Bad magic (remote_account)",0);
    }


    DPRINT(Debug,7,(&Debug, "initial_TLS_ra: proto=%s username=%s host=%s\n",
		    proto_name,
		    ra->username ? ra->username : "<NULL>",
		    ra->host ? ra->host : "<NULL>"));

    /* We must load all connect libraries */
    load_shared_libs1(&use_shared_connect); 

    /* And handle options */
    post_init_shared_options1(&use_shared_connect); 
    
    for (i = 0; i < use_shared_connect.shared_list_len; i++) {
	if (use_shared_connect.shared_list[i]->handle) {
	    int r = give_rnum(use_shared_connect.shared_list[i],
			      &use_shared_connect);

	    struct sl_connect_data * connect =
		use_shared_connect.shared_list[i]->regs[r].r.connect;

	    if (SHARED_CONNECT_magic != connect->magic)
		panic("SHARED PANIC",__FILE__,__LINE__,
		      "initial_TLS_ra",
		      "Bad magic bumber",0);

	    if (use_shared_connect.shared_list[i]->regs[r].valid) {
		struct SE_option       *config = NULL;
		struct SE_option_type  *T      = NULL;
		int j;

		for (j = 0; j < shared_SE_option_type_count; j++) {
		    if (shared_SE_option_types[j].imp_idx ==
			use_shared_connect.shared_list[i]) {

			T = shared_SE_option_types[j].T;

			DPRINT(Debug,8,(&Debug,
					"connect library [%d] %s have service option type %p\n",
					i,use_shared_connect.shared_list[i]->
					shname,
					T));

			if (SE_option_t_magic != T->magic) 
			    panic("CONNECTION PANIC",__FILE__,__LINE__,
				  "initial_TLS_ra",
				  "Bad magic (SE_option_type)",0);
		    }
		}	

		if (ra->service) {
		    if (SERVICE_ENTRY_magic != ra->service->magic)
			panic("CONNECTION PANIC",__FILE__,__LINE__,
			      "initial_TLS_ra",
			      "Bad magic (service_entry)",0);

		    for (j = 0; j < ra->service->option_count; j++) {
			if (ra->service->option_list[j].type == T) {
			    config = & (ra->service->option_list[j]);
			    
			    DPRINT(Debug,8,(&Debug,
					    "  ... have service config %p (%s)\n",
					    config,
					    config->prefix ? config->prefix : "NONE"));
			}
		    }		
		}

		switch ((ret = 
			 connect->initial_TLS_ra(ra,proto_name,
						 config,
						 sizeof(* config)))) {

		case tls_ra_unsupported:
		    /* try next library */
		    break;
		    
		case tls_ra_failed:
		    DPRINT(Debug,8,(&Debug,
				    "connect library [%d] %s failed to initialize TLS for %s\n",
				    i,use_shared_connect.shared_list[i]->shname,
				    proto_name));
		    goto out;
		case tls_ra_none:
		    DPRINT(Debug,8,(&Debug,
				    "connect library [%d] %s didn't initialized TLS for %s\n",
				    i,use_shared_connect.shared_list[i]->shname,
				    proto_name));
		    sticky_ret = ret;
		    /* try next library */
		    break;
		case tls_ra_done:
		    DPRINT(Debug,8,(&Debug,
				    "connect library [%d] %s initialized TLS for %s\n",
				    i,use_shared_connect.shared_list[i]->shname,
				    proto_name));
		    goto out;
		default:
		    DPRINT(Debug,1,(&Debug,
				    "connect library [%d] %s returned unexpec status %d when initializing TLS for %s\n",
				    i,use_shared_connect.shared_list[i]->shname,
				    ret,proto_name));
		    goto out;
		}		
	    }
	}

    }

    ret = sticky_ret;

 out:

    /* must "translate" return */

    switch(ret) {
    case tls_ra_unsupported:
	DPRINT(Debug,7,(&Debug, "initial_TLS_ra=itls_unsupported, proto=%s\n",
			proto_name));
	return itls_unsupported;

    default:
	DPRINT(Debug,7,(&Debug, "initial_TLS_ra: bad return value %d\n",
			ret));
	/* FALLTHROUGH */
    case tls_ra_failed:
	DPRINT(Debug,7,(&Debug, "initial_TLS_ra=itls_failed, proto=%s\n",
			proto_name));
	return itls_failed;
    case tls_ra_none:
	DPRINT(Debug,7,(&Debug, "initial_TLS_ra=itls_none, proto=%s\n",
			proto_name));
	return itls_none;
    case tls_ra_done:
	DPRINT(Debug,7,(&Debug, "initial_TLS_ra=itls_done, proto=%s\n",
			proto_name));
	return itls_done;
    }
}

static enum address_lookup_result process_one_address_lookup
   P_((const char                      * hostname,
       char                           ** rewrite,
       int                               translated_value,
       const struct dt_enum_shared     * is_shared_value,
       int                               var_index,
       struct service_entry_addr      ** addr_list,
       int                             * addr_count,
       struct service_entry_name      ** aliases_list,
       int                             * aliases_count,
       const struct service_type       * service,
       const struct schedule_timelimit * now,
       const struct schedule_timelimit * default_valid_until /* for static hosts lookup */,
       int                             * was_error_p,
       struct cancel_data             ** cancel_p
       ));

static enum address_lookup_result process_one_address_lookup(hostname,rewrite,
							     translated_value,
							     is_shared_value,
							     var_index,
							     addr_list,
							     addr_count,
							     aliases_list,
							     aliases_count,
							     service,now,
							     default_valid_until,
							     was_error_p,
							     cancel_p)
     const char                  * hostname;
     char                       ** rewrite;
     int                           translated_value;
     const struct dt_enum_shared * is_shared_value;
     int                           var_index;
     struct service_entry_addr  ** addr_list;
     int                         * addr_count;
     struct service_entry_name  ** aliases_list;
     int                         * aliases_count;
     const struct service_type   * service;
     const struct schedule_timelimit * now;
     const struct schedule_timelimit * default_valid_until /* for static hosts lookup */;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p   
     /* May be NULL, Used if dns lookup was cancelable */;
{
    if (var_index < 0 || var_index >= use_shared_connect.shared_list_len)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_address_lookup",
		  "Bad var index",0);

    if (use_shared_connect.shared_list[var_index]->handle) {
	int r = give_rnum(use_shared_connect.shared_list[var_index],
			  &use_shared_connect);

	struct sl_connect_data * connect =
	    use_shared_connect.shared_list[var_index]->regs[r].r.connect;
	
	if (SHARED_CONNECT_magic != connect->magic)
	    panic("SHARED PANIC",__FILE__,__LINE__,
		  "process_one_address_lookup",
		  "Bad magic bumber",0);

	if ( use_shared_connect.shared_list[var_index]->regs[r].valid)
	    return connect->lookup_service_addresses_p(hostname,
						       rewrite,
						       translated_value,
						       is_shared_value,
				      sizeof (struct dt_enum_shared),
						       addr_list,
						       addr_count,
				      sizeof (struct service_entry_addr),
						       aliases_list,
						       aliases_count,
				      sizeof (struct service_entry_name),
						       service,					     
						       now,
				      sizeof (struct schedule_timelimit),
						       default_valid_until,
						       was_error_p,
						       cancel_p
						       );
    }

    return al_status_no_routine;
}

enum address_lookup_result shared_address_lookup 
   (hostname,rewrite,tag,translated_value,is_shared_value,
    addr_list,addr_count,aliases_list,aliases_count,service,
    now,default_valid_until,
    was_error_p,cancel_p)
     const char                      * hostname;
     char                           ** rewrite;
     const char                      * tag;
     int                               translated_value;
     const struct dt_enum_shared     * is_shared_value;
     struct service_entry_addr      ** addr_list;
     int                             * addr_count;
     struct service_entry_name      ** aliases_list;
     int                             * aliases_count;
     const struct service_type       * service;     
     const struct schedule_timelimit * now;
     const struct schedule_timelimit * default_valid_until /* for static hosts lookup */;
     int                             * was_error_p;
     struct cancel_data             ** cancel_p
     /* May be NULL, Used if dns lookup was cancelable */;
{
    enum address_lookup_result r = address_lookup_no_routine;
    
    if (tag) {
	int basic_index = locate_and_load_library1(tag,
						   &use_shared_connect);
	
	if (basic_index < 0) {
	    DPRINT(Debug,9,(&Debug, 
			    "shared_address_lookup=%d al_status_no_routine: %s, tag %s not found\n",
			    al_status_no_routine,hostname,tag));
	    return al_status_no_routine;
	}

	post_init_shared_opt1(&use_shared_connect,basic_index);
	
	r =  process_one_address_lookup(hostname,rewrite,translated_value,
					is_shared_value,basic_index,
					addr_list,addr_count,
					aliases_list,aliases_count,
					service,now,default_valid_until,
					was_error_p,cancel_p);
	
	if (address_lookup_failed == r &&
	    cancel_p && *cancel_p && is_canceled(*cancel_p)) {
	    DPRINT(Debug,9,(&Debug,
			     "shared_address_lookup: %s: DNS lookup canceled\n",
			     hostname));

	    goto fail;
	}
	    
    } else { 
	enum address_lookup_result saved_r = address_lookup_no_routine;
	int i;
	
	/* must load all libraries */
	load_shared_libs1(&use_shared_connect);

	/* And handle options */
	post_init_shared_options1(&use_shared_connect); 

	
	for (i = 0; i < use_shared_connect.shared_list_len; i++) {

	    r = process_one_address_lookup(hostname,rewrite,-1,NULL,i,
					   addr_list,addr_count,
					   aliases_list,aliases_count,
					   service,now,default_valid_until,
					   was_error_p,cancel_p);

	    if (address_lookup_failed == r &&
		cancel_p && *cancel_p && is_canceled(*cancel_p)) {
		DPRINT(Debug,9,(&Debug,
				 "shared_address_lookup: %s: DNS lookup canceled\n",
				 hostname));
		
		goto fail;
	    }
	    
	    if (address_lookup_fallback == r)
		saved_r = r;
	    else if (address_lookup_no_routine != r)
		break;

	    if (rewrite && *rewrite) {
		free(*rewrite);
		*rewrite = NULL;
	    }
	}
	
	if (address_lookup_no_routine == r)
	    r = saved_r;
    }


 fail:
    DPRINT(Debug,9,(&Debug, 
		    "shared_address_lookup=%d",r));

    switch (r) {
    case  address_lookup_no_routine:
	DPRINT(Debug,9,(&Debug," address_lookup_no_routine"));
	break;
    case address_lookup_fallback:
	DPRINT(Debug,9,(&Debug," address_lookup_fallback"));
	break;	
    case address_lookup_failed:
	DPRINT(Debug,9,(&Debug," address_lookup_failed"));
	break;
    case address_lookup_not_found:
	DPRINT(Debug,9,(&Debug," address_lookup_not_found"));
	break;
    case address_lookup_done:
	DPRINT(Debug,9,(&Debug," address_lookup_done"));
	break;
    case address_lookup_bad_syntax:
	DPRINT(Debug,9,(&Debug," address_lookup_bad_syntax"));
	break;
    }

    DPRINT(Debug,9,(&Debug, 
		    ", *addr_count=%d *aliases_count=%d\n",
		    *addr_count,*aliases_count));

    return r;
}

void  shared_notify_if_change()
{
    int i;

    /* must load all libraries */
    load_shared_libs1(&use_shared_connect);

    /* And handle options */
    post_init_shared_options1(&use_shared_connect); 
    
    for (i = 0; i < use_shared_connect.shared_list_len; i++) {
	if (use_shared_connect.shared_list[i]->handle) {
	    int r = give_rnum(use_shared_connect.shared_list[i],
			      &use_shared_connect);

	    struct sl_connect_data * connect =
		use_shared_connect.shared_list[i]->regs[r].r.connect;
	    
	    if (SHARED_CONNECT_magic != connect->magic)
		panic("SHARED PANIC",__FILE__,__LINE__,
		      "shared_notify_if_change",
		      "Bad magic bumber",0);
	    
	    if (use_shared_connect.shared_list[i]->regs[r].valid) {
		connect->notify_if_change_p();
	    }	    
	}
    }
}


#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
