static char rcsid[] = "@(#)$Id: safeopen.c,v 2.7 2021/07/07 16:28:00 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.7 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                       (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *           or  Kari Hurtta <elm@elmme-mailer.org>
 *
 *  Initially written by: Zoltan Hidvegi <hzoli@cs.elte.hu>
 *****************************************************************************/

#include "elm_defs.h"

#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif



DEBUG_VAR(Debug,__FILE__,"core");

static int safeopen_core P_((char *name,int *errno_res, int access_mode));
static int safeopen_core(name,errno_res,access_mode)
     char *name;
     int *errno_res;
     int access_mode;
{
    int fd = open(name, access_mode | O_CREAT | O_EXCL, 0600);

    if (errno_res)
	*errno_res = 0;

    if (fd < 0 ) {
	int err = errno;
	
	enum syscall_status r;

	DPRINT(Debug,8, (&Debug,
			 "safeopen_core: initial open %s: %s\n",
			 name,strerror(err)));

	if (errno_res)
	    *errno_res = err;

	
	r = unlink(name);

	switch (r) {
	case syscall_success:

	    DPRINT(Debug,8, (&Debug,
			     "safeopen_core: unlink %s succeed\n",
			     name));
	    
	    fd = open(name, access_mode | O_CREAT | O_EXCL, 0600);
	
	    if (fd < 0 ) {
		err = errno;
    
		DPRINT(Debug,8, (&Debug,
				 "safeopen_core: second open %s: %s\n",
				 name,strerror(err)));
		if (errno_res)
		    *errno_res = err;

		return -1;
	    }
	    
	    DPRINT(Debug,8, (&Debug,
			     "safeopen_core: second open %s succeed\n",
			     name));

	    break;
	    
	case syscall_error:
	    err = errno;

	    DPRINT(Debug,8, (&Debug,
			     "safeopen_core: unlink %s: %s\n",
			     name, strerror(err)));
	    
	    return -1;
	}
    } else {
	DPRINT(Debug,8, (&Debug,
			 "safeopen_core: initial open %s succeed\n",
			 name));
	
    }

    
    DPRINT(Debug,8, (&Debug,
		     "safeopen_core=%d%s\n",
		     fd,
		     fd >= 0 ? " (succeed)" : ""));
	    
    return fd;
}


FILE *safeopen(name,errno_res)
     char *name;
     int *errno_res;
{
    FILE *fp;
    int fd = safeopen_core(name,errno_res,O_WRONLY);

    if (fd < 0) {
	DPRINT(Debug,8, (&Debug,
			"safeopen %s fails\n",
			name));
	
	return NULL;
    }

    if (! (fp = fdopen(fd, "w"))) {
	int err = errno;
	
	DPRINT(Debug,8, (&Debug,
			"safeopen %s fails: fdopen %d gives: %s\n",
			name,fd,strerror(err)));
	
	if (errno_res)
	    *errno_res = err;
	
      close(fd);
      unlink(name);
      
      return NULL;
    }

    DPRINT(Debug,8, (&Debug,
		    "safeopen %s succeed\n",
		    name));
    
    return fp;
}

FILE *safeopen_rdwr(name,errno_res)
     char *name;
     int *errno_res;
{
    FILE *fp;
    int fd =  safeopen_core(name,errno_res,O_RDWR);

    if (fd < 0) {
	DPRINT(Debug,8, (&Debug,
			"safeopen_rdwr %s fails\n",
			name));
	
	return NULL;
    }
    
    if (! (fp = fdopen(fd, "w+"))) {
	int err = errno;
	
	DPRINT(Debug,8, (&Debug,
			"safeopen_rdwr %s fails: fdopen %d gives: %s\n",
			name,fd,strerror(err)));
	
	if (errno_res)
	    *errno_res = err;
	
	
	close(fd);
	unlink(name);
	
	return NULL;
    }

    DPRINT(Debug,8, (&Debug,
		    "safeopen_rdwr %s succeed\n",
		    name));
        
    return fp;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
