static char rcsid[] = "@(#)$Id: mmaputil.c,v 2.4 2014/07/14 15:07:26 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 2.4 $   $State: Exp $
 *
 *  Author: Kari Hurtta <hurtta+elm@siilo.FMI.FI> 
 *                  (was hurtta+elm@posti.FMI.FI, hurtta+elm@ozone.FMI.FI)
 *      or  Kari Hurtta <elm@elmme-mailer.org>
 *****************************************************************************/

#include "elm_defs.h"
#include "mmaputil.h"
#include <errno.h>
#ifndef ANSI_C
extern int errno;
#endif

DEBUG_VAR(Debug,__FILE__,"charset");

uint16 SWAP (b)
     int b;
{
    union {
	uint16 a;
	unsigned char c[2];
    } d;
    unsigned char tmp;
    d.a = b;
   
    if (sizeof d.a != 2) {
	panic("MMAP PANIC",__FILE__,__LINE__,"SWAP",
	      "sizeof uint16 !=2 -- 'Configure' error!",0);
    }
    tmp = d.c[0]; d.c[0] = d.c[1]; d.c[1] = tmp;
    return d.a;
}


uint16 pages(len,pagesize)
     size_t len;
     int pagesize; 
{
    uint16 result = len / pagesize;

    if (len % pagesize != 0)
	result++;
    return result;
}

int write_range(fd,offset,length,ptr)
     int fd; 
     off_t offset; 
     size_t length;
     unsigned char *ptr;
{
    int status = 1;

    if (-1 == lseek(fd,offset,SEEK_SET)) {
	int err UNUSED_VAROK = errno;
	status = 0;

	DPRINT(Debug,5,(&Debug,"unidata: lseek failed: errno=%d (%s)\n", \
			err,strerror(err))); 

	goto fail;
    }

    while (length > 0) {
	int n = write(fd,ptr,length);

	if (-1 == n) {
	    int err UNUSED_VAROK = errno;
	    status = 0;

	    DPRINT(Debug,5,(&Debug,"unidata: write failed: errno=%d (%s)\n", \
			    err,strerror(err))); 

	    goto fail;
	}
	length -= n;
	ptr    += n;
    }

 fail:
    return status;
}


int read_range(fd,offset,length,ptr)
     int fd; 
     off_t offset; 
     size_t length;
     unsigned char *ptr;
{
    int status = 1;
    if (-1 == lseek(fd,offset,SEEK_SET)) {
	status = 0;
	goto fail;
    }

    while (length > 0) {
	int n = read(fd,ptr,length);

	if (-1 == n) {
	    status = 0;
	    goto fail;
	}
	if (0 == n) {
	    errno = EINVAL;  /* Simulate error */
	    status = 0;
	    goto fail;
	}

	length -= n;
	ptr    += n;
    }

 fail:
    return status;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 *  buffer-file-coding-system: iso-8859-1
 * End:
 */
